/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseLazyObjectFactory;
import org.apache.hadoop.hive.hbase.HBaseRowSerializer;
import org.apache.hadoop.hive.hbase.HBaseSerDeParameters;
import org.apache.hadoop.hive.hbase.LazyHBaseRow;
import org.apache.hadoop.hive.hbase.PutWritable;
import org.apache.hadoop.hive.hbase.ResultWritable;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types", "field.delim", "collection.delim", "mapkey.delim", "serialization.format", "serialization.null.format", "serialization.escape.crlf", "serialization.last.column.takes.rest", "escape.delim", "serialization.encoding", "hive.serialization.extend.nesting.levels", "hive.serialization.extend.additional.nesting.levels", "hbase.columns.mapping", "hbase.table.name", "hbase.table.default.storage.type", ":key", "hbase.put.timestamp", "hbase.composite.key.class", "hbase.composite.key.types", "hbase.composite.key.factory", "hbase.struct.serialization.class", "hbase.scan.cache", "hbase.scan.cacheblock", "hbase.scan.batch", "hbase.struct.autogenerate"})
public class HBaseSerDe
extends AbstractSerDe {
    public static final Logger LOG = LoggerFactory.getLogger(HBaseSerDe.class);
    public static final String HBASE_COLUMNS_MAPPING = "hbase.columns.mapping";
    public static final String HBASE_TABLE_NAME = "hbase.table.name";
    public static final String HBASE_TABLE_DEFAULT_STORAGE_TYPE = "hbase.table.default.storage.type";
    public static final String HBASE_KEY_COL = ":key";
    public static final String HBASE_TIMESTAMP_COL = ":timestamp";
    public static final String HBASE_PUT_TIMESTAMP = "hbase.put.timestamp";
    public static final String HBASE_COMPOSITE_KEY_CLASS = "hbase.composite.key.class";
    public static final String HBASE_COMPOSITE_KEY_TYPES = "hbase.composite.key.types";
    public static final String HBASE_COMPOSITE_KEY_FACTORY = "hbase.composite.key.factory";
    public static final String HBASE_STRUCT_SERIALIZER_CLASS = "hbase.struct.serialization.class";
    public static final String HBASE_SCAN_CACHE = "hbase.scan.cache";
    public static final String HBASE_SCAN_CACHEBLOCKS = "hbase.scan.cacheblock";
    public static final String HBASE_SCAN_BATCH = "hbase.scan.batch";
    public static final String HBASE_AUTOGENERATE_STRUCT = "hbase.struct.autogenerate";
    public static final String HBASE_COLUMNS_REGEX_MATCHING = "hbase.columns.mapping.regex.matching";
    public static final String SERIALIZATION_TYPE = "serialization.type";
    public static final String HBASE_COLUMNS_PREFIX_HIDE = "hbase.columns.mapping.prefix.hide";
    private ObjectInspector cachedObjectInspector;
    private LazyHBaseRow cachedHBaseRow;
    private HBaseSerDeParameters serdeParams;
    private HBaseRowSerializer serializer;

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass()) + "[" + String.valueOf(this.serdeParams) + "]";
    }

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.serdeParams = new HBaseSerDeParameters(configuration, tableProperties, ((Object)((Object)this)).getClass().getName());
        this.cachedObjectInspector = HBaseLazyObjectFactory.createLazyHBaseStructInspector(this.serdeParams, tableProperties);
        this.cachedHBaseRow = new LazyHBaseRow((LazySimpleStructObjectInspector)this.cachedObjectInspector, this.serdeParams);
        this.serializer = new HBaseRowSerializer(this.serdeParams);
        LOG.debug("HBaseSerDe initialized with : {}", (Object)this.serdeParams);
    }

    public static ColumnMappings parseColumnsMapping(String columnsMappingSpec) throws SerDeException {
        return HBaseSerDe.parseColumnsMapping(columnsMappingSpec, true);
    }

    public static ColumnMappings parseColumnsMapping(String columnsMappingSpec, boolean doColumnRegexMatching) throws SerDeException {
        return HBaseSerDe.parseColumnsMapping(columnsMappingSpec, doColumnRegexMatching, false);
    }

    public static ColumnMappings parseColumnsMapping(String columnsMappingSpec, boolean doColumnRegexMatching, boolean hideColumnPrefix) throws SerDeException {
        if (columnsMappingSpec == null) {
            throw new SerDeException("Error: hbase.columns.mapping missing for this HBase table.");
        }
        if (columnsMappingSpec.isEmpty() || columnsMappingSpec.equals(HBASE_KEY_COL)) {
            throw new SerDeException("Error: hbase.columns.mapping specifies only the HBase table row key. A valid Hive-HBase table must specify at least one additional column.");
        }
        int rowKeyIndex = -1;
        int timestampIndex = -1;
        ArrayList<ColumnMappings.ColumnMapping> columnsMapping = new ArrayList<ColumnMappings.ColumnMapping>();
        String[] columnSpecs = columnsMappingSpec.split(",");
        for (int i = 0; i < columnSpecs.length; ++i) {
            String mappingSpec = columnSpecs[i].trim();
            String[] mapInfo = mappingSpec.split("#");
            String colInfo = mapInfo[0];
            int idxFirst = colInfo.indexOf(":");
            int idxLast = colInfo.lastIndexOf(":");
            if (idxFirst < 0 || idxFirst != idxLast) {
                throw new SerDeException("Error: the HBase columns mapping contains a badly formed column family, column qualifier specification.");
            }
            ColumnMappings.ColumnMapping columnMapping = new ColumnMappings.ColumnMapping();
            if (colInfo.equals(HBASE_KEY_COL)) {
                rowKeyIndex = i;
                columnMapping.familyName = colInfo;
                columnMapping.familyNameBytes = Bytes.toBytes((String)colInfo);
                columnMapping.qualifierName = null;
                columnMapping.qualifierNameBytes = null;
                columnMapping.hbaseRowKey = true;
            } else if (colInfo.equals(HBASE_TIMESTAMP_COL)) {
                timestampIndex = i;
                columnMapping.familyName = colInfo;
                columnMapping.familyNameBytes = Bytes.toBytes((String)colInfo);
                columnMapping.qualifierName = null;
                columnMapping.qualifierNameBytes = null;
                columnMapping.hbaseTimestamp = true;
            } else {
                String[] parts = colInfo.split(":");
                assert (parts.length > 0 && parts.length <= 2);
                columnMapping.familyName = parts[0];
                columnMapping.familyNameBytes = Bytes.toBytes((String)parts[0]);
                columnMapping.hbaseRowKey = false;
                columnMapping.hbaseTimestamp = false;
                if (parts.length == 2) {
                    if (doColumnRegexMatching && parts[1].endsWith(".*")) {
                        columnMapping.qualifierPrefix = parts[1].substring(0, parts[1].length() - 2);
                        columnMapping.qualifierPrefixBytes = Bytes.toBytes((String)columnMapping.qualifierPrefix);
                        columnMapping.doPrefixCut = hideColumnPrefix;
                        columnMapping.qualifierName = null;
                        columnMapping.qualifierNameBytes = null;
                    } else {
                        columnMapping.qualifierName = parts[1];
                        columnMapping.qualifierNameBytes = Bytes.toBytes((String)parts[1]);
                        columnMapping.doPrefixCut = false;
                    }
                } else {
                    columnMapping.qualifierName = null;
                    columnMapping.qualifierNameBytes = null;
                }
            }
            columnMapping.mappingSpec = mappingSpec;
            columnsMapping.add(columnMapping);
        }
        if (rowKeyIndex == -1) {
            rowKeyIndex = 0;
            ColumnMappings.ColumnMapping columnMapping = new ColumnMappings.ColumnMapping();
            columnMapping.familyName = HBASE_KEY_COL;
            columnMapping.familyNameBytes = Bytes.toBytes((String)HBASE_KEY_COL);
            columnMapping.qualifierName = null;
            columnMapping.qualifierNameBytes = null;
            columnMapping.hbaseRowKey = true;
            columnMapping.mappingSpec = HBASE_KEY_COL;
            columnsMapping.add(0, columnMapping);
        }
        return new ColumnMappings(columnsMapping, rowKeyIndex, timestampIndex);
    }

    public LazySerDeParameters getSerdeParams() {
        return this.serdeParams.getSerdeParams();
    }

    public HBaseSerDeParameters getHBaseSerdeParam() {
        return this.serdeParams;
    }

    public Object deserialize(Writable result) throws SerDeException {
        if (!(result instanceof ResultWritable)) {
            throw new SerDeException(((Object)((Object)this)).getClass().getName() + ": expects ResultWritable!");
        }
        this.cachedHBaseRow.init(((ResultWritable)result).getResult());
        return this.cachedHBaseRow;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return PutWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        try {
            return this.serializer.serialize(obj, objInspector);
        }
        catch (SerDeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public HBaseKeyFactory getKeyFactory() {
        return this.serdeParams.getKeyFactory();
    }

    public static void configureJobConf(TableDesc tableDesc, JobConf jobConf) throws Exception {
        HBaseSerDeParameters serdeParams = new HBaseSerDeParameters((Configuration)jobConf, tableDesc.getProperties(), HBaseSerDe.class.getName());
        serdeParams.getKeyFactory().configureJobConf(tableDesc, jobConf);
    }
}

