/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LdapURL {
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final int DEFAULT_LDAPS_PORT = 636;
    private static final String DEFAULT_DELIMITER = " ";
    private final List<Entry> ldapEntries = new ArrayList<Entry>();

    public LdapURL(String url) {
        this(url, DEFAULT_DELIMITER);
    }

    public LdapURL(String url, String delimiter) {
        String[] urls;
        String[] arr$ = urls = url.split(delimiter);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s;
            String hostname = s = arr$[i$];
            int port = 389;
            if (hostname.startsWith("ldap://")) {
                hostname = hostname.substring("ldap://".length());
            } else if (hostname.startsWith("ldaps://")) {
                hostname = hostname.substring("ldaps://".length());
                port = 636;
            }
            if (hostname.contains(":")) {
                port = Integer.parseInt(hostname.substring(hostname.indexOf(":") + 1, hostname.length()));
                hostname = hostname.substring(0, hostname.indexOf(":"));
            }
            this.ldapEntries.add(new Entry(hostname, port));
        }
    }

    public Entry getEntry() {
        return this.ldapEntries.get(0);
    }

    public Entry getLastEntry() {
        return this.ldapEntries.get(this.ldapEntries.size() - 1);
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.ldapEntries);
    }

    public String[] getEntriesAsString() {
        String[] entries = new String[this.ldapEntries.size()];
        for (int i = 0; i < this.ldapEntries.size(); ++i) {
            entries[i] = this.ldapEntries.get(i).getHostname();
        }
        return entries;
    }

    public int size() {
        return this.ldapEntries.size();
    }

    public String toString() {
        return String.format("[%s@%d::ldapEntries=%s]", this.getClass().getName(), this.hashCode(), this.ldapEntries);
    }

    public static class Entry {
        private final String hostname;
        private final int port;

        public Entry(String h, int p) {
            this.hostname = h;
            this.port = p;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getHostnameWithPort() {
            return String.format("%s:%s", this.hostname, this.port);
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return String.format("[%s@%d::hostname=%s, port=%s]", this.getClass().getName(), this.hashCode(), this.hostname, this.port);
        }
    }
}

