/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;

public class AtlasEnumType
extends AtlasType {
    private final AtlasEnumDef enumDef;
    private final Map<String, AtlasEnumDef.AtlasEnumElementDef> elementDefs;
    private final String defaultValue;

    public AtlasEnumType(AtlasEnumDef enumDef) {
        super(enumDef);
        HashMap<String, AtlasEnumDef.AtlasEnumElementDef> e = new HashMap<String, AtlasEnumDef.AtlasEnumElementDef>();
        for (AtlasEnumDef.AtlasEnumElementDef elementDef : enumDef.getElementDefs()) {
            e.put(elementDef.getValue().toLowerCase(), elementDef);
        }
        String d = enumDef.getDefaultValue();
        if (d == null) {
            AtlasEnumDef.AtlasEnumElementDef defElem;
            AtlasEnumDef.AtlasEnumElementDef atlasEnumElementDef = defElem = enumDef.getElementDefs().size() > 0 ? enumDef.getElementDefs().get(0) : null;
            if (defElem != null) {
                d = defElem.getValue();
            }
        }
        this.enumDef = enumDef;
        this.elementDefs = Collections.unmodifiableMap(e);
        this.defaultValue = d;
    }

    public AtlasEnumDef getEnumDef() {
        return this.enumDef;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
    }

    @Override
    public Object createDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            return this.elementDefs.containsKey(obj.toString().toLowerCase());
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        AtlasEnumDef.AtlasEnumElementDef elementDef;
        if (obj != null && (elementDef = this.elementDefs.get(obj.toString().toLowerCase())) != null) {
            return elementDef.getValue();
        }
        return null;
    }

    public AtlasEnumDef.AtlasEnumElementDef getEnumElementDef(String value) {
        if (value != null) {
            return this.elementDefs.get(value.toLowerCase());
        }
        return null;
    }

    public AtlasEnumDef.AtlasEnumElementDef getEnumElementDef(Number ordinal) {
        if (ordinal != null) {
            for (AtlasEnumDef.AtlasEnumElementDef elementDef : this.elementDefs.values()) {
                if (elementDef.getOrdinal().longValue() != ordinal.longValue()) continue;
                return elementDef;
            }
        }
        return null;
    }
}

