/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.security.kerberos;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KerberosName {
    private static final Pattern NAME_PARSER = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");
    private final String serviceName;
    private final String hostName;
    private final String realm;

    public KerberosName(String serviceName, String hostName, String realm) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        this.serviceName = serviceName;
        this.hostName = hostName;
        this.realm = realm;
    }

    public static KerberosName parse(String principalName) {
        Matcher match = NAME_PARSER.matcher(principalName);
        if (!match.matches()) {
            if (principalName.contains("@")) {
                throw new IllegalArgumentException("Malformed Kerberos name: " + principalName);
            }
            return new KerberosName(principalName, null, null);
        }
        return new KerberosName(match.group(1), match.group(3), match.group(4));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.serviceName);
        if (this.hostName != null) {
            result.append('/');
            result.append(this.hostName);
        }
        if (this.realm != null) {
            result.append('@');
            result.append(this.realm);
        }
        return result.toString();
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String hostName() {
        return this.hostName;
    }

    public String realm() {
        return this.realm;
    }
}

