/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public enum SslClientAuth {
    REQUIRED,
    REQUESTED,
    NONE;

    public static final List<SslClientAuth> VALUES;

    public static SslClientAuth forConfig(String key) {
        if (key == null) {
            return NONE;
        }
        String upperCaseKey = key.toUpperCase(Locale.ROOT);
        for (SslClientAuth auth : VALUES) {
            if (!auth.name().equals(upperCaseKey)) continue;
            return auth;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(SslClientAuth.values()));
    }
}

