/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class SeekableByteArrayInputStream
extends InputStream {
    private volatile byte[] buffer;
    private int cur;
    private int max;

    @Override
    public int read() {
        if (this.cur < this.max) {
            return this.buffer[this.cur++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int offset, int length) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (length < 0 || offset < 0 || length > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int avail = this.max - this.cur;
        if (avail <= 0) {
            return -1;
        }
        if (length > avail) {
            length = avail;
        }
        System.arraycopy(this.buffer, this.cur, b, offset, length);
        this.cur += length;
        return length;
    }

    @Override
    public long skip(long requestedSkip) {
        long actualSkip = this.max - this.cur;
        if (requestedSkip < actualSkip) {
            actualSkip = requestedSkip < 0L ? 0L : requestedSkip;
        }
        this.cur = (int)((long)this.cur + actualSkip);
        return actualSkip;
    }

    @Override
    public int available() {
        return this.max - this.cur;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
    }

    public SeekableByteArrayInputStream(byte[] buf) {
        Objects.requireNonNull(buf, "bug argument was null");
        this.buffer = buf;
        this.cur = 0;
        this.max = buf.length;
    }

    public SeekableByteArrayInputStream(byte[] buf, int maxOffset) {
        Objects.requireNonNull(buf, "bug argument was null");
        this.buffer = buf;
        this.cur = 0;
        this.max = maxOffset;
    }

    public void seek(int position) {
        if (position < 0 || position >= this.max) {
            throw new IllegalArgumentException("position = " + position + " maxOffset = " + this.max);
        }
        this.cur = position;
    }

    public int getPosition() {
        return this.cur;
    }

    byte[] getBuffer() {
        return this.buffer;
    }
}

