/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSanityCheck {
    private static final Logger log = LoggerFactory.getLogger(ConfigSanityCheck.class);
    private static final String PREFIX = "BAD CONFIG ";
    private static final Property INSTANCE_DFS_URI = Property.INSTANCE_DFS_URI;
    private static final Property INSTANCE_DFS_DIR = Property.INSTANCE_DFS_DIR;

    public static void validate(Iterable<Map.Entry<String, String>> entries) {
        String instanceZkTimeoutValue = null;
        boolean usingVolumes = false;
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            Property prop = Property.getPropertyByKey(entry.getKey());
            if (prop == null && Property.isValidPropertyKey(key)) continue;
            if (prop == null) {
                log.warn("BAD CONFIG unrecognized property key (" + key + ")");
            } else if (prop.getType() == PropertyType.PREFIX) {
                ConfigSanityCheck.fatal("BAD CONFIG incomplete property key (" + key + ")");
            } else if (!prop.getType().isValidFormat(value)) {
                ConfigSanityCheck.fatal("BAD CONFIG improperly formatted value for key (" + key + ", type=" + (Object)((Object)prop.getType()) + ") : " + value);
            }
            if (key.equals(Property.INSTANCE_ZK_TIMEOUT.getKey())) {
                instanceZkTimeoutValue = value;
            }
            if (!key.equals(Property.INSTANCE_VOLUMES.getKey())) continue;
            usingVolumes = value != null && !value.isEmpty();
        }
        if (instanceZkTimeoutValue != null) {
            ConfigSanityCheck.checkTimeDuration(Property.INSTANCE_ZK_TIMEOUT, instanceZkTimeoutValue, new CheckTimeDurationBetween(1000L, 300000L));
        }
        if (!usingVolumes) {
            log.warn("Use of " + (Object)((Object)INSTANCE_DFS_URI) + " and " + (Object)((Object)INSTANCE_DFS_DIR) + " are deprecated. Consider using " + (Object)((Object)Property.INSTANCE_VOLUMES) + " instead.");
        }
    }

    private static void checkTimeDuration(Property prop, String value, CheckTimeDuration chk) {
        ConfigSanityCheck.verifyPropertyTypes(PropertyType.TIMEDURATION, prop);
        if (!chk.check(AccumuloConfiguration.getTimeInMillis(value))) {
            ConfigSanityCheck.fatal(PREFIX + chk.getDescription(prop));
        }
    }

    private static void verifyPropertyTypes(PropertyType type, Property ... properties) {
        for (Property prop : properties) {
            if (prop.getType() == type) continue;
            ConfigSanityCheck.fatal("Unexpected property type (" + (Object)((Object)prop.getType()) + " != " + (Object)((Object)type) + ")");
        }
    }

    private static void fatal(String msg) {
        log.error("FATAL: {}", (Object)msg);
        throw new SanityCheckException(msg);
    }

    public static class SanityCheckException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SanityCheckException(String msg) {
            super(msg);
        }
    }

    private static class CheckTimeDurationBetween
    implements CheckTimeDuration {
        long min;
        long max;

        CheckTimeDurationBetween(long x, long y) {
            this.min = Math.min(x, y);
            this.max = Math.max(x, y);
        }

        @Override
        public boolean check(long propVal) {
            return propVal >= this.min && propVal <= this.max;
        }

        @Override
        public String getDescription(Property prop) {
            return "ensure " + this.min + " <= " + (Object)((Object)prop) + " <= " + this.max;
        }
    }

    private static interface CheckTimeDuration {
        public boolean check(long var1);

        public String getDescription(Property var1);
    }
}

