/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.rfile.FSConfArgs;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileScanner;
import org.apache.accumulo.core.client.rfile.RFileSource;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class RFileScannerBuilder
implements RFile.InputArguments,
RFile.ScannerFSOptions {
    private RFileScanner.Opts opts = new RFileScanner.Opts();

    RFileScannerBuilder() {
    }

    @Override
    public RFile.ScannerOptions withoutSystemIterators() {
        this.opts.useSystemIterators = false;
        return this;
    }

    @Override
    public RFile.ScannerOptions withAuthorizations(Authorizations auths) {
        Objects.requireNonNull(auths);
        this.opts.auths = auths;
        return this;
    }

    @Override
    public RFile.ScannerOptions withDataCache(long cacheSize) {
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0);
        this.opts.dataCacheSize = cacheSize;
        return this;
    }

    @Override
    public RFile.ScannerOptions withIndexCache(long cacheSize) {
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0);
        this.opts.indexCacheSize = cacheSize;
        return this;
    }

    @Override
    public Scanner build() {
        return new RFileScanner(this.opts);
    }

    @Override
    public RFile.ScannerOptions withFileSystem(FileSystem fs) {
        Objects.requireNonNull(fs);
        this.opts.in.fs = fs;
        return this;
    }

    @Override
    public RFile.ScannerOptions from(RFileSource ... inputs) {
        this.opts.in = new InputArgs(inputs);
        return this;
    }

    @Override
    public RFile.ScannerFSOptions from(String ... files) {
        this.opts.in = new InputArgs(files);
        return this;
    }

    @Override
    public RFile.ScannerOptions withTableProperties(Iterable<Map.Entry<String, String>> tableConfig) {
        Objects.requireNonNull(tableConfig);
        this.opts.tableConfig = new HashMap();
        for (Map.Entry<String, String> entry : tableConfig) {
            this.opts.tableConfig.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public RFile.ScannerOptions withTableProperties(Map<String, String> tableConfig) {
        Objects.requireNonNull(tableConfig);
        this.opts.tableConfig = new HashMap<String, String>(tableConfig);
        return this;
    }

    @Override
    public RFile.ScannerOptions withBounds(Range range) {
        Objects.requireNonNull(range);
        this.opts.bounds = range;
        return this;
    }

    static class InputArgs
    extends FSConfArgs {
        private Path[] paths;
        private RFileSource[] sources;

        InputArgs(String ... files) {
            this.paths = new Path[files.length];
            for (int i = 0; i < files.length; ++i) {
                this.paths[i] = new Path(files[i]);
            }
        }

        InputArgs(RFileSource ... sources) {
            this.sources = sources;
        }

        RFileSource[] getSources() throws IOException {
            if (this.sources == null) {
                this.sources = new RFileSource[this.paths.length];
                for (int i = 0; i < this.paths.length; ++i) {
                    this.sources[i] = new RFileSource((InputStream)this.getFileSystem().open(this.paths[i]), this.getFileSystem().getFileStatus(this.paths[i]).getLen());
                }
            } else {
                for (int i = 0; i < this.sources.length; ++i) {
                    if (this.sources[i].getInputStream() instanceof FSDataInputStream) continue;
                    this.sources[i] = new RFileSource((InputStream)new FSDataInputStream(this.sources[i].getInputStream()), this.sources[i].getLength());
                }
            }
            return this.sources;
        }
    }
}

