/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.TabletType;
import org.apache.accumulo.core.client.impl.ThriftScanner;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.TimeoutTabletLocator;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.InitialMultiScan;
import org.apache.accumulo.core.data.thrift.MultiScanResult;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TKeyValue;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.htrace.wrappers.TraceRunnable;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerBatchReaderIterator
implements Iterator<Map.Entry<Key, Value>> {
    private static final Logger log = LoggerFactory.getLogger(TabletServerBatchReaderIterator.class);
    private final ClientContext context;
    private final Instance instance;
    private final String tableId;
    private Authorizations authorizations = Authorizations.EMPTY;
    private final int numThreads;
    private final ExecutorService queryThreadPool;
    private final ScannerOptions options;
    private ArrayBlockingQueue<List<Map.Entry<Key, Value>>> resultsQueue;
    private Iterator<Map.Entry<Key, Value>> batchIterator;
    private List<Map.Entry<Key, Value>> batch;
    private static final List<Map.Entry<Key, Value>> LAST_BATCH = new ArrayList<Map.Entry<Key, Value>>();
    private final Object nextLock = new Object();
    private long failSleepTime = 100L;
    private volatile Throwable fatalException = null;
    private Map<String, TimeoutTracker> timeoutTrackers;
    private Set<String> timedoutServers;
    private final long retryTimeout;
    private TabletLocator locator;

    public TabletServerBatchReaderIterator(ClientContext context, String tableId, Authorizations authorizations, ArrayList<Range> ranges, int numThreads, ExecutorService queryThreadPool, ScannerOptions scannerOptions, long retryTimeout) {
        this.context = context;
        this.instance = context.getInstance();
        this.tableId = tableId;
        this.authorizations = authorizations;
        this.numThreads = numThreads;
        this.queryThreadPool = queryThreadPool;
        this.options = new ScannerOptions(scannerOptions);
        this.resultsQueue = new ArrayBlockingQueue(numThreads);
        this.locator = new TimeoutTabletLocator(retryTimeout, context, tableId);
        this.timeoutTrackers = Collections.synchronizedMap(new HashMap());
        this.timedoutServers = Collections.synchronizedSet(new HashSet());
        this.retryTimeout = retryTimeout;
        if (this.options.fetchedColumns.size() > 0) {
            ArrayList<Range> ranges2 = new ArrayList<Range>(ranges.size());
            for (Range range : ranges) {
                ranges2.add(range.bound(this.options.fetchedColumns.first(), this.options.fetchedColumns.last()));
            }
            ranges = ranges2;
        }
        ResultReceiver rr = new ResultReceiver(){

            @Override
            public void receive(List<Map.Entry<Key, Value>> entries) {
                try {
                    TabletServerBatchReaderIterator.this.resultsQueue.put(entries);
                }
                catch (InterruptedException e) {
                    if (TabletServerBatchReaderIterator.this.queryThreadPool.isShutdown()) {
                        log.debug("Failed to add Batch Scan result", (Throwable)e);
                    } else {
                        log.warn("Failed to add Batch Scan result", (Throwable)e);
                    }
                    TabletServerBatchReaderIterator.this.fatalException = e;
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            this.lookup(ranges, rr);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create iterator", e);
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.nextLock;
        synchronized (object) {
            if (this.batch == LAST_BATCH) {
                return false;
            }
            if (this.batch != null && this.batchIterator.hasNext()) {
                return true;
            }
            try {
                this.batch = null;
                while (this.batch == null && this.fatalException == null && !this.queryThreadPool.isShutdown()) {
                    this.batch = this.resultsQueue.poll(1L, TimeUnit.SECONDS);
                }
                if (this.fatalException != null) {
                    if (this.fatalException instanceof RuntimeException) {
                        throw (RuntimeException)this.fatalException;
                    }
                    throw new RuntimeException(this.fatalException);
                }
                if (this.queryThreadPool.isShutdown()) {
                    String shortMsg = "The BatchScanner was unexpectedly closed while this Iterator was still in use.";
                    log.error(shortMsg + " Ensure that a reference to the BatchScanner is retained so that it can be closed when this Iterator is exhausted. Not retaining a reference to the BatchScanner guarantees that you are leaking threads in your client JVM.");
                    throw new RuntimeException(shortMsg + " Ensure proper handling of the BatchScanner.");
                }
                this.batchIterator = this.batch.iterator();
                return this.batch != LAST_BATCH;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Map.Entry<Key, Value> next() {
        Object object = this.nextLock;
        synchronized (object) {
            if (this.hasNext()) {
                return this.batchIterator.next();
            }
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private synchronized void lookup(List<Range> ranges, ResultReceiver receiver) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArrayList<Column> columns = new ArrayList<Column>(this.options.fetchedColumns);
        ranges = Range.mergeOverlapping(ranges);
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        this.binRanges(this.locator, ranges, binnedRanges);
        this.doLookups(binnedRanges, receiver, columns);
    }

    private void binRanges(TabletLocator tabletLocator, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        int lastFailureSize = Integer.MAX_VALUE;
        while (true) {
            binnedRanges.clear();
            List<Range> failures = tabletLocator.binRanges(this.context, ranges, binnedRanges);
            if (failures.size() <= 0) break;
            if (failures.size() >= lastFailureSize) {
                if (!Tables.exists(this.instance, this.tableId)) {
                    throw new TableDeletedException(this.tableId);
                }
                if (Tables.getTableState(this.instance, this.tableId) == TableState.OFFLINE) {
                    throw new TableOfflineException(this.instance, this.tableId);
                }
            }
            lastFailureSize = failures.size();
            if (log.isTraceEnabled()) {
                log.trace("Failed to bin {} ranges, tablet locations were null, retrying in 100ms", (Object)failures.size());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        HashMap binnedRanges2 = new HashMap();
        for (Map.Entry<String, Map<KeyExtent, List<Range>>> entry : binnedRanges.entrySet()) {
            HashMap tabletMap = new HashMap();
            binnedRanges2.put(entry.getKey(), tabletMap);
            for (Map.Entry<KeyExtent, List<Range>> tabletRanges : entry.getValue().entrySet()) {
                Range tabletRange = tabletRanges.getKey().toDataRange();
                ArrayList<Range> clippedRanges = new ArrayList<Range>();
                tabletMap.put(tabletRanges.getKey(), clippedRanges);
                for (Range range : tabletRanges.getValue()) {
                    clippedRanges.add(tabletRange.clip(range));
                }
            }
        }
        binnedRanges.clear();
        binnedRanges.putAll(binnedRanges2);
    }

    private void processFailures(Map<KeyExtent, List<Range>> failures, ResultReceiver receiver, List<Column> columns) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace("Failed to execute multiscans against {} tablets, retrying...", (Object)failures.size());
        }
        try {
            Thread.sleep(this.failSleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Exiting failure processing on interrupt");
            return;
        }
        this.failSleepTime = Math.min(5000L, this.failSleepTime * 2L);
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        ArrayList<Range> allRanges = new ArrayList<Range>();
        for (List<Range> ranges : failures.values()) {
            allRanges.addAll(ranges);
        }
        this.binRanges(this.locator, allRanges, binnedRanges);
        this.doLookups(binnedRanges, receiver, columns);
    }

    private String getTableInfo() {
        return Tables.getPrintableTableInfoFromId(this.instance, this.tableId);
    }

    private void doLookups(Map<String, Map<KeyExtent, List<Range>>> binnedRanges, ResultReceiver receiver, List<Column> columns) {
        if (this.timedoutServers.containsAll(binnedRanges.keySet())) {
            throw new TimedOutException(this.timedoutServers);
        }
        int maxTabletsPerRequest = Integer.MAX_VALUE;
        if (this.numThreads / binnedRanges.size() > 1) {
            int totalNumberOfTablets = 0;
            for (Map.Entry<String, Map<KeyExtent, List<Range>>> entry : binnedRanges.entrySet()) {
                totalNumberOfTablets += entry.getValue().size();
            }
            maxTabletsPerRequest = totalNumberOfTablets / this.numThreads;
            if (maxTabletsPerRequest == 0) {
                maxTabletsPerRequest = 1;
            }
        }
        HashMap<KeyExtent, List<Range>> failures = new HashMap<KeyExtent, List<Range>>();
        if (this.timedoutServers.size() > 0) {
            Iterator<Map.Entry<String, Map<KeyExtent, List<Range>>>> iterator = binnedRanges.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Map<KeyExtent, List<Range>>> entry;
                entry = iterator.next();
                if (!this.timedoutServers.contains(entry.getKey())) continue;
                failures.putAll(entry.getValue());
                iterator.remove();
            }
        }
        ArrayList<String> locations = new ArrayList<String>(binnedRanges.keySet());
        Collections.shuffle(locations);
        ArrayList<QueryTask> queryTasks = new ArrayList<QueryTask>();
        for (String tsLocation : locations) {
            Map<KeyExtent, List<Range>> tabletsRanges = binnedRanges.get(tsLocation);
            if (maxTabletsPerRequest == Integer.MAX_VALUE || tabletsRanges.size() == 1) {
                QueryTask queryTask = new QueryTask(tsLocation, tabletsRanges, failures, receiver, columns);
                queryTasks.add(queryTask);
                continue;
            }
            HashMap<KeyExtent, List<Range>> tabletSubset = new HashMap<KeyExtent, List<Range>>();
            for (Map.Entry<KeyExtent, List<Range>> entry : tabletsRanges.entrySet()) {
                tabletSubset.put(entry.getKey(), entry.getValue());
                if (tabletSubset.size() < maxTabletsPerRequest) continue;
                QueryTask queryTask = new QueryTask(tsLocation, tabletSubset, failures, receiver, columns);
                queryTasks.add(queryTask);
                tabletSubset = new HashMap();
            }
            if (tabletSubset.size() <= 0) continue;
            QueryTask queryTask = new QueryTask(tsLocation, tabletSubset, failures, receiver, columns);
            queryTasks.add(queryTask);
        }
        Semaphore semaphore = new Semaphore(queryTasks.size());
        semaphore.acquireUninterruptibly(queryTasks.size());
        for (QueryTask queryTask : queryTasks) {
            queryTask.setSemaphore(semaphore, queryTasks.size());
            this.queryThreadPool.execute((Runnable)new TraceRunnable((Runnable)queryTask));
        }
    }

    static void trackScanning(Map<KeyExtent, List<Range>> failures, Map<KeyExtent, List<Range>> unscanned, MultiScanResult scanResult) {
        Map<KeyExtent, Range> retFailures = Translator.translate(scanResult.failures, Translators.TKET, new Translator.ListTranslator<TRange, Range>(Translators.TRT));
        unscanned.keySet().removeAll(retFailures.keySet());
        failures.putAll(retFailures);
        HashSet<KeyExtent> fullScans = new HashSet<KeyExtent>(Translator.translate(scanResult.fullScans, Translators.TKET));
        unscanned.keySet().removeAll(fullScans);
        if (scanResult.partScan != null) {
            KeyExtent ke = new KeyExtent(scanResult.partScan);
            Key nextKey = new Key(scanResult.partNextKey);
            ListIterator<Range> iterator = unscanned.get(ke).listIterator();
            while (iterator.hasNext()) {
                Range range = iterator.next();
                if (range.afterEndKey(nextKey) || nextKey.equals(range.getEndKey()) && scanResult.partNextKeyInclusive != range.isEndKeyInclusive()) {
                    iterator.remove();
                    continue;
                }
                if (!range.contains(nextKey)) continue;
                iterator.remove();
                Range partRange = new Range(nextKey, scanResult.partNextKeyInclusive, range.getEndKey(), range.isEndKeyInclusive());
                iterator.add(partRange);
            }
        }
    }

    public static void doLookup(ClientContext context, String server, Map<KeyExtent, List<Range>> requested, Map<KeyExtent, List<Range>> failures, Map<KeyExtent, List<Range>> unscanned, ResultReceiver receiver, List<Column> columns, ScannerOptions options, Authorizations authorizations) throws IOException, AccumuloSecurityException, AccumuloServerException {
        TabletServerBatchReaderIterator.doLookup(context, server, requested, failures, unscanned, receiver, columns, options, authorizations, new TimeoutTracker(Long.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doLookup(ClientContext context, String server, Map<KeyExtent, List<Range>> requested, Map<KeyExtent, List<Range>> failures, Map<KeyExtent, List<Range>> unscanned, ResultReceiver receiver, List<Column> columns, ScannerOptions options, Authorizations authorizations, TimeoutTracker timeoutTracker) throws IOException, AccumuloSecurityException, AccumuloServerException {
        if (requested.size() == 0) {
            return;
        }
        for (Map.Entry<KeyExtent, List<Range>> entry : requested.entrySet()) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (Range range : entry.getValue()) {
                ranges.add(new Range(range));
            }
            unscanned.put(new KeyExtent(entry.getKey()), ranges);
        }
        timeoutTracker.startingScan();
        TTransport transport = null;
        try {
            HostAndPort parsedServer = HostAndPort.fromString(server);
            TabletClientService.Client client = timeoutTracker.getTimeOut() < context.getClientTimeoutInMillis() ? ThriftUtil.getTServerClient(parsedServer, context, timeoutTracker.getTimeOut()) : ThriftUtil.getTServerClient(parsedServer, context);
            try {
                TabletType ttype;
                OpTimer timer = null;
                if (log.isTraceEnabled()) {
                    log.trace("tid={} Starting multi scan, tserver={}  #tablets={}  #ranges={} ssil={} ssio={}", new Object[]{Thread.currentThread().getId(), server, requested.size(), TabletServerBatchReaderIterator.sumSizes(requested.values()), options.serverSideIteratorList, options.serverSideIteratorOptions});
                    timer = new OpTimer().start();
                }
                boolean waitForWrites = !ThriftScanner.serversWaitedForWrites.get((Object)(ttype = TabletType.type(requested.keySet()))).contains(server);
                Map<TKeyExtent, TRange> thriftTabletRanges = Translator.translate(requested, Translators.KET, new Translator.ListTranslator<Range, TRange>(Translators.RT));
                InitialMultiScan imsr = client.startMultiScan(Tracer.traceInfo(), context.rpcCreds(), thriftTabletRanges, Translator.translate(columns, Translators.CT), options.serverSideIteratorList, options.serverSideIteratorOptions, ByteBufferUtil.toByteBuffers(authorizations.getAuthorizations()), waitForWrites, SamplerConfigurationImpl.toThrift(options.getSamplerConfiguration()), options.batchTimeout, options.classLoaderContext);
                if (waitForWrites) {
                    ThriftScanner.serversWaitedForWrites.get((Object)ttype).add(server.toString());
                }
                MultiScanResult scanResult = imsr.result;
                if (timer != null) {
                    timer.stop();
                    log.trace("tid={} Got 1st multi scan results, #results={} {} in {}", new Object[]{Thread.currentThread().getId(), scanResult.results.size(), scanResult.more ? "scanID=" + imsr.scanID : "", String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
                }
                ArrayList<Map.Entry<Key, Value>> entries = new ArrayList<Map.Entry<Key, Value>>(scanResult.results.size());
                for (TKeyValue kv : scanResult.results) {
                    entries.add(new AbstractMap.SimpleImmutableEntry<Key, Value>(new Key(kv.key), new Value(kv.value)));
                }
                if (entries.size() > 0) {
                    receiver.receive(entries);
                }
                if (entries.size() > 0 || scanResult.fullScans.size() > 0) {
                    timeoutTracker.madeProgress();
                }
                TabletServerBatchReaderIterator.trackScanning(failures, unscanned, scanResult);
                AtomicLong nextOpid = new AtomicLong();
                while (scanResult.more) {
                    timeoutTracker.check();
                    if (timer != null) {
                        log.trace("tid={} oid={} Continuing multi scan, scanid={}", new Object[]{Thread.currentThread().getId(), nextOpid.get(), imsr.scanID});
                        timer.reset().start();
                    }
                    scanResult = client.continueMultiScan(Tracer.traceInfo(), imsr.scanID);
                    if (timer != null) {
                        timer.stop();
                        log.trace("tid={} oid={} Got more multi scan results, #results={} {} in {}", new Object[]{Thread.currentThread().getId(), nextOpid.getAndIncrement(), scanResult.results.size(), scanResult.more ? " scanID=" + imsr.scanID : "", String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
                    }
                    entries = new ArrayList(scanResult.results.size());
                    for (TKeyValue kv : scanResult.results) {
                        entries.add(new AbstractMap.SimpleImmutableEntry<Key, Value>(new Key(kv.key), new Value(kv.value)));
                    }
                    if (entries.size() > 0) {
                        receiver.receive(entries);
                    }
                    if (entries.size() > 0 || scanResult.fullScans.size() > 0) {
                        timeoutTracker.madeProgress();
                    }
                    TabletServerBatchReaderIterator.trackScanning(failures, unscanned, scanResult);
                }
                client.closeMultiScan(Tracer.traceInfo(), imsr.scanID);
            }
            finally {
                ThriftUtil.returnClient(client);
            }
        }
        catch (TTransportException e) {
            log.debug("Server : {} msg : {}", (Object)server, (Object)e.getMessage());
            timeoutTracker.errorOccured((Exception)((Object)e));
            throw new IOException(e);
        }
        catch (ThriftSecurityException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TApplicationException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            throw new AccumuloServerException(server, e);
        }
        catch (NoSuchScanIDException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            throw new IOException((Throwable)((Object)e));
        }
        catch (TSampleNotPresentException e) {
            log.debug("Server : " + server + " msg : " + e.getMessage(), (Throwable)((Object)e));
            String tableInfo = "?";
            if (e.getExtent() != null) {
                String tableId = new KeyExtent(e.getExtent()).getTableId();
                tableInfo = Tables.getPrintableTableInfoFromId(context.getInstance(), tableId);
            }
            String message = "Table " + tableInfo + " does not have sampling configured or built";
            throw new SampleNotPresentException(message, (Exception)((Object)e));
        }
        catch (TException e) {
            log.debug("Server : {} msg : {}", new Object[]{server, e.getMessage(), e});
            timeoutTracker.errorOccured((Exception)((Object)e));
            throw new IOException(e);
        }
        finally {
            ThriftTransportPool.getInstance().returnTransport(transport);
        }
    }

    static int sumSizes(Collection<List<Range>> values) {
        int sum = 0;
        for (List<Range> list : values) {
            sum += list.size();
        }
        return sum;
    }

    private static class TimeoutTracker {
        String server;
        Set<String> badServers;
        long timeOut;
        long activityTime;
        Long firstErrorTime = null;

        TimeoutTracker(String server, Set<String> badServers, long timeOut) {
            this(timeOut);
            this.server = server;
            this.badServers = badServers;
        }

        TimeoutTracker(long timeOut) {
            this.timeOut = timeOut;
        }

        void startingScan() {
            this.activityTime = System.currentTimeMillis();
        }

        void check() throws IOException {
            if (System.currentTimeMillis() - this.activityTime > this.timeOut) {
                this.badServers.add(this.server);
                throw new IOException("Time exceeded " + (System.currentTimeMillis() - this.activityTime) + " " + this.server);
            }
        }

        void madeProgress() {
            this.activityTime = System.currentTimeMillis();
            this.firstErrorTime = null;
        }

        void errorOccured(Exception e) {
            if (this.firstErrorTime == null) {
                this.firstErrorTime = this.activityTime;
            } else if (System.currentTimeMillis() - this.firstErrorTime > this.timeOut) {
                this.badServers.add(this.server);
            }
        }

        public long getTimeOut() {
            return this.timeOut;
        }
    }

    private class QueryTask
    implements Runnable {
        private String tsLocation;
        private Map<KeyExtent, List<Range>> tabletsRanges;
        private ResultReceiver receiver;
        private Semaphore semaphore = null;
        private final Map<KeyExtent, List<Range>> failures;
        private List<Column> columns;
        private int semaphoreSize;

        QueryTask(String tsLocation, Map<KeyExtent, List<Range>> tabletsRanges, Map<KeyExtent, List<Range>> failures, ResultReceiver receiver, List<Column> columns) {
            this.tsLocation = tsLocation;
            this.tabletsRanges = tabletsRanges;
            this.receiver = receiver;
            this.columns = columns;
            this.failures = failures;
        }

        void setSemaphore(Semaphore semaphore, int semaphoreSize) {
            this.semaphore = semaphore;
            this.semaphoreSize = semaphoreSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block72: {
                String threadName = Thread.currentThread().getName();
                Thread.currentThread().setName(threadName + " looking up " + this.tabletsRanges.size() + " ranges at " + this.tsLocation);
                HashMap<KeyExtent, List<Range>> unscanned = new HashMap<KeyExtent, List<Range>>();
                HashMap<KeyExtent, List<Range>> tsFailures = new HashMap<KeyExtent, List<Range>>();
                try {
                    TimeoutTracker timeoutTracker = (TimeoutTracker)TabletServerBatchReaderIterator.this.timeoutTrackers.get(this.tsLocation);
                    if (timeoutTracker == null) {
                        timeoutTracker = new TimeoutTracker(this.tsLocation, TabletServerBatchReaderIterator.this.timedoutServers, TabletServerBatchReaderIterator.this.retryTimeout);
                        TabletServerBatchReaderIterator.this.timeoutTrackers.put(this.tsLocation, timeoutTracker);
                    }
                    TabletServerBatchReaderIterator.doLookup(TabletServerBatchReaderIterator.this.context, this.tsLocation, this.tabletsRanges, tsFailures, unscanned, this.receiver, this.columns, TabletServerBatchReaderIterator.this.options, TabletServerBatchReaderIterator.this.authorizations, timeoutTracker);
                    if (tsFailures.size() <= 0) break block72;
                    TabletServerBatchReaderIterator.this.locator.invalidateCache(tsFailures.keySet());
                    Map<KeyExtent, List<Range>> map = this.failures;
                    synchronized (map) {
                        this.failures.putAll(tsFailures);
                    }
                }
                catch (IOException e) {
                    if (!TabletServerBatchReaderIterator.this.queryThreadPool.isShutdown()) {
                        Map<KeyExtent, List<Range>> map = this.failures;
                        synchronized (map) {
                            this.failures.putAll(tsFailures);
                            this.failures.putAll(unscanned);
                        }
                        TabletServerBatchReaderIterator.this.locator.invalidateCache(TabletServerBatchReaderIterator.this.context.getInstance(), this.tsLocation);
                    }
                    log.debug("IOException thrown", (Throwable)e);
                }
                catch (AccumuloSecurityException e) {
                    e.setTableInfo(TabletServerBatchReaderIterator.this.getTableInfo());
                    log.debug("AccumuloSecurityException thrown", (Throwable)e);
                    Tables.clearCache(TabletServerBatchReaderIterator.this.instance);
                    if (!Tables.exists(TabletServerBatchReaderIterator.this.instance, TabletServerBatchReaderIterator.this.tableId)) {
                        TabletServerBatchReaderIterator.this.fatalException = new TableDeletedException(TabletServerBatchReaderIterator.this.tableId);
                    } else {
                        TabletServerBatchReaderIterator.this.fatalException = e;
                    }
                }
                catch (SampleNotPresentException e) {
                    TabletServerBatchReaderIterator.this.fatalException = e;
                }
                catch (Throwable t) {
                    if (TabletServerBatchReaderIterator.this.queryThreadPool.isShutdown()) {
                        log.debug("Caught exception, but queryThreadPool is shutdown", t);
                    } else {
                        log.warn("Caught exception, but queryThreadPool is not shutdown", t);
                    }
                    TabletServerBatchReaderIterator.this.fatalException = t;
                }
                finally {
                    block73: {
                        this.semaphore.release();
                        Thread.currentThread().setName(threadName);
                        if (this.semaphore.tryAcquire(this.semaphoreSize)) {
                            if (TabletServerBatchReaderIterator.this.fatalException == null && this.failures.size() > 0) {
                                try {
                                    TabletServerBatchReaderIterator.this.processFailures(this.failures, this.receiver, this.columns);
                                }
                                catch (TableNotFoundException e) {
                                    log.debug("{}", (Object)e.getMessage(), (Object)e);
                                    TabletServerBatchReaderIterator.this.fatalException = e;
                                }
                                catch (AccumuloException e) {
                                    log.debug("{}", (Object)e.getMessage(), (Object)e);
                                    TabletServerBatchReaderIterator.this.fatalException = e;
                                }
                                catch (AccumuloSecurityException e) {
                                    e.setTableInfo(TabletServerBatchReaderIterator.this.getTableInfo());
                                    log.debug("{}", (Object)e.getMessage(), (Object)e);
                                    TabletServerBatchReaderIterator.this.fatalException = e;
                                }
                                catch (Throwable t) {
                                    log.debug("{}", (Object)t.getMessage(), (Object)t);
                                    TabletServerBatchReaderIterator.this.fatalException = t;
                                }
                                if (TabletServerBatchReaderIterator.this.fatalException != null && !TabletServerBatchReaderIterator.this.resultsQueue.offer(LAST_BATCH)) {
                                    log.debug("Could not add to result queue after seeing fatalException in processFailures", TabletServerBatchReaderIterator.this.fatalException);
                                }
                            } else if (TabletServerBatchReaderIterator.this.fatalException != null) {
                                if (!TabletServerBatchReaderIterator.this.resultsQueue.offer(LAST_BATCH)) {
                                    log.debug("Could not add to result queue after seeing fatalException", TabletServerBatchReaderIterator.this.fatalException);
                                }
                            } else {
                                try {
                                    TabletServerBatchReaderIterator.this.resultsQueue.put(LAST_BATCH);
                                }
                                catch (InterruptedException e) {
                                    TabletServerBatchReaderIterator.this.fatalException = e;
                                    if (TabletServerBatchReaderIterator.this.resultsQueue.offer(LAST_BATCH)) break block73;
                                    log.debug("Could not add to result queue after seeing fatalException", TabletServerBatchReaderIterator.this.fatalException);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface ResultReceiver {
        public void receive(List<Map.Entry<Key, Value>> var1);
    }
}

