/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementResultMapping;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementParameter;

public class RDBMSQueryCompilation {
    List<StatementCompilation> statementCompilations = new ArrayList<StatementCompilation>(1);
    List<SQLStatementParameter> inputParameters;
    Map<Integer, String> inputParameterNameByPosition;
    StatementClassMapping resultsDefinitionForClass = null;
    StatementResultMapping resultsDefinition = null;
    Map<String, IteratorStatement> scoIteratorStatementByMemberName;
    boolean precompilable = true;

    public int getNumberOfStatements() {
        return this.statementCompilations.size();
    }

    public void clearStatements() {
        this.statementCompilations.clear();
    }

    public void addStatement(SQLStatement stmt, String sql, boolean useInCount) {
        this.statementCompilations.add(new StatementCompilation(stmt, sql, useInCount));
    }

    public List<StatementCompilation> getStatementCompilations() {
        return this.statementCompilations;
    }

    public String getSQL() {
        if (this.statementCompilations.isEmpty()) {
            return null;
        }
        return this.statementCompilations.get(0).getSQL();
    }

    public void setPrecompilable(boolean precompilable) {
        this.precompilable = precompilable;
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public void setResultDefinitionForClass(StatementClassMapping def) {
        this.resultsDefinitionForClass = def;
    }

    public StatementClassMapping getResultDefinitionForClass() {
        return this.resultsDefinitionForClass;
    }

    public void setResultDefinition(StatementResultMapping def) {
        this.resultsDefinition = def;
    }

    public StatementResultMapping getResultDefinition() {
        return this.resultsDefinition;
    }

    public void setStatementParameters(List<SQLStatementParameter> params) {
        this.inputParameters = params;
    }

    public List<SQLStatementParameter> getStatementParameters() {
        return this.inputParameters;
    }

    public void setParameterNameByPosition(Map<Integer, String> paramNameByPos) {
        this.inputParameterNameByPosition = paramNameByPos;
    }

    public Map<Integer, String> getParameterNameByPosition() {
        return this.inputParameterNameByPosition;
    }

    public void setSCOIteratorStatement(String memberName, IteratorStatement iterStmt) {
        if (this.scoIteratorStatementByMemberName == null) {
            this.scoIteratorStatementByMemberName = new HashMap<String, IteratorStatement>();
        }
        this.scoIteratorStatementByMemberName.put(memberName, iterStmt);
    }

    public Map<String, IteratorStatement> getSCOIteratorStatements() {
        return this.scoIteratorStatementByMemberName;
    }

    public class StatementCompilation {
        SQLStatement stmt;
        String sql;
        boolean useInCount = true;

        public StatementCompilation(SQLStatement stmt, String sql, boolean useInCount) {
            this.stmt = stmt;
            this.sql = sql;
            this.useInCount = useInCount;
        }

        public SQLStatement getStatement() {
            return this.stmt;
        }

        public String getSQL() {
            return this.sql;
        }

        public boolean useInCount() {
            return this.useInCount;
        }

        public void setSQL(String sql) {
            this.sql = sql;
        }
    }
}

