/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hive.iceberg.org.apache.avro.Conversions;
import org.apache.hive.iceberg.org.apache.avro.LogicalTypes;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.hive.iceberg.org.apache.avro.file.CodecFactory;
import org.apache.hive.iceberg.org.apache.avro.generic.GenericData;
import org.apache.hive.iceberg.org.apache.avro.io.DatumReader;
import org.apache.hive.iceberg.org.apache.avro.io.DatumWriter;
import org.apache.hive.iceberg.org.apache.avro.io.Encoder;
import org.apache.hive.iceberg.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.InternalData;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.avro.AvroFileAppender;
import org.apache.iceberg.avro.AvroIO;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.GenericAvroReader;
import org.apache.iceberg.avro.GenericAvroWriter;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.MetricsAwareDatumWriter;
import org.apache.iceberg.avro.NameMappingDatumReader;
import org.apache.iceberg.avro.ProjectionDatumReader;
import org.apache.iceberg.avro.SupportsCustomRecords;
import org.apache.iceberg.avro.SupportsCustomTypes;
import org.apache.iceberg.avro.UUIDConversion;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.avro.VariantConversion;
import org.apache.iceberg.avro.VariantLogicalType;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.ArrayUtil;

public class Avro {
    private static final int ZSTD_COMPRESSION_LEVEL_DEFAULT = 1;
    private static final int GZIP_COMPRESSION_LEVEL_DEFAULT = 9;
    private static final GenericData DEFAULT_MODEL = new SpecificData();

    private Avro() {
    }

    public static WriteBuilder write(OutputFile file) {
        if (file instanceof EncryptedOutputFile) {
            return Avro.write((EncryptedOutputFile)((Object)file));
        }
        return new WriteBuilder(file);
    }

    public static WriteBuilder write(EncryptedOutputFile file) {
        return new WriteBuilder(file.encryptingOutputFile());
    }

    public static DataWriteBuilder writeData(OutputFile file) {
        return new DataWriteBuilder(file);
    }

    public static DataWriteBuilder writeData(EncryptedOutputFile file) {
        return new DataWriteBuilder(file.encryptingOutputFile());
    }

    public static DeleteWriteBuilder writeDeletes(OutputFile file) {
        return new DeleteWriteBuilder(file);
    }

    public static DeleteWriteBuilder writeDeletes(EncryptedOutputFile file) {
        return new DeleteWriteBuilder(file.encryptingOutputFile());
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    public static long rowCount(InputFile file) {
        return AvroIO.findStartingRowPos(file::newStream, Long.MAX_VALUE);
    }

    static {
        LogicalTypes.register("map", schema -> LogicalMap.get());
        LogicalTypes.register("variant", schema -> VariantLogicalType.get());
        DEFAULT_MODEL.addLogicalTypeConversion(new Conversions.DecimalConversion());
        DEFAULT_MODEL.addLogicalTypeConversion(new UUIDConversion());
        DEFAULT_MODEL.addLogicalTypeConversion(new VariantConversion());
    }

    public static class ReadBuilder
    implements InternalData.ReadBuilder {
        private final InputFile file;
        private final Map<String, String> renames = Maps.newLinkedHashMap();
        private final Map<Integer, Class<? extends StructLike>> typeMap = Maps.newHashMap();
        private Class<? extends StructLike> rootType = null;
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private NameMapping nameMapping;
        private boolean reuseContainers = false;
        private Schema schema = null;
        private Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumReader<?>> createReaderFunc = null;
        private BiFunction<Schema, org.apache.hive.iceberg.org.apache.avro.Schema, DatumReader<?>> createReaderBiFunc = null;
        private Function<Schema, DatumReader<?>> createResolvingReaderFunc = null;
        private final Function<Schema, DatumReader<?>> defaultCreateReaderFunc = readSchema -> {
            GenericAvroReader reader = GenericAvroReader.create(readSchema);
            reader.setClassLoader(this.loader);
            return reader;
        };
        private Long start = null;
        private Long length = null;

        private ReadBuilder(InputFile file) {
            Preconditions.checkNotNull(file, "Input file cannot be null");
            this.file = file;
        }

        public ReadBuilder createResolvingReader(Function<Schema, DatumReader<?>> readerFunction) {
            Preconditions.checkState(this.createReaderBiFunc == null && this.createReaderFunc == null, "Cannot set multiple read builder functions");
            this.createResolvingReaderFunc = readerFunction;
            return this;
        }

        public ReadBuilder createReaderFunc(Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumReader<?>> readerFunction) {
            Preconditions.checkState(this.createReaderBiFunc == null && this.createResolvingReaderFunc == null, "Cannot set multiple read builder functions");
            this.createReaderFunc = readerFunction;
            return this;
        }

        public ReadBuilder createReaderFunc(BiFunction<Schema, org.apache.hive.iceberg.org.apache.avro.Schema, DatumReader<?>> readerFunction) {
            Preconditions.checkState(this.createReaderFunc == null && this.createResolvingReaderFunc == null, "Cannot set multiple read builder functions");
            this.createReaderBiFunc = readerFunction;
            return this;
        }

        @Override
        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        @Override
        public ReadBuilder project(Schema projectedSchema) {
            this.schema = projectedSchema;
            return this;
        }

        @Override
        public ReadBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ReadBuilder reuseContainers(boolean shouldReuse) {
            this.reuseContainers = shouldReuse;
            return this;
        }

        public ReadBuilder rename(String fullName, String newName) {
            this.renames.put(fullName, newName);
            return this;
        }

        @Override
        public InternalData.ReadBuilder setRootType(Class<? extends StructLike> rootClass) {
            this.rootType = rootClass;
            return this;
        }

        @Override
        public InternalData.ReadBuilder setCustomType(int fieldId, Class<? extends StructLike> structClass) {
            this.typeMap.put(fieldId, structClass);
            return this;
        }

        public ReadBuilder withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public ReadBuilder classLoader(ClassLoader classLoader) {
            this.loader = classLoader;
            return this;
        }

        public <D> AvroIterable<D> build() {
            DatumReader<Object> reader;
            Preconditions.checkNotNull(this.schema, "Schema is required");
            if (null == this.nameMapping) {
                this.nameMapping = MappingUtil.create(this.schema);
            }
            if ((reader = this.createReaderBiFunc != null ? new ProjectionDatumReader(avroSchema -> this.createReaderBiFunc.apply(this.schema, (org.apache.hive.iceberg.org.apache.avro.Schema)avroSchema), this.schema, this.renames, null) : (this.createReaderFunc != null ? new ProjectionDatumReader(this.createReaderFunc, this.schema, this.renames, null) : (this.createResolvingReaderFunc != null ? this.createResolvingReaderFunc.apply(this.schema) : this.defaultCreateReaderFunc.apply(this.schema)))) instanceof SupportsCustomRecords) {
                ((SupportsCustomRecords)((Object)reader)).setClassLoader(this.loader);
                ((SupportsCustomRecords)((Object)reader)).setRenames(this.renames);
            }
            if (reader instanceof SupportsCustomTypes) {
                ((SupportsCustomTypes)((Object)reader)).setCustomTypes(this.rootType, this.typeMap);
            }
            return new AvroIterable(this.file, new NameMappingDatumReader(this.nameMapping, reader), this.start, this.length, this.reuseContainers);
        }
    }

    private static class PositionAndRowDatumWriter<D>
    implements MetricsAwareDatumWriter<PositionDelete<D>> {
        private static final ValueWriter<Object> PATH_WRITER = ValueWriters.strings();
        private static final ValueWriter<Long> POS_WRITER = ValueWriters.longs();
        private final DatumWriter<D> rowWriter;

        private PositionAndRowDatumWriter(DatumWriter<D> rowWriter) {
            this.rowWriter = rowWriter;
        }

        @Override
        public void setSchema(org.apache.hive.iceberg.org.apache.avro.Schema schema) {
            Schema.Field rowField = schema.getField("row");
            if (rowField != null) {
                this.rowWriter.setSchema(rowField.schema());
            }
        }

        @Override
        public void write(PositionDelete<D> delete, Encoder out) throws IOException {
            PATH_WRITER.write(delete.path(), out);
            POS_WRITER.write(delete.pos(), out);
            this.rowWriter.write(delete.row(), out);
        }

        @Override
        public Stream<FieldMetrics> metrics() {
            return Stream.concat(PATH_WRITER.metrics(), POS_WRITER.metrics());
        }
    }

    private static class PositionDatumWriter
    implements MetricsAwareDatumWriter<PositionDelete<?>> {
        private static final ValueWriter<Object> PATH_WRITER = ValueWriters.strings();
        private static final ValueWriter<Long> POS_WRITER = ValueWriters.longs();

        private PositionDatumWriter() {
        }

        @Override
        public void setSchema(org.apache.hive.iceberg.org.apache.avro.Schema schema) {
        }

        @Override
        public void write(PositionDelete<?> delete, Encoder out) throws IOException {
            PATH_WRITER.write(delete.path(), out);
            POS_WRITER.write(delete.pos(), out);
        }

        @Override
        public Stream<FieldMetrics> metrics() {
            return Stream.concat(PATH_WRITER.metrics(), POS_WRITER.metrics());
        }
    }

    public static class DeleteWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumWriter<?>> createWriterFunc = null;
        private Schema rowSchema;
        private PartitionSpec spec;
        private StructLike partition;
        private EncryptionKeyMetadata keyMetadata = null;
        private int[] equalityFieldIds = null;
        private SortOrder sortOrder;

        private DeleteWriteBuilder(OutputFile file) {
            this.appenderBuilder = Avro.write(file);
            this.location = file.location();
        }

        public DeleteWriteBuilder forTable(Table table) {
            this.rowSchema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable(table));
            return this;
        }

        public DeleteWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DeleteWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DeleteWriteBuilder meta(String property, String value) {
            this.appenderBuilder.meta(property, value);
            return this;
        }

        public DeleteWriteBuilder meta(Map<String, String> properties) {
            this.appenderBuilder.meta((Map)properties);
            return this;
        }

        public DeleteWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DeleteWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DeleteWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DeleteWriteBuilder createWriterFunc(Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        public DeleteWriteBuilder rowSchema(Schema newRowSchema) {
            this.rowSchema = newRowSchema;
            return this;
        }

        public DeleteWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DeleteWriteBuilder withPartition(StructLike key) {
            this.partition = key;
            return this;
        }

        public DeleteWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(List<Integer> fieldIds) {
            this.equalityFieldIds = ArrayUtil.toIntArray(fieldIds);
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(int ... fieldIds) {
            this.equalityFieldIds = fieldIds;
            return this;
        }

        public DeleteWriteBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder;
            return this;
        }

        public <T> EqualityDeleteWriter<T> buildEqualityWriter() throws IOException {
            Preconditions.checkState(this.rowSchema != null, "Cannot create equality delete file without a schema");
            Preconditions.checkState(this.equalityFieldIds != null, "Cannot create equality delete file without delete field ids");
            Preconditions.checkState(this.createWriterFunc != null, "Cannot create equality delete file unless createWriterFunc is set");
            Preconditions.checkArgument(this.spec != null, "Spec must not be null when creating equality delete writer");
            Preconditions.checkArgument(this.spec.isUnpartitioned() || this.partition != null, "Partition must not be null for partitioned writes");
            this.meta("delete-type", "equality");
            this.meta("delete-field-ids", IntStream.of(this.equalityFieldIds).mapToObj(Objects::toString).collect(Collectors.joining(", ")));
            this.appenderBuilder.schema(this.rowSchema);
            this.appenderBuilder.createWriterFunc(this.createWriterFunc);
            this.appenderBuilder.createContextFunc(WriteBuilder.Context::deleteContext);
            return new EqualityDeleteWriter(this.appenderBuilder.build(), FileFormat.AVRO, this.location, this.spec, this.partition, this.keyMetadata, this.sortOrder, this.equalityFieldIds);
        }

        public <T> PositionDeleteWriter<T> buildPositionWriter() throws IOException {
            Preconditions.checkState(this.equalityFieldIds == null, "Cannot create position delete file using delete field ids");
            Preconditions.checkArgument(this.spec != null, "Spec must not be null when creating position delete writer");
            Preconditions.checkArgument(this.spec.isUnpartitioned() || this.partition != null, "Partition must not be null for partitioned writes");
            Preconditions.checkArgument(this.rowSchema == null || this.createWriterFunc != null, "Create function should be provided if we write row data");
            this.meta("delete-type", "position");
            if (this.rowSchema != null && this.createWriterFunc != null) {
                this.appenderBuilder.schema(DeleteSchemaUtil.posDeleteSchema(this.rowSchema));
                this.appenderBuilder.createWriterFunc(avroSchema -> new PositionAndRowDatumWriter(this.createWriterFunc.apply((org.apache.hive.iceberg.org.apache.avro.Schema)avroSchema)));
            } else {
                this.appenderBuilder.schema(DeleteSchemaUtil.pathPosSchema());
                this.appenderBuilder.createWriterFunc(ignored -> new PositionDatumWriter());
            }
            this.appenderBuilder.createContextFunc(WriteBuilder.Context::deleteContext);
            return new PositionDeleteWriter(this.appenderBuilder.build(), FileFormat.AVRO, this.location, this.spec, this.partition, this.keyMetadata);
        }
    }

    public static class DataWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private PartitionSpec spec = null;
        private StructLike partition = null;
        private EncryptionKeyMetadata keyMetadata = null;
        private SortOrder sortOrder = null;

        private DataWriteBuilder(OutputFile file) {
            this.appenderBuilder = Avro.write(file);
            this.location = file.location();
        }

        public DataWriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable(table));
            return this;
        }

        public DataWriteBuilder schema(Schema newSchema) {
            this.appenderBuilder.schema(newSchema);
            return this;
        }

        public DataWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DataWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DataWriteBuilder meta(String property, String value) {
            this.appenderBuilder.meta(property, value);
            return this;
        }

        public DataWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DataWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DataWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DataWriteBuilder createWriterFunc(Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumWriter<?>> newCreateWriterFunc) {
            this.appenderBuilder.createWriterFunc(newCreateWriterFunc);
            return this;
        }

        public DataWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DataWriteBuilder withPartition(StructLike newPartition) {
            this.partition = newPartition;
            return this;
        }

        public DataWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DataWriteBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder;
            return this;
        }

        public <T> DataWriter<T> build() throws IOException {
            Preconditions.checkArgument(this.spec != null, "Cannot create data writer without spec");
            Preconditions.checkArgument(this.spec.isUnpartitioned() || this.partition != null, "Partition must not be null when creating data writer for partitioned spec");
            FileAppender fileAppender = this.appenderBuilder.build();
            return new DataWriter(fileAppender, FileFormat.AVRO, this.location, this.spec, this.partition, this.keyMetadata, this.sortOrder);
        }
    }

    public static class WriteBuilder
    implements InternalData.WriteBuilder {
        private final OutputFile file;
        private final Map<String, String> config = Maps.newHashMap();
        private final Map<String, String> metadata = Maps.newLinkedHashMap();
        private Schema schema = null;
        private String name = "table";
        private Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumWriter<?>> createWriterFunc = null;
        private boolean overwrite;
        private MetricsConfig metricsConfig;
        private Function<Map<String, String>, Context> createContextFunc = Context::dataContext;

        private WriteBuilder(OutputFile file) {
            this.file = file;
        }

        public WriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable(table));
            return this;
        }

        @Override
        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        @Override
        public WriteBuilder named(String newName) {
            this.name = newName;
            return this;
        }

        public WriteBuilder createWriterFunc(Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        @Override
        public WriteBuilder set(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        @Override
        public WriteBuilder meta(String property, String value) {
            this.metadata.put(property, value);
            return this;
        }

        @Override
        public WriteBuilder meta(Map<String, String> properties) {
            this.metadata.putAll(properties);
            return this;
        }

        public WriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.metricsConfig = newMetricsConfig;
            return this;
        }

        @Override
        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            this.overwrite = enabled;
            return this;
        }

        private WriteBuilder createContextFunc(Function<Map<String, String>, Context> newCreateContextFunc) {
            this.createContextFunc = newCreateContextFunc;
            return this;
        }

        @Override
        public <D> FileAppender<D> build() throws IOException {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            Preconditions.checkNotNull(this.name, "Table name is required and cannot be null");
            Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumWriter<?>> writerFunc = this.createWriterFunc != null ? this.createWriterFunc : GenericAvroWriter::new;
            this.meta("iceberg.schema", SchemaParser.toJson(this.schema));
            Context context = this.createContextFunc.apply(this.config);
            CodecFactory codec = context.codec();
            return new AvroFileAppender(this.schema, AvroSchemaUtil.convert(this.schema, this.name), this.file, writerFunc, codec, this.metadata, this.metricsConfig, this.overwrite);
        }

        private static class Context {
            private final CodecFactory codec;

            private Context(CodecFactory codec) {
                this.codec = codec;
            }

            static Context dataContext(Map<String, String> config) {
                String codecAsString = config.getOrDefault("write.avro.compression-codec", "gzip");
                String compressionLevel = config.getOrDefault("write.avro.compression-level", TableProperties.AVRO_COMPRESSION_LEVEL_DEFAULT);
                CodecFactory codec = Context.toCodec(codecAsString, compressionLevel);
                return new Context(codec);
            }

            static Context deleteContext(Map<String, String> config) {
                Context dataContext = Context.dataContext(config);
                String codecAsString = config.get("write.delete.avro.compression-codec");
                String compressionLevel = config.getOrDefault("write.delete.avro.compression-level", TableProperties.AVRO_COMPRESSION_LEVEL_DEFAULT);
                CodecFactory codec = codecAsString != null ? Context.toCodec(codecAsString, compressionLevel) : dataContext.codec();
                return new Context(codec);
            }

            private static CodecFactory toCodec(String codecAsString, String compressionLevel) {
                CodecFactory codecFactory;
                try {
                    switch (Codec.valueOf(codecAsString.toUpperCase(Locale.ENGLISH))) {
                        case UNCOMPRESSED: {
                            codecFactory = CodecFactory.nullCodec();
                            break;
                        }
                        case SNAPPY: {
                            codecFactory = CodecFactory.snappyCodec();
                            break;
                        }
                        case ZSTD: {
                            codecFactory = CodecFactory.zstandardCodec(Context.compressionLevelAsInt(compressionLevel, 1));
                            break;
                        }
                        case GZIP: {
                            codecFactory = CodecFactory.deflateCodec(Context.compressionLevelAsInt(compressionLevel, 9));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported compression codec: " + codecAsString);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unsupported compression codec: " + codecAsString);
                }
                return codecFactory;
            }

            private static int compressionLevelAsInt(String tableCompressionLevel, int defaultCompressionLevel) {
                return tableCompressionLevel != null ? Integer.parseInt(tableCompressionLevel) : defaultCompressionLevel;
            }

            CodecFactory codec() {
                return this.codec;
            }
        }
    }

    private static enum Codec {
        UNCOMPRESSED,
        SNAPPY,
        GZIP,
        ZSTD;

    }
}

