/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.tez.dag.api.DAGNotRunningException;
import org.apache.tez.dag.api.NoCurrentDAGException;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezException;

public final class RPCUtil {
    private RPCUtil() {
    }

    public static TezException getRemoteException(Throwable t) {
        return new TezException(t);
    }

    public static TezException getRemoteException(String message) {
        return new TezException(message);
    }

    private static <T extends Throwable> T instantiateException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        try {
            Constructor<T> cn = cls.getConstructor(String.class);
            cn.setAccessible(true);
            Throwable ex = (Throwable)cn.newInstance(re.getMessage());
            ex.initCause((Throwable)re);
            return (T)ex;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw re;
        }
    }

    private static <T extends TezException> T instantiateTezException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        return (T)((TezException)RPCUtil.instantiateException(cls, re));
    }

    private static <T extends IOException> T instantiateIOException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        return (T)((IOException)RPCUtil.instantiateException(cls, re));
    }

    private static <T extends RuntimeException> T instantiateRuntimeException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        return (T)((RuntimeException)RPCUtil.instantiateException(cls, re));
    }

    public static Void unwrapAndThrowException(ServiceException se) throws IOException, TezException {
        Throwable cause = se.getCause();
        if (cause == null) {
            throw new IOException(se);
        }
        if (cause instanceof RemoteException) {
            Class<?> realClass;
            RemoteException re = (RemoteException)cause;
            try {
                realClass = Class.forName(re.getClassName());
            }
            catch (ClassNotFoundException cnf) {
                throw RPCUtil.instantiateTezException(TezException.class, re);
            }
            if (SessionNotRunning.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateTezException(realClass.asSubclass(SessionNotRunning.class), re);
            }
            if (DAGNotRunningException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateTezException(realClass.asSubclass(DAGNotRunningException.class), re);
            }
            if (NoCurrentDAGException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateTezException(realClass.asSubclass(NoCurrentDAGException.class), re);
            }
            if (TezException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateTezException(realClass.asSubclass(TezException.class), re);
            }
            if (IOException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateIOException(realClass.asSubclass(IOException.class), re);
            }
            if (RuntimeException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateRuntimeException(realClass.asSubclass(RuntimeException.class), re);
            }
            throw re;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new IOException(se);
    }

    public static Void unwrapAndThrowNonIOException(ServiceException se) throws TezException {
        try {
            return RPCUtil.unwrapAndThrowException(se);
        }
        catch (IOException ioe) {
            throw new TezException(ioe);
        }
    }
}

