/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.serde2.thrift.Type;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.rpc.thrift.TRowSet;

public class ConvertedResultSet
implements RowSet {
    private final List<Object[]> rows = new ArrayList<Object[]>();
    private final int numColumns;
    static final Map<Type, UnaryOperator<Object>> convertFuncs = new EnumMap<Type, UnaryOperator<Object>>(Type.class){
        {
            this.put(Type.BINARY_TYPE, o -> o instanceof String ? (Object)((String)o).getBytes() : Integer.valueOf(0));
            this.put(Type.TIMESTAMP_TYPE, o -> Timestamp.valueOf((String)o));
            this.put(Type.TIMESTAMPLOCALTZ_TYPE, o -> TimestampTZUtil.parse((String)((String)o)));
            this.put(Type.DECIMAL_TYPE, o -> new BigDecimal((String)o));
            this.put(Type.DATE_TYPE, o -> Date.valueOf((String)o));
            this.put(Type.INTERVAL_YEAR_MONTH_TYPE, o -> HiveIntervalYearMonth.valueOf((String)((String)o)));
            this.put(Type.INTERVAL_DAY_TIME_TYPE, o -> HiveIntervalDayTime.valueOf((String)((String)o)));
        }
    };

    public ConvertedResultSet(RowSet rowSet, TableSchema schema) {
        this.numColumns = rowSet.numColumns();
        Iterator srcIter = rowSet.iterator();
        int nCols = schema.getSize();
        UnaryOperator[] colConvert = new UnaryOperator[nCols];
        for (int i = 0; i < nCols; ++i) {
            colConvert[i] = convertFuncs.get(schema.getColumnDescriptorAt(i).getType());
        }
        while (srcIter.hasNext()) {
            Object[] srcRow = (Object[])srcIter.next();
            Object[] dstRow = new Object[srcRow.length];
            for (int i = 0; i < nCols; ++i) {
                dstRow[i] = colConvert[i] != null && srcRow[i] != null ? colConvert[i].apply(srcRow[i]) : srcRow[i];
            }
            this.rows.add(dstRow);
        }
    }

    public ConvertedResultSet addRow(Object[] fields) {
        throw new UnsupportedOperationException("addRow");
    }

    public int numColumns() {
        return this.numColumns;
    }

    public int numRows() {
        return this.rows.size();
    }

    public ConvertedResultSet extractSubset(int maxRows) {
        throw new UnsupportedOperationException("extractSubset");
    }

    public long getStartOffset() {
        throw new UnsupportedOperationException("getStartOffset");
    }

    public void setStartOffset(long startOffset) {
        throw new UnsupportedOperationException("setStartOffset");
    }

    public TRowSet toTRowSet() {
        throw new UnsupportedOperationException("toTRowSet");
    }

    public Iterator<Object[]> iterator() {
        return new Iterator<Object[]>(){
            final Iterator<Object[]> iterator;
            {
                this.iterator = ConvertedResultSet.this.rows.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Object[] next() {
                return this.iterator.next();
            }
        };
    }
}

