/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.Serializable;

public class Point
extends Geometry
implements Serializable {
    private double m_x;
    private double m_y;
    private double[] m_attributes;

    public Point() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_x = Double.NaN;
        this.m_y = Double.NaN;
    }

    public Point(VertexDescription vd) {
        if (vd == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = vd;
        this._setToDefault();
    }

    public Point(double x, double y) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setXY(x, y);
    }

    public Point(Point2D pt) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.setXY(pt);
    }

    public Point(double x, double y, double z) {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        Point3D pt = new Point3D();
        pt.setCoords(x, y, z);
        this.setXYZ(pt);
    }

    public final Point2D getXY() {
        Point2D pt = new Point2D();
        pt.setCoords(this.m_x, this.m_y);
        return pt;
    }

    public final void getXY(Point2D pt) {
        pt.setCoords(this.m_x, this.m_y);
    }

    public final void setXY(Point2D pt) {
        this._touch();
        this.setXY(pt.x, pt.y);
    }

    public Point3D getXYZ() {
        Point3D pt = new Point3D();
        pt.x = this.m_x;
        pt.y = this.m_y;
        pt.z = this.hasZ() ? this.m_attributes[0] : VertexDescription.getDefaultValue(1);
        return pt;
    }

    public void setXYZ(Point3D pt) {
        this._touch();
        this.addAttribute(1);
        this.m_x = pt.x;
        this.m_y = pt.y;
        this.m_attributes[0] = pt.z;
    }

    public final double getX() {
        return this.m_x;
    }

    public void setX(double x) {
        this.m_x = x;
    }

    public final double getY() {
        return this.m_y;
    }

    public void setY(double y) {
        this.m_y = y;
    }

    public double getZ() {
        return this.hasZ() ? this.m_attributes[0] : VertexDescription.getDefaultValue(1);
    }

    public void setZ(double z) {
        this.setAttribute(1, 0, z);
    }

    public double getM() {
        return this.getAttributeAsDbl(2, 0);
    }

    public void setM(double m) {
        this.setAttribute(2, 0, m);
    }

    public int getID() {
        return this.getAttributeAsInt(3, 0);
    }

    public void setID(int id) {
        this.setAttribute(3, 0, id);
    }

    public double getAttributeAsDbl(int semantics, int ordinate) {
        if (semantics == 0) {
            if (ordinate == 0) {
                return this.m_x;
            }
            if (ordinate == 1) {
                return this.m_y;
            }
            throw new IndexOutOfBoundsException();
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return this.m_attributes[this.m_description._getPointAttributeOffset(attributeIndex) - 2 + ordinate];
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    public int getAttributeAsInt(int semantics, int ordinate) {
        return (int)this.getAttributeAsDbl(semantics, ordinate);
    }

    public void setAttribute(int semantics, int ordinate, double value) {
        this._touch();
        if (semantics == 0) {
            if (ordinate == 0) {
                this.m_x = value;
            } else if (ordinate == 1) {
                this.m_y = value;
            } else {
                throw new IndexOutOfBoundsException();
            }
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ncomps < ordinate) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex < 0) {
            this.addAttribute(semantics);
            attributeIndex = this.m_description.getAttributeIndex(semantics);
        }
        this.m_attributes[this.m_description._getPointAttributeOffset((int)attributeIndex) - 2 + ordinate] = value;
    }

    public void setAttribute(int semantics, int ordinate, int value) {
        this.setAttribute(semantics, ordinate, (double)value);
    }

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.Point;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public long estimateMemorySize() {
        return 40L + Point.estimateMemorySize(this.m_attributes);
    }

    @Override
    public void setEmpty() {
        this._touch();
        this._setToDefault();
    }

    @Override
    protected void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        int[] mapping = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
        int newLen = newDescription.getTotalComponentCount() - 2;
        if (newLen > 0) {
            double[] newAttributes = new double[newLen];
            int j = 0;
            int i = 1;
            int n = newDescription.getAttributeCount();
            while (i < n) {
                int ord;
                int semantics = newDescription.getSemantics(i);
                int nords = VertexDescription.getComponentCount(semantics);
                if (mapping[i] == -1) {
                    double d = VertexDescription.getDefaultValue(semantics);
                    ord = 0;
                    while (ord < nords) {
                        newAttributes[j] = d;
                        ++j;
                        ++ord;
                    }
                } else {
                    int m = mapping[i];
                    int offset = this.m_description._getPointAttributeOffset(m) - 2;
                    ord = 0;
                    while (ord < nords) {
                        newAttributes[j] = this.m_attributes[offset];
                        ++j;
                        ++offset;
                        ++ord;
                    }
                }
                ++i;
            }
            this.m_attributes = newAttributes;
        } else {
            this.m_attributes = null;
        }
        this.m_description = newDescription;
    }

    private void _setToDefault() {
        int len = this.m_description.getTotalComponentCount() - 2;
        if (len != 0) {
            if (this.m_attributes == null || this.m_attributes.length != len) {
                this.m_attributes = new double[len];
            }
            System.arraycopy(this.m_description._getDefaultPointAttributes(), 2, this.m_attributes, 0, len);
        } else {
            this.m_attributes = null;
        }
        this.m_x = Double.NaN;
        this.m_y = Double.NaN;
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        if (this.isEmptyImpl()) {
            return;
        }
        Point2D pt = this.getXY();
        transform.transform(pt, pt);
        this.setXY(pt);
    }

    @Override
    public void applyTransformation(Transformation3D transform) {
        if (this.isEmptyImpl()) {
            return;
        }
        this.addAttribute(1);
        Point3D pt = this.getXYZ();
        this.setXYZ(transform.transform(pt));
    }

    @Override
    public void copyTo(Geometry dst) {
        if (dst.getType() != Geometry.Type.Point) {
            throw new IllegalArgumentException();
        }
        if (this == dst) {
            return;
        }
        dst._touch();
        Point pointDst = (Point)dst;
        dst.m_description = this.m_description;
        pointDst.m_x = this.m_x;
        pointDst.m_y = this.m_y;
        int attrLen = this.m_description.getTotalComponentCount() - 2;
        if (attrLen == 0) {
            pointDst.m_attributes = null;
            return;
        }
        if (pointDst.m_attributes == null || pointDst.m_attributes.length != attrLen) {
            pointDst.m_attributes = new double[attrLen];
        }
        System.arraycopy(this.m_attributes, 0, pointDst.m_attributes, 0, attrLen);
    }

    @Override
    public Geometry createInstance() {
        Point point = new Point(this.m_description);
        return point;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmptyImpl();
    }

    final boolean isEmptyImpl() {
        return NumberUtils.isNaN(this.m_x) || NumberUtils.isNaN(this.m_y);
    }

    @Override
    public void queryEnvelope(Envelope env) {
        if (this.m_description != env.m_description) {
            env.assignVertexDescription(this.m_description);
        }
        env.setEmpty();
        env.merge(this);
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return;
        }
        env.xmin = this.m_x;
        env.ymin = this.m_y;
        env.xmax = this.m_x;
        env.ymax = this.m_y;
    }

    @Override
    void queryEnvelope3D(Envelope3D env) {
        double z;
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return;
        }
        env.xmin = this.m_x;
        env.ymin = this.m_y;
        env.xmax = this.m_x;
        env.ymax = this.m_y;
        env.zmin = z = this.getZ();
        env.zmax = z;
    }

    @Override
    public Envelope1D queryInterval(int semantics, int ordinate) {
        double s;
        Envelope1D env = new Envelope1D();
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return env;
        }
        env.vmin = s = this.getAttributeAsDbl(semantics, ordinate);
        env.vmax = s;
        return env;
    }

    public void setXY(double x, double y) {
        this._touch();
        this.m_x = x;
        this.m_y = y;
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Point)) {
            return false;
        }
        Point otherPt = (Point)_other;
        if (this.m_description != otherPt.m_description) {
            return false;
        }
        if (this.isEmptyImpl()) {
            return otherPt.isEmptyImpl();
        }
        if (this.m_x != otherPt.m_x || this.m_y != otherPt.m_y) {
            return false;
        }
        int i = 0;
        int n = this.m_description.getTotalComponentCount() - 2;
        while (i < n) {
            if (!NumberUtils.isEqualNonIEEE(this.m_attributes[i], otherPt.m_attributes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.m_description.hashCode();
        if (!this.isEmptyImpl()) {
            hashCode = NumberUtils.hash(hashCode, this.m_x);
            hashCode = NumberUtils.hash(hashCode, this.m_y);
            int i = 0;
            int n = this.m_description.getTotalComponentCount() - 2;
            while (i < n) {
                long bits = Double.doubleToLongBits(this.m_attributes[i]);
                int hc = (int)(bits ^ bits >>> 32);
                hashCode = NumberUtils.hash(hashCode, hc);
                ++i;
            }
        }
        return hashCode;
    }

    @Override
    public Geometry getBoundary() {
        return null;
    }

    @Override
    public void replaceNaNs(int semantics, double value) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        int i = 0;
        while (i < ncomps) {
            double v = this.getAttributeAsDbl(semantics, i);
            if (Double.isNaN(v)) {
                this.setAttribute(semantics, i, value);
            }
            ++i;
        }
    }
}

