/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class GenericGeometrySerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    int geometryType;
    byte[] esriShape = null;
    int simpleFlag = 0;
    double tolerance = 0.0;
    boolean[] ogcFlags = null;

    public Object readResolve() throws ObjectStreamException {
        Geometry geometry = null;
        try {
            geometry = GeometryEngine.geometryFromEsriShape(this.esriShape, Geometry.Type.intToType(this.geometryType));
            if (Geometry.isMultiVertex(this.geometryType)) {
                MultiVertexGeometryImpl mvImpl = (MultiVertexGeometryImpl)geometry._getImpl();
                if (!geometry.isEmpty() && Geometry.isMultiPath(this.geometryType)) {
                    MultiPathImpl mpImpl = (MultiPathImpl)geometry._getImpl();
                    AttributeStreamOfInt8 pathFlags = mpImpl.getPathFlagsStreamRef();
                    int i = 0;
                    int n = mpImpl.getPathCount();
                    while (i < n) {
                        if (this.ogcFlags[i]) {
                            pathFlags.setBits(i, (byte)4);
                        }
                        ++i;
                    }
                }
                mvImpl.setIsSimple(this.simpleFlag, this.tolerance, false);
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot read geometry from stream");
        }
        return geometry;
    }

    public void setGeometryByValue(Geometry geometry) throws ObjectStreamException {
        try {
            this.esriShape = GeometryEngine.geometryToEsriShape(geometry);
            this.geometryType = geometry.getType().value();
            if (Geometry.isMultiVertex(this.geometryType)) {
                MultiVertexGeometryImpl mvImpl = (MultiVertexGeometryImpl)geometry._getImpl();
                this.tolerance = mvImpl.m_simpleTolerance;
                this.simpleFlag = mvImpl.getIsSimple(0.0);
                if (!geometry.isEmpty() && Geometry.isMultiPath(this.geometryType)) {
                    MultiPathImpl mpImpl = (MultiPathImpl)geometry._getImpl();
                    this.ogcFlags = new boolean[mpImpl.getPathCount()];
                    AttributeStreamOfInt8 pathFlags = mpImpl.getPathFlagsStreamRef();
                    int i = 0;
                    int n = mpImpl.getPathCount();
                    while (i < n) {
                        this.ogcFlags[i] = (pathFlags.read(i) & 4) != 0;
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot serialize this geometry");
        }
    }
}

