/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.util.Base64;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyBinary
extends LazyPrimitive<LazyBinaryObjectInspector, BytesWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyBinary.class);

    public LazyBinary(LazyBinaryObjectInspector oi) {
        super(oi);
        this.data = new BytesWritable();
    }

    public LazyBinary(LazyBinary other) {
        super(other);
        BytesWritable incoming = (BytesWritable)other.getWritableObject();
        byte[] bytes = new byte[incoming.getLength()];
        System.arraycopy(incoming.getBytes(), 0, bytes, 0, incoming.getLength());
        this.data = new BytesWritable(bytes);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        super.init(bytes, start, length);
        byte[] recv = new byte[length];
        System.arraycopy(bytes.getData(), start, recv, 0, length);
        byte[] decoded = LazyBinary.decodeIfNeeded(recv);
        ((BytesWritable)this.data).set(decoded, 0, decoded.length);
    }

    public static byte[] decodeIfNeeded(byte[] recv) {
        try {
            return Base64.getDecoder().decode(recv);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Data does not contain only Base64 characters so return original byte array", (Throwable)e);
            return recv;
        }
    }
}

