/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.AbstractUUIDGenerator;

public class UUIDStringGenerator
extends AbstractUUIDGenerator {
    public UUIDStringGenerator(StoreManager storeMgr, String name) {
        super(storeMgr, name);
    }

    public static Class getStorageClass() {
        return String.class;
    }

    @Override
    protected String getIdentifier() {
        int i;
        byte[] ipAddrBytes = UUIDStringGenerator.getBytesFromInt(IP_ADDRESS);
        byte[] jvmBytes = UUIDStringGenerator.getBytesFromInt(JVM_UNIQUE);
        short timeHigh = (short)(System.currentTimeMillis() >>> 32);
        byte[] timeHighBytes = UUIDStringGenerator.getBytesFromShort(timeHigh);
        int timeLow = (int)System.currentTimeMillis();
        byte[] timeLowBytes = UUIDStringGenerator.getBytesFromInt(timeLow);
        short count = this.getCount();
        byte[] countBytes = UUIDStringGenerator.getBytesFromShort(count);
        byte[] bytes = new byte[16];
        int pos = 0;
        for (i = 0; i < 4; ++i) {
            bytes[pos++] = ipAddrBytes[i];
        }
        for (i = 0; i < 4; ++i) {
            bytes[pos++] = jvmBytes[i];
        }
        for (i = 0; i < 2; ++i) {
            bytes[pos++] = timeHighBytes[i];
        }
        for (i = 0; i < 4; ++i) {
            bytes[pos++] = timeLowBytes[i];
        }
        for (i = 0; i < 2; ++i) {
            bytes[pos++] = countBytes[i];
        }
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (Exception e) {
            return new String(bytes);
        }
    }

    private static byte[] getBytesFromInt(int val) {
        byte[] arr = new byte[4];
        for (int i = 3; i >= 0; --i) {
            arr[i] = (byte)((0xFFL & (long)val) + -128L);
            val >>>= 8;
        }
        return arr;
    }

    private static byte[] getBytesFromShort(short val) {
        byte[] arr = new byte[2];
        for (int i = 1; i >= 0; --i) {
            arr[i] = (byte)((0xFFL & (long)val) + -128L);
            val = (short)(val >>> 8);
        }
        return arr;
    }
}

