/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction.evaluator.amoro;

import java.util.List;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.OptimizingConfig;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.OptimizingType;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.PartitionEvaluator;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableRuntime;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPartitionEvaluator
implements PartitionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(CommonPartitionEvaluator.class);
    private final Set<String> deleteFileSet = Sets.newHashSet();
    protected final TableRuntime tableRuntime;
    private final Pair<Integer, StructLike> partition;
    protected final OptimizingConfig config;
    protected final long fragmentSize;
    protected final long minTargetSize;
    protected final long planTime;
    private final boolean reachFullInterval;
    protected int fragmentFileCount = 0;
    protected long fragmentFileSize = 0L;
    protected int rewriteSegmentFileCount = 0;
    protected long rewriteSegmentFileSize = 0L;
    protected int undersizedSegmentFileCount = 0;
    protected long undersizedSegmentFileSize = 0L;
    protected int rewritePosSegmentFileCount = 0;
    protected int combinePosSegmentFileCount = 0;
    protected long rewritePosSegmentFileSize = 0L;
    protected long min1SegmentFileSize = Integer.MAX_VALUE;
    protected long min2SegmentFileSize = Integer.MAX_VALUE;
    protected int equalityDeleteFileCount = 0;
    protected long equalityDeleteFileSize = 0L;
    protected int posDeleteFileCount = 0;
    protected long posDeleteFileSize = 0L;
    private long cost = -1L;
    private Boolean necessary = null;
    private OptimizingType optimizingType = null;
    private String name;

    public CommonPartitionEvaluator(TableRuntime tableRuntime, Pair<Integer, StructLike> partition, long planTime) {
        this.partition = partition;
        this.tableRuntime = tableRuntime;
        this.config = tableRuntime.getOptimizingConfig();
        this.fragmentSize = this.config.getTargetSize() / (long)this.config.getFragmentRatio();
        this.minTargetSize = (long)((double)this.config.getTargetSize() * this.config.getMinTargetSizeRatio());
        if (this.minTargetSize > this.config.getTargetSize() - this.fragmentSize) {
            LOG.warn("The self-optimizing.min-target-size-ratio is set too large, some segment files will not be able to find the another merge file.");
        }
        this.planTime = planTime;
        this.reachFullInterval = this.config.getFullTriggerInterval() >= 0 && planTime - tableRuntime.getLastFullOptimizingTime() > (long)this.config.getFullTriggerInterval();
    }

    @Override
    public Pair<Integer, StructLike> getPartition() {
        return this.partition;
    }

    protected boolean isFragmentFile(DataFile dataFile) {
        return dataFile.fileSizeInBytes() <= this.fragmentSize;
    }

    protected boolean isUndersizedSegmentFile(DataFile dataFile) {
        return dataFile.fileSizeInBytes() > this.fragmentSize && dataFile.fileSizeInBytes() <= this.minTargetSize;
    }

    @Override
    public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        if (!this.config.isEnabled()) {
            return false;
        }
        if (this.isFragmentFile(dataFile)) {
            return this.addFragmentFile(dataFile, deletes);
        }
        if (this.isUndersizedSegmentFile(dataFile)) {
            return this.addUndersizedSegmentFile(dataFile, deletes);
        }
        return this.addTargetSizeReachedFile(dataFile, deletes);
    }

    private boolean isDuplicateDelete(ContentFile<?> delete) {
        boolean deleteExist = this.deleteFileSet.contains(delete.path().toString());
        if (!deleteExist) {
            this.deleteFileSet.add(delete.path().toString());
        }
        return deleteExist;
    }

    private boolean addFragmentFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        this.fragmentFileSize += dataFile.fileSizeInBytes();
        ++this.fragmentFileCount;
        for (ContentFile<?> delete : deletes) {
            this.addDelete(delete);
        }
        return true;
    }

    private boolean addUndersizedSegmentFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        for (ContentFile<?> delete : deletes) {
            this.addDelete(delete);
        }
        if (this.fileShouldRewrite(dataFile, deletes)) {
            this.rewriteSegmentFileSize += dataFile.fileSizeInBytes();
            ++this.rewriteSegmentFileCount;
            return true;
        }
        if (dataFile.fileSizeInBytes() < this.min1SegmentFileSize) {
            this.min2SegmentFileSize = this.min1SegmentFileSize;
            this.min1SegmentFileSize = dataFile.fileSizeInBytes();
        } else if (dataFile.fileSizeInBytes() < this.min2SegmentFileSize) {
            this.min2SegmentFileSize = dataFile.fileSizeInBytes();
        }
        this.undersizedSegmentFileSize += dataFile.fileSizeInBytes();
        ++this.undersizedSegmentFileCount;
        return true;
    }

    private boolean addTargetSizeReachedFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        if (this.fileShouldRewrite(dataFile, deletes)) {
            this.rewriteSegmentFileSize += dataFile.fileSizeInBytes();
            ++this.rewriteSegmentFileCount;
            for (ContentFile<?> delete : deletes) {
                this.addDelete(delete);
            }
            return true;
        }
        if (this.segmentShouldRewritePos(dataFile, deletes)) {
            this.rewritePosSegmentFileSize += dataFile.fileSizeInBytes();
            ++this.rewritePosSegmentFileCount;
            for (ContentFile<?> delete : deletes) {
                this.addDelete(delete);
            }
            return true;
        }
        return false;
    }

    protected boolean fileShouldFullOptimizing(DataFile dataFile, List<ContentFile<?>> deleteFiles) {
        if (this.config.isFullRewriteAllFiles()) {
            return true;
        }
        return !deleteFiles.isEmpty() || this.isFragmentFile(dataFile) || this.isUndersizedSegmentFile(dataFile);
    }

    public boolean fileShouldRewrite(DataFile dataFile, List<ContentFile<?>> deletes) {
        if (this.isFullOptimizing()) {
            return this.fileShouldFullOptimizing(dataFile, deletes);
        }
        if (this.isFragmentFile(dataFile)) {
            return true;
        }
        return (double)this.getPosDeletesRecordCount(deletes) > (double)dataFile.recordCount() * this.config.getMajorDuplicateRatio();
    }

    public boolean segmentShouldRewritePos(DataFile dataFile, List<ContentFile<?>> deletes) {
        Preconditions.checkArgument(!this.isFragmentFile(dataFile), "Unsupported fragment file.");
        if (deletes.stream().filter(delete -> delete.content() == FileContent.POSITION_DELETES).count() >= 2L) {
            ++this.combinePosSegmentFileCount;
            return true;
        }
        return deletes.stream().anyMatch(delete -> delete.content() == FileContent.EQUALITY_DELETES);
    }

    protected boolean isFullOptimizing() {
        return this.reachFullInterval();
    }

    private long getPosDeletesRecordCount(List<ContentFile<?>> files) {
        return files.stream().filter(file -> file.content() == FileContent.POSITION_DELETES).mapToLong(ContentFile::recordCount).sum();
    }

    private void addDelete(ContentFile<?> delete) {
        if (this.isDuplicateDelete(delete)) {
            return;
        }
        if (delete.content() == FileContent.POSITION_DELETES) {
            ++this.posDeleteFileCount;
            this.posDeleteFileSize += delete.fileSizeInBytes();
        } else {
            ++this.equalityDeleteFileCount;
            this.equalityDeleteFileSize += delete.fileSizeInBytes();
        }
    }

    @Override
    public boolean isNecessary() {
        if (this.necessary == null) {
            this.necessary = this.isFullOptimizing() ? Boolean.valueOf(this.isFullNecessary()) : Boolean.valueOf(this.isMajorNecessary() || this.isMinorNecessary());
            LOG.debug("{} necessary = {}, {}", new Object[]{this.name(), this.necessary, this});
        }
        return this.necessary;
    }

    @Override
    public long getCost() {
        if (this.cost < 0L) {
            this.cost = (this.fragmentFileSize + this.rewriteSegmentFileSize + this.undersizedSegmentFileSize) * 4L + this.rewritePosSegmentFileSize / 10L + this.posDeleteFileSize + this.equalityDeleteFileSize;
            int fileCnt = this.fragmentFileCount + this.rewriteSegmentFileCount + this.undersizedSegmentFileCount + this.rewritePosSegmentFileCount + this.posDeleteFileCount + this.equalityDeleteFileCount;
            this.cost += (long)fileCnt * this.config.getOpenFileCost();
        }
        return this.cost;
    }

    @Override
    public PartitionEvaluator.Weight getWeight() {
        return new Weight(this.getCost());
    }

    @Override
    public OptimizingType getOptimizingType() {
        if (this.optimizingType == null) {
            this.optimizingType = this.isFullNecessary() ? OptimizingType.FULL : (this.isMajorNecessary() ? OptimizingType.MAJOR : OptimizingType.MINOR);
            LOG.debug("{} optimizingType = {} ", (Object)this.name(), (Object)this.optimizingType);
        }
        return this.optimizingType;
    }

    public boolean enoughContent() {
        return this.undersizedSegmentFileSize >= this.config.getTargetSize() && this.min1SegmentFileSize + this.min2SegmentFileSize <= this.config.getTargetSize();
    }

    public boolean isMajorNecessary() {
        return this.enoughContent() || this.rewriteSegmentFileCount > 0;
    }

    public boolean isMinorNecessary() {
        int smallFileCount = this.fragmentFileCount + this.equalityDeleteFileCount;
        return smallFileCount >= this.config.getMinorLeastFileCount() || smallFileCount > 1 && this.reachMinorInterval() || this.combinePosSegmentFileCount > 0;
    }

    protected boolean reachMinorInterval() {
        return this.config.getMinorLeastInterval() >= 0 && this.planTime - this.tableRuntime.getLastMinorOptimizingTime() > (long)this.config.getMinorLeastInterval();
    }

    protected boolean reachFullInterval() {
        return this.reachFullInterval;
    }

    public boolean isFullNecessary() {
        if (!this.reachFullInterval()) {
            return false;
        }
        return this.anyDeleteExist() || this.fragmentFileCount >= 2 || this.undersizedSegmentFileCount >= 2 || this.rewriteSegmentFileCount > 0 || this.rewritePosSegmentFileCount > 0;
    }

    protected String name() {
        if (this.name == null) {
            this.name = String.format("partition %s of %s", this.partition, this.tableRuntime.getTableIdentifier().toString());
        }
        return this.name;
    }

    public boolean anyDeleteExist() {
        return this.equalityDeleteFileCount > 0 || this.posDeleteFileCount > 0;
    }

    @Override
    public int getFragmentFileCount() {
        return this.fragmentFileCount;
    }

    @Override
    public long getFragmentFileSize() {
        return this.fragmentFileSize;
    }

    @Override
    public int getSegmentFileCount() {
        return this.rewriteSegmentFileCount + this.undersizedSegmentFileCount + this.rewritePosSegmentFileCount;
    }

    @Override
    public long getSegmentFileSize() {
        return this.rewriteSegmentFileSize + this.undersizedSegmentFileSize + this.rewritePosSegmentFileSize;
    }

    @Override
    public int getEqualityDeleteFileCount() {
        return this.equalityDeleteFileCount;
    }

    @Override
    public long getEqualityDeleteFileSize() {
        return this.equalityDeleteFileSize;
    }

    @Override
    public int getPosDeleteFileCount() {
        return this.posDeleteFileCount;
    }

    @Override
    public long getPosDeleteFileSize() {
        return this.posDeleteFileSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("partition", this.partition).add("config", this.config).add("fragmentSize", this.fragmentSize).add("undersizedSegmentSize", this.minTargetSize).add("planTime", this.planTime).add("lastMinorOptimizeTime", this.tableRuntime.getLastMinorOptimizingTime()).add("lastFullOptimizeTime", this.tableRuntime.getLastFullOptimizingTime()).add("lastFullOptimizeTime", this.tableRuntime.getLastFullOptimizingTime()).add("fragmentFileCount", this.fragmentFileCount).add("fragmentFileSize", this.fragmentFileSize).add("rewriteSegmentFileCount", this.rewriteSegmentFileCount).add("rewriteSegmentFileSize", this.rewriteSegmentFileSize).add("undersizedSegmentFileCount", this.undersizedSegmentFileCount).add("undersizedSegmentFileSize", this.undersizedSegmentFileSize).add("rewritePosSegmentFileCount", this.rewritePosSegmentFileCount).add("rewritePosSegmentFileSize", this.rewritePosSegmentFileSize).add("min1SegmentFileSize", this.min1SegmentFileSize).add("min2SegmentFileSize", this.min2SegmentFileSize).add("equalityDeleteFileCount", this.equalityDeleteFileCount).add("equalityDeleteFileSize", this.equalityDeleteFileSize).add("posDeleteFileCount", this.posDeleteFileCount).add("posDeleteFileSize", this.posDeleteFileSize).toString();
    }

    public static class Weight
    implements PartitionEvaluator.Weight {
        private final long cost;

        public Weight(long cost) {
            this.cost = cost;
        }

        @Override
        public int compareTo(PartitionEvaluator.Weight o) {
            return Long.compare(this.cost, ((Weight)o).cost);
        }
    }
}

