/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metasummary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.metasummary.MetadataTableSummary;
import org.apache.hadoop.hive.metastore.metasummary.SummaryMapBuilder;
import org.apache.iceberg.BlobMetadata;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.metasummary.IcebergSummaryRetriever;

public class PuffinStatisticsSummary
extends IcebergSummaryRetriever {
    private static final String STATS = "stats";
    private static final String PUFFIN_STATS_ENABLED = "puffin_enabled";
    private static final String PUFFIN_STATS_BLOB = "puffin_blobs";

    @Override
    public List<String> getFieldNames() {
        if (this.formatJson) {
            return Collections.singletonList(STATS);
        }
        return Arrays.asList(PUFFIN_STATS_ENABLED, PUFFIN_STATS_BLOB);
    }

    @Override
    public void getMetaSummary(Table table, MetadataTableSummary summary) {
        StatisticsFile statsFile;
        List<BlobMetadata> blobMetadatas;
        SummaryMapBuilder builder = new SummaryMapBuilder();
        List<StatisticsFile> statsFiles = table.statisticsFiles();
        builder.add(PUFFIN_STATS_ENABLED, (Object)(statsFiles != null && !statsFiles.isEmpty() ? 1 : 0));
        if (statsFiles != null && !statsFiles.isEmpty() && (blobMetadatas = (statsFile = statsFiles.get(0)).blobMetadata()) != null) {
            builder.add(PUFFIN_STATS_BLOB, (Object)blobMetadatas.stream().map(BlobMetadata::type).collect(Collectors.joining(",")));
        }
        if (builder.get(PUFFIN_STATS_BLOB, String.class) == null) {
            builder.add(PUFFIN_STATS_BLOB, null);
        }
        if (this.formatJson) {
            summary.addExtra(STATS, builder);
        } else {
            summary.addExtra(builder);
        }
    }
}

