/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.org.apache.avro.generic;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hive.iceberg.org.apache.avro.AvroRuntimeException;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.hive.iceberg.org.apache.avro.generic.GenericData;

public class PrimitivesArrays {

    public static class DoubleArray
    extends GenericData.AbstractArray<Double> {
        private static final double[] EMPTY = new double[0];
        private double[] elements = EMPTY;

        public DoubleArray(int capacity, Schema schema) {
            super(schema);
            if (!Schema.Type.DOUBLE.equals((Object)schema.getElementType().getType())) {
                throw new AvroRuntimeException("Not a double array schema: " + String.valueOf(schema));
            }
            if (capacity != 0) {
                this.elements = new double[capacity];
            }
        }

        public DoubleArray(Schema schema, Collection<Double> c) {
            super(schema);
            if (c != null) {
                this.elements = new double[c.size()];
                this.addAll(c);
            }
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Double get(int i) {
            return this.getDouble(i);
        }

        public double getDouble(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            return this.elements[i];
        }

        @Override
        public void add(int location, Double o) {
            if (o == null) {
                return;
            }
            this.add(location, o.floatValue());
        }

        @Override
        public void add(int location, double o) {
            if (location > this.size || location < 0) {
                throw new IndexOutOfBoundsException("Index " + location + " out of bounds.");
            }
            if (this.size == this.elements.length) {
                int newSize = this.size + (this.size >> 1) + 1;
                this.elements = Arrays.copyOf(this.elements, newSize);
            }
            System.arraycopy(this.elements, location, this.elements, location + 1, this.size - location);
            this.elements[location] = o;
            ++this.size;
        }

        @Override
        public Double set(int i, Double o) {
            if (o == null) {
                return null;
            }
            return this.set(i, o.floatValue());
        }

        @Override
        public double set(int i, double o) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            double response = this.elements[i];
            this.elements[i] = o;
            return response;
        }

        @Override
        public Double remove(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            double result = this.elements[i];
            --this.size;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i);
            return result;
        }

        @Override
        public Double peek() {
            return this.size < this.elements.length ? Double.valueOf(this.elements[this.size]) : null;
        }

        @Override
        protected void swap(int index1, int index2) {
            double tmp = this.get(index1);
            this.set(index1, this.get(index2));
            this.set(index2, tmp);
        }
    }

    public static class FloatArray
    extends GenericData.AbstractArray<Float> {
        private static final float[] EMPTY = new float[0];
        private float[] elements = EMPTY;

        public FloatArray(int capacity, Schema schema) {
            super(schema);
            if (!Schema.Type.FLOAT.equals((Object)schema.getElementType().getType())) {
                throw new AvroRuntimeException("Not a float array schema: " + String.valueOf(schema));
            }
            if (capacity != 0) {
                this.elements = new float[capacity];
            }
        }

        public FloatArray(Schema schema, Collection<Float> c) {
            super(schema);
            if (c != null) {
                this.elements = new float[c.size()];
                this.addAll(c);
            }
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Float get(int i) {
            return Float.valueOf(this.getFloat(i));
        }

        public float getFloat(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            return this.elements[i];
        }

        @Override
        public void add(int location, Float o) {
            if (o == null) {
                return;
            }
            this.add(location, o.floatValue());
        }

        @Override
        public void add(int location, float o) {
            if (location > this.size || location < 0) {
                throw new IndexOutOfBoundsException("Index " + location + " out of bounds.");
            }
            if (this.size == this.elements.length) {
                int newSize = this.size + (this.size >> 1) + 1;
                this.elements = Arrays.copyOf(this.elements, newSize);
            }
            System.arraycopy(this.elements, location, this.elements, location + 1, this.size - location);
            this.elements[location] = o;
            ++this.size;
        }

        @Override
        public Float set(int i, Float o) {
            if (o == null) {
                return null;
            }
            return Float.valueOf(this.set(i, o.floatValue()));
        }

        @Override
        public float set(int i, float o) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            float response = this.elements[i];
            this.elements[i] = o;
            return response;
        }

        @Override
        public Float remove(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            float result = this.elements[i];
            --this.size;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i);
            return Float.valueOf(result);
        }

        @Override
        public Float peek() {
            return this.size < this.elements.length ? Float.valueOf(this.elements[this.size]) : null;
        }

        @Override
        protected void swap(int index1, int index2) {
            float tmp = this.get(index1).floatValue();
            this.set(index1, this.get(index2));
            this.set(index2, tmp);
        }
    }

    public static class BooleanArray
    extends GenericData.AbstractArray<Boolean> {
        private static final byte[] EMPTY = new byte[0];
        private byte[] elements = EMPTY;

        public BooleanArray(int capacity, Schema schema) {
            super(schema);
            if (!Schema.Type.BOOLEAN.equals((Object)schema.getElementType().getType())) {
                throw new AvroRuntimeException("Not a boolean array schema: " + String.valueOf(schema));
            }
            if (capacity != 0) {
                this.elements = new byte[1 + capacity / 8];
            }
        }

        public BooleanArray(Schema schema, Collection<Boolean> c) {
            super(schema);
            if (c != null) {
                this.elements = new byte[1 + c.size() / 8];
                if (c instanceof BooleanArray) {
                    BooleanArray other = (BooleanArray)c;
                    this.size = other.size;
                    System.arraycopy(other.elements, 0, this.elements, 0, other.elements.length);
                } else {
                    this.addAll(c);
                }
            }
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Boolean get(int i) {
            return this.getBoolean(i);
        }

        public boolean getBoolean(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            return (this.elements[i / 8] & 1 << i % 8) > 0;
        }

        @Override
        public boolean add(Boolean o) {
            if (o == null) {
                return false;
            }
            return this.add((boolean)o);
        }

        @Override
        public boolean add(boolean o) {
            if (this.size == this.elements.length * 8) {
                int newLength = this.elements.length + (this.elements.length >> 1) + 1;
                this.elements = Arrays.copyOf(this.elements, newLength);
            }
            ++this.size;
            this.set(this.size - 1, o);
            return true;
        }

        @Override
        public void add(int location, Boolean o) {
            if (o == null) {
                return;
            }
            this.add(location, (boolean)o);
        }

        @Override
        public void add(int location, boolean o) {
            if (location > this.size || location < 0) {
                throw new IndexOutOfBoundsException("Index " + location + " out of bounds.");
            }
            if (this.size == this.elements.length * 8) {
                int newLength = this.elements.length + (this.elements.length >> 1) + 1;
                this.elements = Arrays.copyOf(this.elements, newLength);
            }
            ++this.size;
            for (int index = this.size / 8; index > location / 8; --index) {
                int n = index;
                this.elements[n] = (byte)(this.elements[n] << 1);
                if (index <= 0 || (this.elements[index - 1] & 0x100) <= 0) continue;
                int n2 = index;
                this.elements[n2] = (byte)(this.elements[n2] | 1);
            }
            byte pos = (byte)(1 << location % 8);
            byte highbits = (byte)(~(pos + (pos - 1)));
            byte lowbits = (byte)(pos - 1);
            byte currentHigh = (byte)((this.elements[location / 8] & highbits) << 1);
            byte currentLow = (byte)(this.elements[location / 8] & lowbits);
            this.elements[location / 8] = o ? (byte)(currentHigh | currentLow | pos) : (byte)(currentHigh | currentLow);
        }

        @Override
        public Boolean set(int i, Boolean o) {
            if (o == null) {
                return null;
            }
            return this.set(i, (boolean)o);
        }

        @Override
        public boolean set(int i, boolean o) {
            boolean response;
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            boolean bl = response = (this.elements[i / 8] & 1 << i % 8) > 0;
            if (o) {
                int n = i / 8;
                this.elements[n] = (byte)(this.elements[n] | 1 << i % 8);
            } else {
                int n = i / 8;
                this.elements[n] = (byte)(this.elements[n] & 255 - (1 << i % 8));
            }
            return response;
        }

        @Override
        public Boolean remove(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            boolean result = (this.elements[i / 8] & 1 << i % 8) > 0;
            --this.size;
            byte memo = 0;
            if (i / 8 + 1 < this.elements.length) {
                memo = (byte)((1 & this.elements[i / 8 + 1]) << 7);
            }
            for (int index = i / 8 + 1; index <= this.size / 8; ++index) {
                this.elements[index] = (byte)((this.elements[index] & 0xFF) >>> 1);
                if (index + 1 >= this.elements.length || (this.elements[index + 1] & 1) != 1) continue;
                int n = index;
                this.elements[n] = (byte)(this.elements[n] | 0x80);
            }
            byte start = (byte)((1 << (i + 1) % 8) - 1);
            byte end = ~start;
            this.elements[i / 8] = (byte)((start & 0xFF) >>> 1 & this.elements[i / 8] | end & this.elements[i / 8] >> 1 | memo);
            return result;
        }

        @Override
        public Boolean peek() {
            return this.size < this.elements.length * 8 ? Boolean.valueOf((this.elements[this.size / 8] & 1 << this.size % 8) > 0) : null;
        }

        @Override
        protected void swap(int index1, int index2) {
            boolean tmp = this.get(index1);
            this.set(index1, this.get(index2));
            this.set(index2, tmp);
        }
    }

    public static class LongArray
    extends GenericData.AbstractArray<Long> {
        private static final long[] EMPTY = new long[0];
        private long[] elements = EMPTY;

        public LongArray(int capacity, Schema schema) {
            super(schema);
            if (!Schema.Type.LONG.equals((Object)schema.getElementType().getType())) {
                throw new AvroRuntimeException("Not a long array schema: " + String.valueOf(schema));
            }
            if (capacity != 0) {
                this.elements = new long[capacity];
            }
        }

        public LongArray(Schema schema, Collection<Long> c) {
            super(schema);
            if (c != null) {
                this.elements = new long[c.size()];
                this.addAll(c);
            }
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Long get(int i) {
            return this.getLong(i);
        }

        public long getLong(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            return this.elements[i];
        }

        @Override
        public void add(int location, Long o) {
            if (o == null) {
                return;
            }
            this.add(location, (long)o);
        }

        @Override
        public void add(int location, long o) {
            if (location > this.size || location < 0) {
                throw new IndexOutOfBoundsException("Index " + location + " out of bounds.");
            }
            if (this.size == this.elements.length) {
                int newSize = this.size + (this.size >> 1) + 1;
                this.elements = Arrays.copyOf(this.elements, newSize);
            }
            System.arraycopy(this.elements, location, this.elements, location + 1, this.size - location);
            this.elements[location] = o;
            ++this.size;
        }

        @Override
        public Long set(int i, Long o) {
            if (o == null) {
                return null;
            }
            return this.set(i, (long)o);
        }

        @Override
        public long set(int i, long o) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            long response = this.elements[i];
            this.elements[i] = o;
            return response;
        }

        @Override
        public Long remove(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            long result = this.elements[i];
            --this.size;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i);
            return result;
        }

        @Override
        public Long peek() {
            return this.size < this.elements.length ? Long.valueOf(this.elements[this.size]) : null;
        }

        @Override
        protected void swap(int index1, int index2) {
            long tmp = this.elements[index1];
            this.elements[index1] = this.elements[index2];
            this.elements[index2] = tmp;
        }
    }

    public static class IntArray
    extends GenericData.AbstractArray<Integer> {
        private static final int[] EMPTY = new int[0];
        private int[] elements = EMPTY;

        public IntArray(int capacity, Schema schema) {
            super(schema);
            if (!Schema.Type.INT.equals((Object)schema.getElementType().getType())) {
                throw new AvroRuntimeException("Not a int array schema: " + String.valueOf(schema));
            }
            if (capacity != 0) {
                this.elements = new int[capacity];
            }
        }

        public IntArray(Schema schema, Collection<Integer> c) {
            super(schema);
            if (c != null) {
                this.elements = new int[c.size()];
                this.addAll(c);
            }
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Integer get(int i) {
            return this.getInt(i);
        }

        public int getInt(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            return this.elements[i];
        }

        @Override
        public void add(int location, Integer o) {
            if (o == null) {
                return;
            }
            this.add(location, (int)o);
        }

        @Override
        public void add(int location, int o) {
            if (location > this.size || location < 0) {
                throw new IndexOutOfBoundsException("Index " + location + " out of bounds.");
            }
            if (this.size == this.elements.length) {
                int newSize = this.size + (this.size >> 1) + 1;
                this.elements = Arrays.copyOf(this.elements, newSize);
            }
            System.arraycopy(this.elements, location, this.elements, location + 1, this.size - location);
            this.elements[location] = o;
            ++this.size;
        }

        @Override
        public Integer set(int i, Integer o) {
            if (o == null) {
                return null;
            }
            return this.set(i, (int)o);
        }

        @Override
        public int set(int i, int o) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            int response = this.elements[i];
            this.elements[i] = o;
            return response;
        }

        @Override
        public Integer remove(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            int result = this.elements[i];
            --this.size;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i);
            return result;
        }

        @Override
        public Integer peek() {
            return this.size < this.elements.length ? Integer.valueOf(this.elements[this.size]) : null;
        }

        @Override
        protected void swap(int index1, int index2) {
            int tmp = this.elements[index1];
            this.elements[index1] = this.elements[index2];
            this.elements[index2] = tmp;
        }
    }
}

