/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.thrift.ColumnBuffer;
import org.apache.hadoop.hive.serde2.thrift.Type;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.TypeDescriptor;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TRow;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnBasedSet
implements RowSet {
    private long startOffset;
    private final TypeDescriptor[] descriptors;
    private final List<ColumnBuffer> columns;
    private byte[] blob;
    private boolean isBlobBased = false;
    public static final Logger LOG = LoggerFactory.getLogger(ColumnBasedSet.class);

    public ColumnBasedSet(TableSchema schema) {
        this.descriptors = schema.toTypeDescriptors();
        this.columns = new ArrayList<ColumnBuffer>();
        for (ColumnDescriptor colDesc : schema.getColumnDescriptors()) {
            this.columns.add(new ColumnBuffer(colDesc.getType()));
        }
    }

    public ColumnBasedSet(TRowSet tRowSet) throws TException {
        this.descriptors = null;
        this.columns = new ArrayList<ColumnBuffer>();
        if (tRowSet.isSetBinaryColumns()) {
            TCompactProtocol protocol = new TCompactProtocol(new TIOStreamTransport(new ByteArrayInputStream(tRowSet.getBinaryColumns())));
            for (int i = 0; i < tRowSet.getColumnCount(); ++i) {
                TColumn tvalue = new TColumn();
                try {
                    tvalue.read(protocol);
                }
                catch (TException e) {
                    LOG.error(e.getMessage(), e);
                    throw new TException("Error reading column value from the row set blob", e);
                }
                this.columns.add(new ColumnBuffer(tvalue));
            }
        } else if (tRowSet.getColumns() != null) {
            for (TColumn tvalue : tRowSet.getColumns()) {
                this.columns.add(new ColumnBuffer(tvalue));
            }
        }
        this.startOffset = tRowSet.getStartRowOffset();
    }

    private ColumnBasedSet(TypeDescriptor[] descriptors, List<ColumnBuffer> columns, long startOffset) {
        this.descriptors = descriptors;
        this.columns = columns;
        this.startOffset = startOffset;
    }

    public ColumnBasedSet(TableSchema schema, boolean isBlobBased) {
        this(schema);
        this.isBlobBased = isBlobBased;
    }

    @Override
    public ColumnBasedSet addRow(Object[] fields) {
        if (this.isBlobBased) {
            this.blob = (byte[])fields[0];
        } else {
            for (int i = 0; i < fields.length; ++i) {
                TypeDescriptor descriptor = this.descriptors[i];
                Object field = fields[i];
                if (field != null && descriptor.getType() == Type.DECIMAL_TYPE) {
                    int scale = descriptor.getDecimalDigits();
                    field = ((HiveDecimal)field).toFormatString(scale);
                }
                this.columns.get(i).addValue(descriptor.getType(), field);
            }
        }
        return this;
    }

    public List<ColumnBuffer> getColumns() {
        return this.columns;
    }

    @Override
    public int numColumns() {
        return this.columns.size();
    }

    @Override
    public int numRows() {
        return this.columns.isEmpty() ? 0 : this.columns.get(0).size();
    }

    @Override
    public ColumnBasedSet extractSubset(int maxRows) {
        int numRows = Math.min(this.numRows(), maxRows);
        ArrayList<ColumnBuffer> subset = new ArrayList<ColumnBuffer>();
        for (int i = 0; i < this.columns.size(); ++i) {
            subset.add(this.columns.get(i).extractSubset(numRows));
        }
        ColumnBasedSet result = new ColumnBasedSet(this.descriptors, subset, this.startOffset);
        this.startOffset += (long)numRows;
        return result;
    }

    @Override
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    @Override
    public TRowSet toTRowSet() {
        TRowSet tRowSet = new TRowSet(this.startOffset, new ArrayList<TRow>());
        if (this.isBlobBased) {
            tRowSet.setColumns(null);
            tRowSet.setBinaryColumns(this.blob);
            tRowSet.setColumnCount(this.numColumns());
        } else {
            for (int i = 0; i < this.columns.size(); ++i) {
                tRowSet.addToColumns(this.columns.get(i).toTColumn());
            }
        }
        return tRowSet;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return new Iterator<Object[]>(){
            private int index;
            private final Object[] convey;
            {
                this.convey = new Object[ColumnBasedSet.this.numColumns()];
            }

            @Override
            public boolean hasNext() {
                return this.index < ColumnBasedSet.this.numRows();
            }

            @Override
            public Object[] next() {
                for (int i = 0; i < ColumnBasedSet.this.columns.size(); ++i) {
                    this.convey[i] = ColumnBasedSet.this.columns.get(i).get(this.index);
                }
                ++this.index;
                return this.convey;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public Object[] fill(int index, Object[] convey) {
        for (int i = 0; i < this.columns.size(); ++i) {
            convey[i] = this.columns.get(i).get(index);
        }
        return convey;
    }
}

