/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.lang.reflect.InvocationTargetException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class CustomAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private final PasswdAuthenticationProvider customProvider;

    CustomAuthenticationProviderImpl(HiveConf conf) {
        PasswdAuthenticationProvider customProvider;
        Class<?> customHandlerClass = conf.getClass(HiveConf.ConfVars.HIVE_SERVER2_CUSTOM_AUTHENTICATION_CLASS.varname, PasswdAuthenticationProvider.class);
        try {
            customProvider = (PasswdAuthenticationProvider)customHandlerClass.getConstructor(HiveConf.class).newInstance(conf);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            customProvider = (PasswdAuthenticationProvider)ReflectionUtils.newInstance(customHandlerClass, conf);
        }
        this.customProvider = customProvider;
    }

    @Override
    public void authenticate(String user, String password) throws AuthenticationException {
        this.customProvider.authenticate(user, password);
    }
}

