/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.jdbc.ConvertedResultSet;
import org.apache.hive.jdbc.HiveBaseResultSet;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.JdbcColumnAttributes;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCLIServiceConstants;
import org.apache.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.hive.service.rpc.thrift.TColumnDesc;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import org.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.hive.service.rpc.thrift.TTypeQualifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveQueryResultSet
extends HiveBaseResultSet {
    public static final Logger LOG = LoggerFactory.getLogger(HiveQueryResultSet.class);
    private Connection connection;
    private TCLIService.Iface client;
    private TOperationHandle stmtHandle;
    private TFetchOrientation orientation = TFetchOrientation.FETCH_NEXT;
    private boolean checkOperationStatus;
    private int maxRows;
    private int fetchSize;
    private long rowsFetched = 0L;
    private boolean fetchDone = false;
    private RowSet fetchedRows;
    private Iterator<Object[]> fetchedRowsItr;
    private boolean isClosed = false;
    private boolean emptyResultSet = false;
    private boolean isScrollable = false;
    private final TProtocolVersion protocol;
    ExecutorService pool = null;
    AtomicBoolean hasStartRow = new AtomicBoolean(false);
    int fetchThreads = 1;
    int threadsStarted = 0;
    BlockingQueue<FetchResult> resultQueue;
    AtomicLong nextStartRow = new AtomicLong(1L);
    AtomicReference<InterruptedException> interruptException = new AtomicReference();
    AtomicBoolean gotLastBatch = new AtomicBoolean(false);
    AtomicBoolean poolDone = new AtomicBoolean(false);

    protected HiveQueryResultSet(Builder builder) throws SQLException {
        this.statement = builder.statement;
        this.client = builder.client;
        this.connection = builder.connection;
        this.stmtHandle = builder.stmtHandle;
        this.fetchSize = builder.fetchSize;
        this.fetchThreads = builder.fetchThreads;
        this.columnNames = new ArrayList();
        this.normalizedColumnNames = new ArrayList();
        this.columnTypes = new ArrayList();
        this.columnAttributes = new ArrayList();
        if (builder.retrieveSchema) {
            this.retrieveSchema();
        } else {
            this.setSchema(builder.colNames, builder.colTypes, builder.colAttributes);
        }
        this.emptyResultSet = builder.emptyResultSet;
        this.maxRows = builder.maxRows;
        this.checkOperationStatus = this.statement instanceof HiveStatement;
        this.isScrollable = builder.isScrollable;
        this.protocol = builder.getProtocolVersion();
        this.initEmptyIterator();
        this.resultQueue = new ArrayBlockingQueue<FetchResult>(Math.max(this.fetchThreads, 1));
        if (this.fetchThreads > 1) {
            this.useConvertedResultSet = true;
        }
    }

    private static JdbcColumnAttributes getColumnAttributes(TPrimitiveTypeEntry primitiveTypeEntry) {
        JdbcColumnAttributes ret = null;
        if (primitiveTypeEntry.isSetTypeQualifiers()) {
            TTypeQualifiers tq = primitiveTypeEntry.getTypeQualifiers();
            switch (primitiveTypeEntry.getType()) {
                case CHAR_TYPE: 
                case VARCHAR_TYPE: {
                    TTypeQualifierValue val = tq.getQualifiers().get("characterMaximumLength");
                    if (val == null) break;
                    ret = new JdbcColumnAttributes(val.getI32Value(), 0);
                    break;
                }
                case DECIMAL_TYPE: {
                    TTypeQualifierValue prec = tq.getQualifiers().get("precision");
                    TTypeQualifierValue scale = tq.getQualifiers().get("scale");
                    ret = new JdbcColumnAttributes(prec == null ? 10 : prec.getI32Value(), scale == null ? 0 : scale.getI32Value());
                    break;
                }
            }
        }
        return ret;
    }

    private void retrieveSchema() throws SQLException {
        try {
            TGetResultSetMetadataReq metadataReq = new TGetResultSetMetadataReq(this.stmtHandle);
            TGetResultSetMetadataResp metadataResp = this.client.GetResultSetMetadata(metadataReq);
            Utils.verifySuccess(metadataResp.getStatus());
            TTableSchema schema = metadataResp.getSchema();
            if (schema == null || !schema.isSetColumns()) {
                return;
            }
            this.setSchema(new TableSchema(schema));
            for (TColumnDesc column : schema.getColumns()) {
                String columnName = column.getColumnName();
                this.columnNames.add(columnName);
                this.normalizedColumnNames.add(columnName.toLowerCase());
                TPrimitiveTypeEntry primitiveTypeEntry = column.getTypeDesc().getTypes().get(0).getPrimitiveEntry();
                String columnTypeName = TCLIServiceConstants.TYPE_NAMES.get(primitiveTypeEntry.getType());
                this.columnTypes.add(columnTypeName);
                this.columnAttributes.add(HiveQueryResultSet.getColumnAttributes(primitiveTypeEntry));
            }
        }
        catch (SQLException eS) {
            throw eS;
        }
        catch (Exception ex) {
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
    }

    private void setSchema(List<String> colNames, List<String> colTypes, List<JdbcColumnAttributes> colAttributes) {
        this.columnNames.addAll(colNames);
        this.columnTypes.addAll(colTypes);
        this.columnAttributes.addAll(colAttributes);
        colNames.forEach(i -> this.normalizedColumnNames.add(i.toLowerCase()));
    }

    private void initEmptyIterator() throws SQLException {
        try {
            this.fetchedRows = RowSetFactory.create(new TRowSet(), this.protocol);
            this.fetchedRowsItr = this.fetchedRows.iterator();
        }
        catch (TException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        this.shutdownPool();
        if (this.statement != null && this.statement instanceof HiveStatement) {
            HiveStatement s2 = (HiveStatement)this.statement;
            s2.closeOnResultSetCompletion();
        } else {
            this.closeOperationHandle(this.stmtHandle);
        }
        this.client = null;
        this.stmtHandle = null;
        this.isClosed = true;
        this.initEmptyIterator();
    }

    private void closeOperationHandle(TOperationHandle stmtHandle) throws SQLException {
        try {
            if (stmtHandle != null) {
                TCloseOperationReq closeReq = new TCloseOperationReq(stmtHandle);
                TCloseOperationResp closeResp = this.client.CloseOperation(closeReq);
                Utils.verifySuccessWithInfo(closeResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.toString(), "08S01", e);
        }
    }

    private void closeConn(HiveConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.debug("Error closing connection {}", (Object)e.toString());
            }
        }
    }

    private boolean nextRowBatch() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        if (this.maxRows > 0 && this.rowsFetched >= (long)this.maxRows || this.emptyResultSet || this.fetchDone) {
            return false;
        }
        if (this.checkOperationStatus) {
            ((HiveStatement)this.statement).waitForOperationToComplete();
            this.checkOperationStatus = false;
        }
        if (this.rowsFetched < (long)this.fetchSize || this.fetchThreads == 0 || this.maxRows > 0) {
            try {
                int fetchSizeBounded = this.fetchSize;
                if (this.maxRows > 0 && this.rowsFetched + (long)this.fetchSize > (long)this.maxRows) {
                    fetchSizeBounded = this.maxRows - (int)this.rowsFetched;
                }
                TFetchResultsReq fetchReq = new TFetchResultsReq(this.stmtHandle, this.orientation, fetchSizeBounded);
                TFetchResultsResp fetchResp = this.client.FetchResults(fetchReq);
                Utils.verifySuccessWithInfo(fetchResp.getStatus());
                TRowSet results = fetchResp.getResults();
                if (results.getStartRowOffset() > 0L) {
                    this.hasStartRow.set(true);
                }
                this.fetchedRows = RowSetFactory.create(results, this.protocol);
                boolean bl = this.fetchDone = !fetchResp.isHasMoreRows() && this.fetchedRows.numRows() == 0;
                if (this.fetchDone) {
                    this.gotLastBatch.set(true);
                }
                this.fetchedRows = RowSetFactory.create(results, this.protocol);
                if (this.useConvertedResultSet) {
                    this.fetchedRows = new ConvertedResultSet(this.fetchedRows, this.getSchema());
                }
                this.nextStartRow.set(results.getStartRowOffset() + 1L + (long)this.fetchedRows.numRows());
            }
            catch (TException ex) {
                throw new SQLException("Error retrieving next row", ex);
            }
        }
        if (!this.gotLastBatch.get()) {
            if (this.pool == null) {
                this.pool = Executors.newFixedThreadPool(this.fetchThreads);
            }
            if (this.threadsStarted < (this.hasStartRow.get() ? this.fetchThreads : 1)) {
                boolean useMainClient = this.threadsStarted == 0;
                ++this.threadsStarted;
                this.pool.execute(() -> {
                    LOG.debug("Started thread {}", (Object)Thread.currentThread().getName());
                    TCLIService.Iface fetchClient = null;
                    HiveConnection threadConn = null;
                    long startTime = System.nanoTime();
                    while (!this.gotLastBatch.get() && !this.poolDone.get()) {
                        long endTime;
                        if (threadConn != this.connection && (endTime = System.nanoTime()) - startTime > 5000000000L) {
                            this.closeConn(threadConn);
                            threadConn = null;
                            startTime = endTime;
                        }
                        if (threadConn == null) {
                            if (useMainClient) {
                                threadConn = (HiveConnection)this.connection;
                                fetchClient = this.client;
                            } else {
                                try {
                                    threadConn = new HiveConnection((HiveConnection)this.connection);
                                    fetchClient = threadConn.getClient();
                                }
                                catch (SQLException e) {
                                    LOG.debug("Multi-stream connection error {}", (Object)e.toString());
                                    return;
                                }
                            }
                        }
                        FetchResult result = new FetchResult(this);
                        try {
                            boolean hasMoreRows;
                            TFetchResultsReq fetchReq = new TFetchResultsReq(this.stmtHandle, this.orientation, this.fetchSize);
                            TFetchResultsResp fetchResp = fetchClient.FetchResults(fetchReq);
                            Utils.verifySuccessWithInfo(fetchResp.getStatus());
                            TRowSet results = fetchResp.getResults();
                            if (results.getStartRowOffset() > 0L) {
                                this.hasStartRow.set(true);
                            }
                            result.fetchedRows = RowSetFactory.create(results, this.protocol);
                            result.numRows = result.fetchedRows.numRows();
                            boolean bl = hasMoreRows = result.numRows > 0 || fetchResp.isHasMoreRows();
                            if (!hasMoreRows) {
                                this.gotLastBatch.set(true);
                            }
                            result.hasMoreRows = hasMoreRows;
                            result.fetchedRows = RowSetFactory.create(results, this.protocol);
                            if (this.useConvertedResultSet) {
                                result.fetchedRows = new ConvertedResultSet(result.fetchedRows, this.getSchema());
                            }
                            result.startRow = results.getStartRowOffset() + 1L;
                            if (this.hasStartRow.get() && result.startRow < this.nextStartRow.get()) {
                                throw new SQLException("Unexpected row offset");
                            }
                        }
                        catch (Exception e) {
                            result.ex = e;
                        }
                        try {
                            AtomicLong e = this.nextStartRow;
                            synchronized (e) {
                                if (!this.poolDone.get()) {
                                    if (result.ex == null) {
                                        if (this.hasStartRow.get()) {
                                            while (this.nextStartRow.get() != result.startRow) {
                                                this.nextStartRow.wait();
                                            }
                                            this.nextStartRow.set(result.startRow + (long)result.numRows);
                                        }
                                        this.poolDone.set(!result.hasMoreRows);
                                    } else {
                                        this.poolDone.set(true);
                                    }
                                    this.resultQueue.put(result);
                                    if (this.hasStartRow.get()) {
                                        this.nextStartRow.notifyAll();
                                    }
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            this.interruptException.set(e);
                            break;
                        }
                    }
                    if (threadConn != this.connection) {
                        this.closeConn(threadConn);
                    }
                });
            }
        }
        try {
            if (this.interruptException.get() != null) {
                throw this.interruptException.get();
            }
            FetchResult result = this.resultQueue.take();
            boolean bl = this.fetchDone = !result.hasMoreRows;
            if (result.ex != null) {
                this.shutdownPool();
                throw new SQLException(result.ex);
            }
            this.fetchedRows = result.fetchedRows;
        }
        catch (InterruptedException e) {
            throw new SQLException(e);
        }
        this.orientation = TFetchOrientation.FETCH_NEXT;
        this.fetchedRowsItr = this.fetchedRows.iterator();
        return this.fetchedRowsItr.hasNext();
    }

    void drainQueue() throws SQLException {
        FetchResult result;
        while ((result = (FetchResult)this.resultQueue.poll()) != null) {
            if (result.ex == null) continue;
            throw new SQLException(result.ex);
        }
    }

    void shutdownPool() throws SQLException {
        if (this.pool != null) {
            this.poolDone.set(true);
            this.drainQueue();
            this.pool.shutdownNow();
            try {
                while (!this.pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.drainQueue();
                    LOG.debug("Slow fetch thread shutdown");
                }
            }
            catch (InterruptedException e) {
                throw new SQLException(e);
            }
            this.drainQueue();
            this.pool = null;
            this.threadsStarted = 0;
        }
    }

    @Override
    public boolean next() throws SQLException {
        while (!this.fetchedRowsItr.hasNext()) {
            if (this.nextRowBatch()) continue;
            return false;
        }
        this.row = this.fetchedRowsItr.next();
        ++this.rowsFetched;
        return true;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        return super.getMetaData();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getType() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        if (this.isScrollable) {
            return 1004;
        }
        return 1003;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        return this.fetchSize;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        if (!this.isScrollable) {
            throw new SQLException("Method not supported for TYPE_FORWARD_ONLY resultset");
        }
        this.shutdownPool();
        this.initEmptyIterator();
        this.orientation = TFetchOrientation.FETCH_FIRST;
        this.rowsFetched = 0L;
        this.nextStartRow.set(1L);
        this.fetchDone = false;
        this.poolDone.set(false);
        this.gotLastBatch.set(false);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Resultset is closed");
        }
        return this.rowsFetched == 0L;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.rowsFetched > Integer.MAX_VALUE) {
            throw new SQLException("getRow() result exceeds Int.MAX_VALUE");
        }
        return (int)this.rowsFetched;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public static class Builder {
        private final Statement statement;
        private Connection connection = null;
        private TCLIService.Iface client = null;
        private TOperationHandle stmtHandle = null;
        private int maxRows = 0;
        private boolean retrieveSchema = true;
        private List<String> colNames;
        private List<String> colTypes;
        private List<JdbcColumnAttributes> colAttributes;
        private int fetchSize = 50;
        private int fetchThreads = 1;
        private boolean emptyResultSet = false;
        private boolean isScrollable = false;

        public Builder(Statement statement) throws SQLException {
            this.statement = statement;
            this.connection = statement.getConnection();
        }

        public Builder(Connection connection) {
            this.statement = null;
            this.connection = connection;
        }

        public Builder setConnection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public Builder setClient(TCLIService.Iface client) {
            this.client = client;
            return this;
        }

        public Builder setStmtHandle(TOperationHandle stmtHandle) {
            this.stmtHandle = stmtHandle;
            return this;
        }

        public Builder setMaxRows(int maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public Builder setSchema(List<String> colNames, List<String> colTypes) {
            List<Object> colAttributes = Collections.nCopies(colTypes.size(), null);
            return this.setSchema(colNames, colTypes, colAttributes);
        }

        public Builder setSchema(List<String> colNames, List<String> colTypes, List<JdbcColumnAttributes> colAttributes) {
            this.colNames = new ArrayList<String>(colNames);
            this.colTypes = new ArrayList<String>(colTypes);
            this.colAttributes = new ArrayList<JdbcColumnAttributes>(colAttributes);
            this.retrieveSchema = false;
            return this;
        }

        public Builder setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder setFetchThreads(int fetchThreads) {
            this.fetchThreads = fetchThreads;
            return this;
        }

        public Builder setEmptyResultSet(boolean emptyResultSet) {
            this.emptyResultSet = emptyResultSet;
            return this;
        }

        public Builder setScrollable(boolean setScrollable) {
            this.isScrollable = setScrollable;
            return this;
        }

        public HiveQueryResultSet build() throws SQLException {
            return new HiveQueryResultSet(this);
        }

        public TProtocolVersion getProtocolVersion() throws SQLException {
            return ((HiveConnection)this.connection).getProtocol();
        }
    }

    private class FetchResult {
        Exception ex;
        RowSet fetchedRows;
        boolean hasMoreRows;
        long startRow;
        int numRows;

        private FetchResult(HiveQueryResultSet hiveQueryResultSet) {
        }
    }
}

