/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.objects;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.hplsql.ColumnDefinition;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.objects.HplObject;
import org.apache.hive.hplsql.objects.TableClass;

public class Table
implements HplObject {
    private final TableClass hplClass;
    private final Map<Object, Value> rows = new HashMap<Object, Value>();
    private Object lastKey = null;
    private Object firstKey = null;

    public Table(TableClass hplClass) {
        this.hplClass = hplClass;
    }

    public void populate(QueryResult query, long rowIndex, int columnIndex) {
        if (this.hplClass().rowType()) {
            this.putRow(rowIndex, query);
        } else {
            this.putColumn(rowIndex, query, columnIndex);
        }
    }

    public void putRow(Object key, QueryResult result) {
        this.put(key, this.readRow(result));
    }

    public void putColumn(Object key, QueryResult query, int columnIndex) {
        this.put(key, this.readColumn(query, columnIndex));
    }

    public void put(Object key, Row row) {
        Value existing = this.rows.get(key);
        if (existing != null) {
            existing.row = row;
        } else {
            if (this.lastKey != null) {
                this.rows.get((Object)this.lastKey).nextKey = key;
            }
            this.rows.put(key, new Value(row, this.lastKey));
            this.lastKey = key;
            if (this.firstKey == null) {
                this.firstKey = key;
            }
        }
    }

    private Row readRow(QueryResult result) {
        Row row = new Row();
        int idx = 0;
        for (ColumnDefinition column : this.hplClass.columns()) {
            Var var = new Var(column.columnName(), column.columnType().typeString(), (Integer)null, null, null);
            var.setValue(result, idx);
            row.addColumn(column.columnName(), column.columnTypeString(), var);
            ++idx;
        }
        return row;
    }

    private Row readColumn(QueryResult result, int columnIndex) {
        Row row = new Row();
        ColumnDefinition column = this.hplClass.columns().get(0);
        Var var = new Var(column.columnName(), column.columnType().typeString(), (Integer)null, null, null);
        var.setValue(result, columnIndex);
        row.addColumn(column.columnName(), column.columnTypeString(), var);
        return row;
    }

    public Row at(Object key) {
        Value value = this.rows.get(key);
        return value == null ? null : value.row;
    }

    public boolean removeAt(Object key) {
        Value value = this.rows.remove(key);
        if (value != null) {
            this.updateLinks(key, value.nextKey, value.prevKey);
        }
        return value != null;
    }

    private void updateLinks(Object deletedKey, Object nextKey, Object prevKey) {
        if (prevKey != null) {
            this.rows.get((Object)prevKey).nextKey = nextKey;
        }
        if (nextKey != null) {
            this.rows.get((Object)nextKey).prevKey = prevKey;
        }
        if (deletedKey.equals(this.firstKey)) {
            this.firstKey = nextKey;
        }
        if (deletedKey.equals(this.lastKey)) {
            this.lastKey = prevKey;
        }
    }

    public void removeFromTo(Object fromKey, Object toKey) {
        Object current = fromKey;
        while (current != null && !current.equals(toKey)) {
            Object next = this.nextKey(current);
            this.removeAt(current);
            current = next;
        }
        if (current != null) {
            this.removeAt(current);
        }
    }

    public void removeAll() {
        this.lastKey = null;
        this.firstKey = null;
        this.rows.clear();
    }

    public Object nextKey(Object key) {
        Value value = this.rows.get(key);
        return value == null ? null : value.nextKey;
    }

    public Object priorKey(Object key) {
        Value value = this.rows.get(key);
        return value == null ? null : value.prevKey;
    }

    public Object firstKey() {
        return this.firstKey;
    }

    public Object lastKey() {
        return this.lastKey;
    }

    public boolean existsAt(Object key) {
        return this.rows.get(key) != null;
    }

    public int count() {
        return this.rows.size();
    }

    @Override
    public TableClass hplClass() {
        return this.hplClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table{");
        sb.append("hplClass=").append(this.hplClass.getClass());
        sb.append(", size=").append(this.count());
        sb.append(", lastKey=").append(this.lastKey);
        sb.append(", firstKey=").append(this.firstKey);
        sb.append('}');
        return sb.toString();
    }

    private static class Value {
        private Row row;
        private Object prevKey;
        private Object nextKey;

        public Value(Row row, Object prevKey) {
            this.row = row;
            this.prevKey = prevKey;
        }

        public void setPrevKey(Object prevKey) {
            this.prevKey = prevKey;
        }

        public void setNextKey(Object nextKey) {
            this.nextKey = nextKey;
        }
    }
}

