/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.math.BigDecimal;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hive.hplsql.Column;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.SqlCodes;
import org.apache.hive.hplsql.Timer;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.Metadata;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;

public class Cmp
implements Runnable {
    Exec exec;
    private QueryExecutor queryExecutor;
    Timer timer = new Timer();
    boolean trace = false;
    boolean info = false;
    String query;
    String conn;
    HplsqlParser.Cmp_stmtContext ctx;
    int tests = 0;
    int failedTests = 0;
    int failedTestsHighDiff = 0;
    int failedTestsHighDiff10 = 0;
    private QueryResult result;

    Cmp(Exec e, QueryExecutor queryExecutor) {
        this.exec = e;
        this.trace = this.exec.getTrace();
        this.info = this.exec.getInfo();
        this.queryExecutor = queryExecutor;
    }

    Cmp(Exec e, HplsqlParser.Cmp_stmtContext c, String q, String cn, QueryExecutor queryExecutor) {
        this.exec = e;
        this.trace = this.exec.getTrace();
        this.info = this.exec.getInfo();
        this.ctx = c;
        this.query = q;
        this.conn = cn;
        this.queryExecutor = queryExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer run(HplsqlParser.Cmp_stmtContext ctx) {
        this.trace(ctx, "CMP");
        this.ctx = ctx;
        this.timer.start();
        StringBuilder conn1 = new StringBuilder();
        StringBuilder conn2 = new StringBuilder();
        Boolean equal = null;
        Cmp cmp1 = null;
        Cmp cmp2 = null;
        try {
            String sql1 = this.getSql(ctx, conn1, 0);
            String sql2 = this.getSql(ctx, conn2, 1);
            if (this.trace) {
                this.trace(ctx, "Query 1: " + sql1);
                this.trace(ctx, "Query 2: " + sql2);
            }
            cmp1 = new Cmp(this.exec, ctx, sql1, conn1.toString(), this.queryExecutor);
            cmp2 = new Cmp(this.exec, ctx, sql2, conn2.toString(), this.queryExecutor);
            cmp1.run();
            cmp2.run();
            equal = this.compare(cmp1.result, cmp2.result);
        }
        catch (Exception e) {
            this.exec.signal(e);
            Integer n = -1;
            return n;
        }
        finally {
            long elapsed = this.timer.stop();
            if (this.info) {
                Object message = "CMP ";
                if (equal != null) {
                    if (equal.booleanValue()) {
                        message = (String)message + "Equal, " + this.tests + " tests";
                    } else {
                        message = (String)message + "Not Equal, " + this.failedTests + " of " + this.tests + " tests failed";
                        message = (String)message + ", " + this.failedTestsHighDiff + " tests with more than 0.01% difference";
                        message = (String)message + ", " + this.failedTestsHighDiff10 + " tests with more than 10% difference";
                    }
                } else {
                    message = (String)message + "Failed";
                }
                this.info(ctx, (String)message + ", " + this.timer.format());
            }
            cmp1.closeQuery();
            cmp2.closeQuery();
        }
        return 0;
    }

    private void closeQuery() {
        if (this.result != null) {
            this.result.close();
        }
    }

    @Override
    public void run() {
        this.result = this.queryExecutor.executeQuery(this.query, this.ctx);
    }

    Boolean compare(QueryResult query1, QueryResult query2) {
        if (query1.error()) {
            this.exec.signal(query1);
            return null;
        }
        if (query2.error()) {
            this.exec.signal(query2);
            return null;
        }
        if (query1 == null || query2 == null) {
            this.exec.setSqlCode(SqlCodes.ERROR);
            return null;
        }
        boolean equal = true;
        this.tests = 0;
        this.failedTests = 0;
        try {
            Metadata rm1 = query1.metadata();
            Metadata rm2 = query2.metadata();
            int cnt1 = rm1.columnCount();
            int cnt2 = rm2.columnCount();
            this.tests = cnt1;
            while (query1.next() && query2.next()) {
                for (int i = 0; i < this.tests; ++i) {
                    Var v1 = new Var(Var.Type.DERIVED_TYPE);
                    Var v2 = new Var(Var.Type.DERIVED_TYPE);
                    v1.setValue(query1, i);
                    if (i < cnt2) {
                        v2.setValue(query2, i);
                    }
                    boolean e = true;
                    if (!(v1.isNull() && v2.isNull() || v1.equals(v2))) {
                        equal = false;
                        e = false;
                        ++this.failedTests;
                    }
                    if (!this.trace && !this.info) continue;
                    String m4 = rm1.columnName(i) + "\t" + v1.toString() + "\t" + v2.toString();
                    if (!e) {
                        m4 = m4 + "\tNot equal";
                        BigDecimal diff = v1.percentDiff(v2);
                        if (diff != null) {
                            if (diff.compareTo(BigDecimal.ZERO) != 0) {
                                m4 = m4 + ", " + String.valueOf(diff) + "% difference";
                                ++this.failedTestsHighDiff;
                                if (diff.compareTo(BigDecimal.TEN) > 0) {
                                    ++this.failedTestsHighDiff10;
                                }
                            } else {
                                m4 = m4 + ", less then 0.01% difference";
                            }
                        } else {
                            ++this.failedTestsHighDiff;
                            ++this.failedTestsHighDiff10;
                        }
                    }
                    if (this.trace) {
                        this.trace(null, m4);
                        continue;
                    }
                    this.info(null, m4);
                }
                if (equal) {
                    this.exec.setSqlSuccess();
                    continue;
                }
                this.exec.setSqlCode(1);
            }
        }
        catch (Exception e) {
            this.exec.signal(e);
            return null;
        }
        return equal;
    }

    private String getSql(HplsqlParser.Cmp_stmtContext ctx, StringBuilder conn, int idx) throws Exception {
        StringBuilder sql = new StringBuilder();
        String table = null;
        String query = null;
        if (ctx.cmp_source(idx).table_name() != null) {
            table = this.evalPop(ctx.cmp_source(idx).table_name()).toString();
        } else {
            query = this.evalPop(ctx.cmp_source(idx).select_stmt()).toString();
        }
        if (ctx.cmp_source(idx).T_AT() != null) {
            conn.append(ctx.cmp_source(idx).qident().getText());
        } else if (table != null) {
            conn.append(this.exec.getObjectConnection(ctx.cmp_source(idx).table_name().getText()));
        } else {
            conn.append(this.exec.getStatementConnection());
        }
        sql.append("SELECT ");
        sql.append(this.getSelectList(ctx, conn.toString(), table, query));
        sql.append(" FROM ");
        if (table != null) {
            sql.append(table);
            if (ctx.cmp_source(idx).where_clause() != null) {
                sql.append(" " + this.evalPop(ctx.cmp_source(idx).where_clause()).toString());
            }
        } else {
            sql.append("(");
            sql.append(query);
            sql.append(") t");
        }
        return sql.toString();
    }

    private String getSelectList(HplsqlParser.Cmp_stmtContext ctx, String conn, String table, String query) throws Exception {
        Row row;
        StringBuilder sql = new StringBuilder();
        sql.append("COUNT(1) AS row_count");
        if (ctx.T_SUM() != null && table != null && (row = this.exec.meta.getRowDataType(ctx, conn, table)) != null) {
            List<Column> cols = row.getColumns();
            int cnt = row.size();
            sql.append(",\n");
            for (int i = 0; i < cnt; ++i) {
                Column col = cols.get(i);
                String name = col.getName();
                Var.Type type = Var.defineType(col.getType());
                sql.append("COUNT(" + name + ") AS " + name + "_COUNT_NOT_NULL");
                if (type == Var.Type.STRING) {
                    sql.append(",\n");
                    sql.append("SUM(LENGTH(" + name + ")) AS " + name + "_SUM_LENGTH,\n");
                    sql.append("MIN(LENGTH(" + name + ")) AS " + name + "_MIN_LENGTH,\n");
                    sql.append("MAX(LENGTH(" + name + ")) AS " + name + "_MAX_LENGTH");
                } else if (type == Var.Type.BIGINT || type == Var.Type.DECIMAL || type == Var.Type.DOUBLE) {
                    sql.append(",\n");
                    sql.append("SUM(" + name + ") AS " + name + "_SUM,\n");
                    sql.append("MIN(" + name + ") AS " + name + "_MIN,\n");
                    sql.append("MAX(" + name + ") AS " + name + "_MAX");
                } else if (type == Var.Type.DATE || type == Var.Type.TIMESTAMP) {
                    sql.append(",\n");
                    sql.append("SUM(YEAR(" + name + ")) AS " + name + "_SUM_YEAR,\n");
                    sql.append("SUM(MONTH(" + name + ")) AS " + name + "_SUM_MONTH,\n");
                    sql.append("SUM(DAY(" + name + ")) AS " + name + "_SUM_DAY,\n");
                    sql.append("MIN(" + name + ") AS " + name + "_MIN,\n");
                    sql.append("MAX(" + name + ") AS " + name + "_MAX");
                }
                if (i + 1 >= cnt) continue;
                sql.append(",\n");
            }
        }
        return sql.toString();
    }

    private Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    private void trace(ParserRuleContext ctx, String message) {
        this.exec.trace(ctx, message);
    }

    private void info(ParserRuleContext ctx, String message) {
        this.exec.info(ctx, message);
    }
}

