/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimalV1;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class TimestampUtils {
    public static final BigDecimal BILLION_BIG_DECIMAL = BigDecimal.valueOf(1000000000L);

    public static double getDouble(Timestamp ts) {
        long seconds = TimestampUtils.millisToSeconds(ts.getTime());
        return (double)seconds + (double)ts.getNanos() / 1.0E9;
    }

    public static Timestamp doubleToTimestamp(double f) {
        try {
            long seconds = (long)f;
            BigDecimal bd = new BigDecimal(String.valueOf(f));
            bd = bd.subtract(new BigDecimal(seconds)).multiply(new BigDecimal(1000000000));
            int nanos = bd.intValue();
            long millis = seconds * 1000L;
            if (nanos < 0) {
                millis -= 1000L;
                nanos += 1000000000;
            }
            Timestamp t2 = new Timestamp(millis);
            t2.setNanos(nanos);
            return t2;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static Timestamp decimalToTimestamp(HiveDecimal dec) {
        HiveDecimalWritable nanosWritable = new HiveDecimalWritable(dec);
        nanosWritable.mutateFractionPortion();
        nanosWritable.mutateScaleByPowerOfTen(9);
        if (!nanosWritable.isSet() || !nanosWritable.isInt()) {
            return null;
        }
        int nanos = nanosWritable.intValue();
        if (nanos < 0) {
            nanos += 1000000000;
        }
        nanosWritable.setFromLong(nanos);
        HiveDecimalWritable nanoInstant = new HiveDecimalWritable(dec);
        nanoInstant.mutateScaleByPowerOfTen(9);
        nanoInstant.mutateSubtract(nanosWritable);
        nanoInstant.mutateScaleByPowerOfTen(-9);
        if (!nanoInstant.isSet() || !nanoInstant.isLong()) {
            return null;
        }
        long seconds = nanoInstant.longValue();
        Timestamp t2 = new Timestamp(seconds * 1000L);
        t2.setNanos(nanos);
        return t2;
    }

    public static Timestamp decimalToTimestamp(HiveDecimalWritable decWritable, HiveDecimalWritable scratchDecWritable1, HiveDecimalWritable scratchDecWritable2) {
        HiveDecimalWritable nanosWritable = scratchDecWritable1;
        nanosWritable.set(decWritable);
        nanosWritable.mutateFractionPortion();
        nanosWritable.mutateScaleByPowerOfTen(9);
        if (!nanosWritable.isSet() || !nanosWritable.isInt()) {
            return null;
        }
        int nanos = nanosWritable.intValue();
        if (nanos < 0) {
            nanos += 1000000000;
        }
        nanosWritable.setFromLong(nanos);
        HiveDecimalWritable nanoInstant = scratchDecWritable2;
        nanoInstant.set(decWritable);
        nanoInstant.mutateScaleByPowerOfTen(9);
        nanoInstant.mutateSubtract(nanosWritable);
        nanoInstant.mutateScaleByPowerOfTen(-9);
        if (!nanoInstant.isSet() || !nanoInstant.isLong()) {
            return null;
        }
        long seconds = nanoInstant.longValue();
        Timestamp timestamp = new Timestamp(seconds * 1000L);
        timestamp.setNanos(nanos);
        return timestamp;
    }

    public static Timestamp decimalToTimestamp(HiveDecimalV1 dec) {
        try {
            BigDecimal nanoInstant = dec.bigDecimalValue().multiply(BILLION_BIG_DECIMAL);
            int nanos = nanoInstant.remainder(BILLION_BIG_DECIMAL).intValue();
            if (nanos < 0) {
                nanos += 1000000000;
            }
            long seconds = nanoInstant.subtract(new BigDecimal(nanos)).divide(BILLION_BIG_DECIMAL).longValue();
            Timestamp t2 = new Timestamp(seconds * 1000L);
            t2.setNanos(nanos);
            return t2;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static long millisToSeconds(long millis) {
        if (millis >= 0L) {
            return millis / 1000L;
        }
        return (millis - 999L) / 1000L;
    }
}

