/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.common;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public class MetricsFactory {
    private static volatile Metrics metrics;

    public static synchronized void init(Configuration conf) throws Exception {
        if (metrics == null) {
            Class<?> metricsClass = conf.getClassByName(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METRICS_CLASS));
            Constructor<?> constructor = metricsClass.getConstructor(Configuration.class);
            metrics = (Metrics)constructor.newInstance(conf);
        }
    }

    public static Metrics getInstance() {
        return metrics;
    }

    public static synchronized void close() throws Exception {
        if (metrics != null) {
            metrics.close();
            metrics = null;
        }
    }
}

