/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;

public class OTELUtils {
    private static OpenTelemetry otel = null;

    public static OpenTelemetry getOpenTelemetry(Configuration conf) {
        if (otel == null || otel == OpenTelemetry.noop()) {
            String endPoint = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_OTEL_COLLECTOR_ENDPOINT);
            long otelExporterFrequency = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_OTEL_METRICS_FREQUENCY_SECONDS, TimeUnit.SECONDS);
            long timeOut = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_OTEL_EXPORTER_TIMEOUT, TimeUnit.SECONDS);
            long initialBackOff = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_OTEL_RETRY_INITIAL_BACKOFF, TimeUnit.SECONDS);
            long maxBackOff = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_OTEL_RETRY_MAX_BACKOFF, TimeUnit.SECONDS);
            double backoff = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_OTEL_RETRY_BACKOFF_MULTIPLIER);
            RetryPolicy retryPolicy = RetryPolicy.builder().setInitialBackoff(Duration.ofSeconds(initialBackOff)).setMaxAttempts(5).setMaxBackoff(Duration.ofSeconds(maxBackOff)).setBackoffMultiplier(backoff).build();
            OtlpGrpcSpanExporter otlpExporter = OtlpGrpcSpanExporter.builder().setEndpoint(endPoint).setTimeout(timeOut, TimeUnit.SECONDS).setRetryPolicy(retryPolicy).build();
            BatchSpanProcessor batchSpanProcessor = BatchSpanProcessor.builder((SpanExporter)otlpExporter).setExporterTimeout(timeOut, TimeUnit.SECONDS).build();
            OtlpGrpcMetricExporter otlpMetricExporter = OtlpGrpcMetricExporter.builder().setEndpoint(endPoint).setTimeout(timeOut, TimeUnit.SECONDS).build();
            PeriodicMetricReader metricReader = PeriodicMetricReader.builder((MetricExporter)otlpMetricExporter).setInterval(Duration.ofSeconds(otelExporterFrequency)).build();
            otel = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)batchSpanProcessor).addResource(Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"hive_otel"))).build()).setMeterProvider(SdkMeterProvider.builder().registerMetricReader((MetricReader)metricReader).addResource(Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"hive_otel"))).build()).buildAndRegisterGlobal();
        }
        return otel;
    }
}

