/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class IOStatisticsLogging {
    private static final Logger LOG = LoggerFactory.getLogger(IOStatisticsLogging.class);

    private IOStatisticsLogging() {
    }

    public static String ioStatisticsSourceToString(@Nullable Object source) {
        try {
            return IOStatisticsLogging.ioStatisticsToString(IOStatisticsSupport.retrieveIOStatistics(source));
        }
        catch (RuntimeException e) {
            LOG.debug("Ignoring", e);
            return "";
        }
    }

    public static String ioStatisticsToString(@Nullable IOStatistics statistics) {
        if (statistics != null) {
            StringBuilder sb = new StringBuilder();
            IOStatisticsLogging.mapToString(sb, "counters", statistics.counters(), " ");
            IOStatisticsLogging.mapToString(sb, "gauges", statistics.gauges(), " ");
            IOStatisticsLogging.mapToString(sb, "minimums", statistics.minimums(), " ");
            IOStatisticsLogging.mapToString(sb, "maximums", statistics.maximums(), " ");
            IOStatisticsLogging.mapToString(sb, "means", statistics.meanStatistics(), " ");
            return sb.toString();
        }
        return "";
    }

    public static String ioStatisticsToPrettyString(@Nullable IOStatistics statistics) {
        if (statistics != null) {
            StringBuilder sb = new StringBuilder();
            IOStatisticsLogging.mapToSortedString(sb, "counters", statistics.counters(), p -> p == 0L);
            IOStatisticsLogging.mapToSortedString(sb, "\ngauges", statistics.gauges(), p -> p == 0L);
            IOStatisticsLogging.mapToSortedString(sb, "\nminimums", statistics.minimums(), p -> p < 0L);
            IOStatisticsLogging.mapToSortedString(sb, "\nmaximums", statistics.maximums(), p -> p < 0L);
            IOStatisticsLogging.mapToSortedString(sb, "\nmeans", statistics.meanStatistics(), MeanStatistic::isEmpty);
            return sb.toString();
        }
        return "";
    }

    private static <E> void mapToString(StringBuilder sb, String type, Map<String, E> map, String separator) {
        int count = 0;
        sb.append(type);
        sb.append("=(");
        for (Map.Entry<String, E> entry : map.entrySet()) {
            if (count > 0) {
                sb.append(separator);
            }
            ++count;
            sb.append(IOStatisticsBinding.entryToString((String)entry.getKey(), entry.getValue()));
        }
        sb.append(");\n");
    }

    private static <E> void mapToSortedString(StringBuilder sb, String type, Map<String, E> map, Predicate<E> isEmpty) {
        IOStatisticsLogging.mapToString(sb, type, IOStatisticsLogging.sortedMap(map, isEmpty), "\n");
    }

    private static <E> Map<String, E> sortedMap(Map<String, E> source, Predicate<E> isEmpty) {
        TreeMap<String, E> tm = new TreeMap<String, E>();
        for (Map.Entry<String, E> entry : source.entrySet()) {
            if (isEmpty.test(entry.getValue())) continue;
            tm.put(entry.getKey(), entry.getValue());
        }
        return tm;
    }

    public static Object demandStringifyIOStatisticsSource(@Nullable IOStatisticsSource source) {
        return new SourceToString(source);
    }

    public static Object demandStringifyIOStatistics(@Nullable IOStatistics statistics) {
        return new StatisticsToString(statistics);
    }

    public static void logIOStatisticsAtDebug(Logger log, String message, Object source) {
        String stats;
        if (log.isDebugEnabled() && !(stats = IOStatisticsLogging.ioStatisticsSourceToString(source)).isEmpty()) {
            log.debug(message, (Object)stats);
        }
    }

    public static void logIOStatisticsAtDebug(String message, Object source) {
        IOStatisticsLogging.logIOStatisticsAtDebug(LOG, message, source);
    }

    public static void logIOStatisticsAtLevel(Logger log, String level, Object source) {
        IOStatistics stats = IOStatisticsSupport.retrieveIOStatistics(source);
        if (stats != null) {
            switch (level.toLowerCase(Locale.US)) {
                case "info": {
                    LOG.info("IOStatistics: {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString(stats));
                    break;
                }
                case "error": {
                    LOG.error("IOStatistics: {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString(stats));
                    break;
                }
                case "warn": {
                    LOG.warn("IOStatistics: {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString(stats));
                    break;
                }
                default: {
                    IOStatisticsLogging.logIOStatisticsAtDebug(log, "IOStatistics: {}", source);
                }
            }
        }
    }

    private static final class StatisticsToString {
        private final IOStatistics statistics;

        private StatisticsToString(@Nullable IOStatistics statistics) {
            this.statistics = statistics;
        }

        public String toString() {
            return this.statistics != null ? IOStatisticsLogging.ioStatisticsToString(this.statistics) : "()";
        }
    }

    private static final class SourceToString {
        private final IOStatisticsSource source;

        private SourceToString(@Nullable IOStatisticsSource source) {
            this.source = source;
        }

        public String toString() {
            return this.source != null ? IOStatisticsLogging.ioStatisticsSourceToString(this.source) : "()";
        }
    }
}

