/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveSchemaConverter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSchemaConverter.class);
    private int id;
    private final boolean autoConvert;

    private HiveSchemaConverter(boolean autoConvert) {
        this.autoConvert = autoConvert;
        this.id = 1;
    }

    static Schema convert(List<String> names, List<TypeInfo> typeInfos, List<String> comments, boolean autoConvert, Map<String, String> defaultValues) {
        HiveSchemaConverter converter = new HiveSchemaConverter(autoConvert);
        return new Schema(converter.convertInternal(names, typeInfos, defaultValues, comments));
    }

    public static Type convert(TypeInfo typeInfo, boolean autoConvert, String defaultValue) {
        HiveSchemaConverter converter = new HiveSchemaConverter(autoConvert);
        return converter.convertType(typeInfo, defaultValue);
    }

    List<Types.NestedField> convertInternal(List<String> names, List<TypeInfo> typeInfos, Map<String, String> defaultValues, List<String> comments) {
        int outerId;
        ArrayList result = Lists.newArrayListWithExpectedSize((int)names.size());
        this.id = outerId = this.id + names.size();
        for (int i = 0; i < names.size(); ++i) {
            Type type = this.convertType(typeInfos.get(i), defaultValues.get(names.get(i)));
            String columnName = names.get(i);
            Types.NestedField.Builder fieldBuilder = Types.NestedField.builder().asOptional().withId(outerId - names.size() + i).withName(columnName).ofType(type).withDoc(comments.isEmpty() || i >= comments.size() ? null : comments.get(i));
            if (defaultValues.containsKey(columnName)) {
                if (type.isPrimitiveType()) {
                    Object icebergDefaultValue = HiveSchemaUtil.getDefaultValue(defaultValues.get(columnName), type);
                    fieldBuilder.withWriteDefault(Expressions.lit((Object)icebergDefaultValue));
                } else if (!type.isStructType()) {
                    throw new UnsupportedOperationException("Default values for " + columnName + " of type " + String.valueOf(type) + " are not supported");
                }
            }
            result.add(fieldBuilder.build());
        }
        return result;
    }

    Type convertType(TypeInfo typeInfo, String defaultValue) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                    case FLOAT: {
                        return Types.FloatType.get();
                    }
                    case DOUBLE: {
                        return Types.DoubleType.get();
                    }
                    case BOOLEAN: {
                        return Types.BooleanType.get();
                    }
                    case BYTE: 
                    case SHORT: {
                        Preconditions.checkArgument((boolean)this.autoConvert, (String)"Unsupported Hive type %s, use integer instead or enable automatic type conversion, set 'iceberg.mr.schema.auto.conversion' to true", (Object)typeInfo.toString().toUpperCase());
                        LOG.debug("Using auto conversion from SHORT/BYTE to INTEGER");
                        return Types.IntegerType.get();
                    }
                    case INT: {
                        return Types.IntegerType.get();
                    }
                    case LONG: {
                        return Types.LongType.get();
                    }
                    case BINARY: {
                        return Types.BinaryType.get();
                    }
                    case CHAR: 
                    case VARCHAR: {
                        Preconditions.checkArgument((boolean)this.autoConvert, (String)"Unsupported Hive type %s, use string instead or enable automatic type conversion, set 'iceberg.mr.schema.auto.conversion' to true", (Object)((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
                        LOG.debug("Using auto conversion from CHAR/VARCHAR to STRING");
                        return Types.StringType.get();
                    }
                    case STRING: {
                        return Types.StringType.get();
                    }
                    case TIMESTAMP: {
                        return Types.TimestampType.withoutZone();
                    }
                    case DATE: {
                        return Types.DateType.get();
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                        return Types.DecimalType.of((int)decimalTypeInfo.precision(), (int)decimalTypeInfo.scale());
                    }
                }
                if ("TIMESTAMPLOCALTZ".equalsIgnoreCase(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory().name())) {
                    return Types.TimestampType.withZone();
                }
                throw new IllegalArgumentException("Unsupported Hive type (" + String.valueOf(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) + ") for Iceberg tables.");
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List<Types.NestedField> fields = this.convertInternal(structTypeInfo.getAllStructFieldNames(), structTypeInfo.getAllStructFieldTypeInfos(), HiveSchemaUtil.getDefaultValuesMap(defaultValue), Collections.emptyList());
                return Types.StructType.of(fields);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                int keyId = this.id++;
                Type keyType = this.convertType(mapTypeInfo.getMapKeyTypeInfo(), defaultValue);
                int valueId = this.id++;
                Type valueType = this.convertType(mapTypeInfo.getMapValueTypeInfo(), defaultValue);
                return Types.MapType.ofOptional((int)keyId, (int)valueId, (Type)keyType, (Type)valueType);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                int listId = this.id++;
                Type listType = this.convertType(listTypeInfo.getListElementTypeInfo(), defaultValue);
                return Types.ListType.ofOptional((int)listId, (Type)listType);
            }
            case VARIANT: {
                return Types.VariantType.get();
            }
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(typeInfo.getCategory()));
    }
}

