/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import java.util.Collections;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.ExportCommand;
import org.apache.hive.hcatalog.api.repl.commands.ImportCommand;
import org.apache.hive.hcatalog.messaging.CreateTableMessage;

public class CreateTableReplicationTask
extends ReplicationTask {
    private CreateTableMessage createTableMessage = null;

    public CreateTableReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "CREATE_TABLE");
        this.createTableMessage = messageFactory.getDeserializer().getCreateTableMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return true;
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        String dbName = this.createTableMessage.getDB();
        String tableName = this.createTableMessage.getTable();
        return Collections.singletonList(new ExportCommand(dbName, tableName, null, this.srcStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), dbName, tableName, null)), false, this.event.getEventId()));
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        String dbName = this.createTableMessage.getDB();
        String tableName = this.createTableMessage.getTable();
        return Collections.singletonList(new ImportCommand(ReplicationUtils.mapIfMapAvailable(dbName, (Function<String, String>)this.dbNameMapping), ReplicationUtils.mapIfMapAvailable(tableName, (Function<String, String>)this.tableNameMapping), null, this.dstStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), dbName, tableName, null)), false, this.event.getEventId()));
    }
}

