/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.hive.kudu.org.apache.kudu.client.Client;
import org.apache.hive.kudu.org.apache.kudu.security.Token;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Throwables;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.hive.kudu.org.apache.kudu.util.SecurityUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityContext {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityContext.class);
    private static final long REFRESH_RATE_LIMIT_SECS = 10L;
    @Nullable
    @GuardedBy(value="this")
    private Token.SignedTokenPB authnToken;
    @Nullable
    @GuardedBy(value="this")
    private Token.JwtRawPB jsonWebToken;
    @GuardedBy(value="this")
    private String realUser;
    private final DelegatedTrustManager trustManager = new DelegatedTrustManager();
    private final SSLContext sslContextWithCert;
    private final SSLContext sslContextTrustAny;
    private final Object subjectLock = new Object();
    @Nullable
    @GuardedBy(value="subjectLock")
    private Subject subject;
    @Nonnull
    private final SubjectType subjectType;
    @InterfaceAudience.LimitedPrivate(value={"Test"})
    @GuardedBy(value="this")
    List<ByteString> trustedCertDers = Collections.emptyList();
    @GuardedBy(value="subjectLock")
    private long nextAllowedRefreshNanotime = 0L;
    @GuardedBy(value="subjectLock")
    private boolean loggedRefreshFailure = false;

    SecurityContext() {
        try {
            Pair<SubjectType, Subject> p = SecurityContext.setupSubject();
            this.subjectType = p.getFirst();
            this.subject = p.getSecond();
            this.realUser = System.getProperty("user.name");
            this.sslContextWithCert = SSLContext.getInstance("TLS");
            this.sslContextWithCert.init(null, new TrustManager[]{this.trustManager}, null);
            this.sslContextTrustAny = SSLContext.getInstance("TLS");
            this.sslContextTrustAny.init(null, new TrustManager[]{new TrustAnyCert()}, null);
        }
        catch (RuntimeException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static Pair<SubjectType, Subject> setupSubject() {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject != null) {
            if (!subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
                LOG.debug("Using caller-provided subject with Kerberos principal {}. Caller is responsible for refreshing credentials.", (Object)SecurityUtil.getKerberosPrincipalOrNull(subject));
                return new Pair<SubjectType, Subject>(SubjectType.PROVIDED, subject);
            }
            LOG.debug("Caller-provided subject {} does not have any Kerberos credentials. Ignoring it.", (Object)subject.toString());
        }
        if ((subject = SecurityUtil.getSubjectFromTicketCacheOrNull()) != null) {
            return new Pair<SubjectType, Subject>(SubjectType.CREATED, subject);
        }
        return new Pair<SubjectType, Object>(SubjectType.NONE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSubject() {
        if (this.subjectType == SubjectType.NONE) {
            return;
        }
        Object object = this.subjectLock;
        synchronized (object) {
            KerberosPrincipal principal;
            Subject newSubject;
            Subject localSubject = this.subject;
            boolean needed = SecurityUtil.needsRefresh(localSubject);
            if (!needed) {
                if (this.loggedRefreshFailure) {
                    LOG.info("Credentials appear to have been refreshed externally, subject={}", (Object)this.subject);
                    this.loggedRefreshFailure = false;
                }
                return;
            }
            if (this.subjectType == SubjectType.PROVIDED) {
                if (!this.loggedRefreshFailure) {
                    LOG.warn("Caller-provided Subject has a Kerberos ticket that is about to expire. Kudu expects the application to renew or re-acquire its own tickets before expiration.");
                    this.loggedRefreshFailure = true;
                }
                return;
            }
            long now = System.nanoTime();
            if (now < this.nextAllowedRefreshNanotime) {
                return;
            }
            LOG.debug("Refreshing Kerberos credentials...");
            try {
                newSubject = Subject.doAs(new Subject(), SecurityUtil::getSubjectFromTicketCacheOrNull);
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e.getCause());
            }
            if (newSubject == null || SecurityUtil.getKerberosPrincipalOrNull(newSubject) == null) {
                LOG.warn("Tried to refresh Kerberos credentials but was unable to re-login from ticket cache");
                this.loggedRefreshFailure = true;
                this.nextAllowedRefreshNanotime = now + TimeUnit.SECONDS.toNanos(10L);
                return;
            }
            KerberosPrincipal oldPrincipal = SecurityUtil.getKerberosPrincipalOrNull(localSubject);
            if (!Objects.equals(oldPrincipal, principal = SecurityUtil.getKerberosPrincipalOrNull(newSubject))) {
                LOG.error("Attempted to refresh Kerberos credentials from ticket cache but found that the new Kerberos principal {} did not match the original principal {}. Ignoring.", (Object)principal, (Object)oldPrincipal);
                this.loggedRefreshFailure = true;
                this.nextAllowedRefreshNanotime = now + TimeUnit.SECONDS.toNanos(10L);
                return;
            }
            this.loggedRefreshFailure = false;
            this.subject = newSubject;
            LOG.info("Successfully refreshed Kerberos credentials from ticket cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Subject getSubject() {
        Object object = this.subjectLock;
        synchronized (object) {
            return this.subject;
        }
    }

    public synchronized String getRealUser() {
        return this.realUser;
    }

    @Nullable
    public synchronized byte[] exportAuthenticationCredentials() {
        Client.AuthenticationCredentialsPB.Builder pb = Client.AuthenticationCredentialsPB.newBuilder();
        pb.setRealUser(this.realUser);
        if (this.authnToken != null) {
            pb.setAuthnToken(this.authnToken);
        }
        if (this.jsonWebToken != null) {
            pb.setJwt(this.jsonWebToken);
        }
        pb.addAllCaCertDers(this.trustedCertDers);
        return pb.build().toByteArray();
    }

    private static String getUserFromToken(Token.SignedTokenPB token) throws InvalidProtocolBufferException {
        Token.TokenPB pb = Token.TokenPB.parseFrom(token.getTokenData());
        return pb.getAuthn().getUsername();
    }

    private static void checkUserMatches(Token.SignedTokenPB oldToken, Token.SignedTokenPB newToken) throws InvalidProtocolBufferException {
        String newUser;
        String oldUser = SecurityContext.getUserFromToken(oldToken);
        if (!oldUser.equals(newUser = SecurityContext.getUserFromToken(newToken))) {
            throw new IllegalArgumentException(String.format("cannot import authentication data from a different user: old='%s', new='%s'", oldUser, newUser));
        }
    }

    public synchronized void importAuthenticationCredentials(byte[] authnData) {
        try {
            Client.AuthenticationCredentialsPB pb = Client.AuthenticationCredentialsPB.parseFrom(authnData);
            if (pb.hasAuthnToken() && this.authnToken != null) {
                SecurityContext.checkUserMatches(this.authnToken, pb.getAuthnToken());
            }
            LOG.debug("Importing authentication credentials with {} authn token, with {} JWT, {} cert(s), and realUser={}", new Object[]{pb.hasAuthnToken() ? "one" : "no", pb.hasJwt() ? "one" : "no", pb.getCaCertDersCount(), pb.hasRealUser() ? pb.getRealUser() : "<none>"});
            if (pb.hasAuthnToken()) {
                this.authnToken = pb.getAuthnToken();
            }
            if (!pb.hasJwt()) {
                this.trustCertificates(pb.getCaCertDersList());
            }
            if (pb.hasJwt() && (this.jsonWebToken == null || !this.jsonWebToken.hasJwtData() || this.jsonWebToken.hasJwtData() && this.jsonWebToken.getJwtData().isEmpty())) {
                this.jsonWebToken = pb.getJwt();
            }
            if (pb.hasRealUser()) {
                this.realUser = pb.getRealUser();
            }
        }
        catch (CertificateException | InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public synchronized Token.SignedTokenPB getAuthenticationToken() {
        return this.authnToken;
    }

    @Nullable
    public synchronized Token.JwtRawPB getJsonWebToken() {
        return this.jsonWebToken;
    }

    public synchronized void setAuthenticationToken(Token.SignedTokenPB token) {
        this.authnToken = token;
    }

    public synchronized void setJsonWebToken(Token.JwtRawPB jwt) {
        this.jsonWebToken = jwt;
    }

    public SSLEngine createSSLEngineTrustAll() {
        return this.sslContextTrustAny.createSSLEngine();
    }

    public SSLEngine createSSLEngine() {
        return this.sslContextWithCert.createSSLEngine();
    }

    public synchronized boolean hasTrustedCerts() {
        return !this.trustedCertDers.isEmpty();
    }

    private static X509TrustManager createTrustManagerForCerts(Iterable<ByteString> certDers) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certs = Lists.newArrayList();
        for (ByteString certDer : certDers) {
            certs.add((X509Certificate)certFactory.generateCertificate(certDer.newInput()));
        }
        try {
            KeyStore certKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            certKeyStore.load(null);
            int i = 0;
            for (X509Certificate cert : certs) {
                certKeyStore.setCertificateEntry(String.format("cert-%d", i++), cert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(certKeyStore);
            TrustManager[] managers = tmf.getTrustManagers();
            if (managers.length != 1) {
                throw new RuntimeException("TrustManagerFactory generated multiple TrustManagers");
            }
            return (X509TrustManager)managers[0];
        }
        catch (IOException | RuntimeException | GeneralSecurityException e) {
            Throwables.throwIfInstanceOf(e, CertificateException.class);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trustCertificates(List<ByteString> certDers) throws CertificateException {
        X509TrustManager tm = SecurityContext.createTrustManagerForCerts(certDers);
        SecurityContext securityContext = this;
        synchronized (securityContext) {
            this.trustManager.delegate.set(tm);
            this.trustedCertDers = ImmutableList.copyOf(certDers);
        }
    }

    private static class DelegatedTrustManager
    implements X509TrustManager {
        final AtomicReference<X509TrustManager> delegate = new AtomicReference();

        private DelegatedTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.get().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.get().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.get().getAcceptedIssuers();
        }
    }

    private static class TrustAnyCert
    implements X509TrustManager {
        private TrustAnyCert() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static enum SubjectType {
        CREATED,
        PROVIDED,
        NONE;

    }
}

