/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.GetTransactionStateResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.transactions.TxnManager;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class GetTransactionStateRequest
extends KuduRpc<GetTransactionStateResponse> {
    private static final List<Integer> featureFlags = ImmutableList.of();
    final long txnId;

    GetTransactionStateRequest(KuduTable masterTable, Timer timer, long timeoutMillis, long txnId) {
        super(masterTable, timer, timeoutMillis);
        Preconditions.checkArgument(txnId > -1L);
        this.txnId = txnId;
    }

    @Override
    Message createRequestPB() {
        TxnManager.GetTransactionStateRequestPB.Builder b = TxnManager.GetTransactionStateRequestPB.newBuilder();
        b.setTxnId(this.txnId);
        return b.build();
    }

    @Override
    String serviceName() {
        return "kudu.transactions.TxnManagerService";
    }

    @Override
    String method() {
        return "GetTransactionState";
    }

    @Override
    Pair<GetTransactionStateResponse, Object> deserialize(CallResponse callResponse, String serverUUID) throws KuduException {
        TxnManager.GetTransactionStateResponsePB.Builder b = TxnManager.GetTransactionStateResponsePB.newBuilder();
        GetTransactionStateRequest.readProtobuf(callResponse.getPBMessage(), b);
        if (!b.hasError()) {
            Preconditions.checkState(b.hasState());
        }
        OptionalLong ts = b.hasCommitTimestamp() ? OptionalLong.of(b.getCommitTimestamp()) : OptionalLong.empty();
        GetTransactionStateResponse response = new GetTransactionStateResponse(this.timeoutTracker.getElapsedMillis(), serverUUID, b.getState(), ts);
        return new Pair<GetTransactionStateResponse, Object>(response, b.hasError() ? b.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return featureFlags;
    }
}

