/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.Collection;
import java.util.Collections;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ConnectToMasterRequest
extends KuduRpc<Master.ConnectToMasterResponsePB> {
    private static final String GET_MASTER_REGISTRATION = "GetMasterRegistration";
    private static final String CONNECT_TO_MASTER = "ConnectToMaster";
    private String method = "ConnectToMaster";

    public ConnectToMasterRequest(KuduTable masterTable, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
    }

    @Override
    Message createRequestPB() {
        return Master.GetMasterRegistrationRequestPB.getDefaultInstance();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return this.method;
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        if (CONNECT_TO_MASTER.equals(this.method)) {
            return Collections.singleton(Master.MasterFeatures.CONNECT_TO_MASTER.getNumber());
        }
        return Collections.emptySet();
    }

    @Override
    Pair<Master.ConnectToMasterResponsePB, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        if (CONNECT_TO_MASTER.equals(this.method)) {
            return this.deserializeNewRpc(callResponse);
        }
        return this.deserializeOldRpc(callResponse);
    }

    private Pair<Master.ConnectToMasterResponsePB, Object> deserializeNewRpc(CallResponse callResponse) {
        Master.ConnectToMasterResponsePB.Builder respBuilder = Master.ConnectToMasterResponsePB.newBuilder();
        ConnectToMasterRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        return new Pair<Master.ConnectToMasterResponsePB, Object>(respBuilder.build(), respBuilder.hasError() ? respBuilder.getError() : null);
    }

    private Pair<Master.ConnectToMasterResponsePB, Object> deserializeOldRpc(CallResponse callResponse) {
        Master.GetMasterRegistrationResponsePB.Builder resp = Master.GetMasterRegistrationResponsePB.newBuilder();
        ConnectToMasterRequest.readProtobuf(callResponse.getPBMessage(), resp);
        Master.ConnectToMasterResponsePB.Builder b = Master.ConnectToMasterResponsePB.newBuilder();
        if (resp.hasRole()) {
            b.setRole(resp.getRole());
        }
        if (resp.hasError()) {
            b.setError(resp.getError());
        }
        return new Pair<Master.ConnectToMasterResponsePB, Object>(b.build(), b.hasError() ? b.getError() : null);
    }

    public void setUseOldMethod() {
        this.method = GET_MASTER_REGISTRATION;
    }
}

