/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.DefaultFileAccess;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.WebHCatJTShim23;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.SuppressFBWarnings;
import org.apache.tez.test.MiniTezCluster;

public class Hadoop23Shims
extends HadoopShimsSecure {
    HadoopShims.MiniDFSShim cluster = null;
    final boolean storagePolicy;
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;
    protected static final Method accessMethod;
    protected static final Method getPasswordMethod;
    private static Boolean hdfsEncryptionSupport;
    private static final Method getSubjectMethod;
    private static final Constructor<UserGroupInformation> ugiCtor;
    private static final String ugiCloneError;
    private static Boolean hdfsErasureCodingSupport;

    public Hadoop23Shims() {
        boolean storage = false;
        try {
            Class.forName("org.apache.hadoop.hdfs.protocol.BlockStoragePolicy", false, ShimLoader.class.getClassLoader());
            storage = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.storagePolicy = storage;
    }

    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new HadoopShimsSecure.CombineFileInputFormatShim(this){

            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }

            protected List<FileStatus> listStatus(org.apache.hadoop.mapreduce.JobContext job) throws IOException {
                List result = super.listStatus(job);
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    FileStatus stat = (FileStatus)it.next();
                    if (stat.isFile() && (stat.getLen() != 0L || stat.getPath().toUri().getScheme().equals("nullscan"))) continue;
                    it.remove();
                }
                return result;
            }
        };
    }

    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (conf.get("mapreduce.framework.name") != null && conf.get("mapreduce.framework.name").equals("yarn")) {
            LOG.warn("Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        LOG.warn("Can't fetch tasklog: TaskLogServlet is not supported in MR1 mode.");
        return null;
    }

    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + String.valueOf(clusterStatus.getJobTrackerStatus());
        throw new Exception(errorMsg);
    }

    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        TaskAttemptID taskAttemptId = TaskAttemptID.forName((String)conf.get("mapreduce.task.attempt.id"));
        if (taskAttemptId == null) {
            taskAttemptId = new TaskAttemptID();
        }
        return new TaskAttemptContextImpl(this, conf, taskAttemptId){

            public void progress() {
                progressable.progress();
            }
        };
    }

    public TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskId, id);
    }

    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    public boolean isLocalMode(Configuration conf) {
        return "local".equals(conf.get("mapreduce.framework.name"));
    }

    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.address");
    }

    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            conf.set("mapreduce.framework.name", val);
            conf.set("mapreduce.jobtracker.address", val);
        } else {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        }
    }

    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.webapp.address");
    }

    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        TotalOrderPartitioner.setPartitionFile((JobConf)jobConf, (Path)partitionFile);
    }

    public Comparator<LongWritable> getLongComparator() {
        return new Comparator<LongWritable>(this){

            @Override
            public int compare(LongWritable o1, LongWritable o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public void refreshDefaultQueue(Configuration conf, String userName) throws IOException {
    }

    private boolean isFairScheduler(Configuration conf) {
        return "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler".equalsIgnoreCase(conf.get("yarn.resourcemanager.scheduler.class"));
    }

    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public HadoopShims.MiniMrShim getLocalMiniTezCluster(Configuration conf, boolean usingLlap) {
        return new MiniTezLocalShim(conf, usingLlap);
    }

    public MiniMrShim getMiniTezCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, boolean usingLlap) throws IOException {
        return new MiniTezShim(conf, numberOfTaskTrackers, nameNode, usingLlap);
    }

    private void configureImpersonation(Configuration conf) {
        String user;
        try {
            user = Utils.getUGI().getShortUserName();
        }
        catch (Exception e) {
            String msg = "Cannot obtain username: " + String.valueOf(e);
            throw new IllegalStateException(msg, e);
        }
        conf.set("hadoop.proxyuser." + user + ".groups", "*");
        conf.set("hadoop.proxyuser." + user + ".hosts", "*");
    }

    public void setHadoopCallerContext(String callerContext) {
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder(callerContext).build());
    }

    public void setHadoopQueryContext(String queryId) {
        this.setHadoopCallerContext("hive_queryId_" + queryId);
    }

    public void setHadoopSessionContext(String sessionId) {
        this.setHadoopCallerContext("hive_sessionId_" + sessionId);
    }

    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return this.getMiniDfs(conf, numDataNodes, format, racks, false);
    }

    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks, boolean isHA) throws IOException {
        MiniDFSCluster miniDFSCluster;
        this.configureImpersonation(conf);
        if (isHA) {
            MiniDFSNNTopology topo = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("minidfs").addNN(new MiniDFSNNTopology.NNConf("nn1")).addNN(new MiniDFSNNTopology.NNConf("nn2")));
            miniDFSCluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).format(format).racks(racks).nnTopology(topo).build();
            miniDFSCluster.waitActive();
            miniDFSCluster.transitionToActive(0);
        } else {
            miniDFSCluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).format(format).racks(racks).build();
        }
        KeyProviderCryptoExtension keyProvider = miniDFSCluster.getNameNode(0).getNamesystem().getProvider();
        if (keyProvider != null) {
            try {
                Hadoop23Shims.setKeyProvider(miniDFSCluster.getFileSystem(0).getClient(), keyProvider);
            }
            catch (Exception err) {
                throw new IOException(err);
            }
        }
        this.cluster = new MiniDFSShim(miniDFSCluster);
        return this.cluster;
    }

    private static void setKeyProvider(DFSClient dfsClient, KeyProviderCryptoExtension provider) throws Exception {
        Method setKeyProviderHadoop27Method = null;
        try {
            setKeyProviderHadoop27Method = DFSClient.class.getMethod("setKeyProvider", KeyProvider.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (setKeyProviderHadoop27Method != null) {
            setKeyProviderHadoop27Method.invoke((Object)dfsClient, provider);
        } else {
            dfsClient.setKeyProvider((KeyProvider)provider);
        }
    }

    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims23();
        }
        return this.hcatShimInstance;
    }

    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return WebHCatJTShim23.createInstance(conf, ugi);
    }

    public List<HadoopShims.HdfsFileStatusWithId> listLocatedHdfsStatus(FileSystem fs, Path p, PathFilter filter) throws IOException {
        String src;
        DistributedFileSystem dfs = this.ensureDfs(fs);
        DFSClient dfsc = dfs.getClient();
        DirectoryListing current = dfsc.listPaths(src = p.toUri().getPath(), HdfsFileStatus.EMPTY_NAME, true);
        if (current == null) {
            throw new FileNotFoundException("File " + String.valueOf(p) + " does not exist.");
        }
        URI fsUri = fs.getUri();
        ArrayList<HadoopShims.HdfsFileStatusWithId> result = new ArrayList<HadoopShims.HdfsFileStatusWithId>(current.getPartialListing().length);
        while (current != null) {
            HdfsFileStatus[] hfss = current.getPartialListing();
            for (int i = 0; i < hfss.length; ++i) {
                Path filterPath;
                HdfsLocatedFileStatus next = (HdfsLocatedFileStatus)hfss[i];
                if (filter != null && !filter.accept(filterPath = next.getFullPath(p).makeQualified(fsUri, null))) continue;
                LocatedFileStatus lfs = next.makeQualifiedLocated(fsUri, p);
                result.add(new HdfsFileStatusWithIdImpl(lfs, next.getFileId()));
            }
            current = current.hasMore() ? dfsc.listPaths(src, current.getLastName(), true) : null;
        }
        return result;
    }

    private DistributedFileSystem ensureDfs(FileSystem fs) {
        if (!(fs instanceof DistributedFileSystem)) {
            throw new UnsupportedOperationException("Only supported for DFS; got " + String.valueOf(fs.getClass()));
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        return dfs;
    }

    public BlockLocation[] getLocations(FileSystem fs, FileStatus status) throws IOException {
        if (status instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)status).getBlockLocations();
        }
        return fs.getFileBlockLocations(status, 0L, status.getLen());
    }

    public TreeMap<Long, BlockLocation> getLocationsWithOffset(FileSystem fs, FileStatus status) throws IOException {
        BlockLocation[] locations;
        TreeMap<Long, BlockLocation> offsetBlockMap = new TreeMap<Long, BlockLocation>();
        for (BlockLocation location : locations = this.getLocations(fs, status)) {
            offsetBlockMap.put(location.getOffset(), location);
        }
        return offsetBlockMap;
    }

    public void hflush(FSDataOutputStream stream) throws IOException {
        stream.hflush();
    }

    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem23(fs, uri);
    }

    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext context) {
        return context.getConfiguration();
    }

    public JobConf getJobConf(JobContext context) {
        return context.getJobConf();
    }

    public FileSystem getNonCachedFileSystem(URI uri, Configuration conf) throws IOException {
        return FileSystem.newInstance((URI)uri, (Configuration)conf);
    }

    public void getMergedCredentials(JobConf jobConf) throws IOException {
        jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
    }

    public void mergeCredentials(JobConf dest, JobConf src) throws IOException {
        dest.getCredentials().mergeAll(src.getCredentials());
    }

    public void checkFileAccess(FileSystem fs, FileStatus stat, FsAction action) throws IOException, AccessControlException, Exception {
        try {
            if (accessMethod == null) {
                DefaultFileAccess.checkFileAccess((FileSystem)fs, (FileStatus)stat, (FsAction)action);
            } else {
                accessMethod.invoke((Object)fs, stat.getPath(), action);
            }
        }
        catch (Exception err) {
            throw Hadoop23Shims.wrapAccessException(err);
        }
    }

    private static Exception wrapAccessException(Exception err) {
        int maxDepth = 20;
        Throwable curErr = err;
        for (int idx = 0; curErr != null && idx < 20; curErr = curErr.getCause(), ++idx) {
            if (!(curErr instanceof org.apache.hadoop.security.AccessControlException) && !curErr.getClass().getName().equals("org.apache.hadoop.fs.permission.AccessControlException")) continue;
            AccessControlException newErr = new AccessControlException(curErr.getMessage());
            newErr.initCause(err);
            return newErr;
        }
        return err;
    }

    public String getPassword(Configuration conf, String name) throws IOException {
        if (getPasswordMethod == null) {
            return conf.get(name);
        }
        try {
            char[] pw = (char[])getPasswordMethod.invoke((Object)conf, name);
            if (pw == null) {
                return null;
            }
            return new String(pw);
        }
        catch (Exception err) {
            throw new IOException(err.getMessage(), err);
        }
    }

    public boolean supportStickyBit() {
        return true;
    }

    public boolean hasStickyBit(FsPermission permission) {
        return permission.getStickyBit();
    }

    public boolean supportTrashFeature() {
        return true;
    }

    public Path getCurrentTrashPath(Configuration conf, FileSystem fs) {
        TrashPolicy tp = TrashPolicy.getInstance((Configuration)conf, (FileSystem)fs, (Path)fs.getHomeDirectory());
        return tp.getCurrentTrashDir();
    }

    public KerberosNameShim getKerberosNameShim(String name) throws IOException {
        return new KerberosNameShim(name);
    }

    public boolean isDirectory(FileStatus fileStatus) {
        return fileStatus.isDirectory();
    }

    public HadoopShims.StoragePolicyShim getStoragePolicyShim(FileSystem fs) {
        if (!this.storagePolicy) {
            return null;
        }
        try {
            return new StoragePolicyShim((DistributedFileSystem)fs);
        }
        catch (ClassCastException ce) {
            return null;
        }
    }

    List<String> constructDistCpParams(List<Path> srcPaths, Path dst, Configuration conf) throws IOException {
        List<String> params = this.constructDistCpDefaultParams(conf, dst.getFileSystem(conf), srcPaths.get(0).getFileSystem(conf), srcPaths);
        if (!params.contains("-delete")) {
            params.add("-delete");
        }
        for (Path src : srcPaths) {
            params.add(src.toString());
        }
        params.add(dst.toString());
        return params;
    }

    private List<String> constructDistCpDefaultParams(Configuration conf, FileSystem dstFs, FileSystem sourceFs, List<Path> srcPaths) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        boolean needToAddPreserveOption = true;
        for (Map.Entry entry : conf.getPropsWithPrefix("distcp.options.").entrySet()) {
            String distCpOption = (String)entry.getKey();
            String distCpVal = (String)entry.getValue();
            if (distCpOption.startsWith("p")) {
                needToAddPreserveOption = false;
            }
            params.add("-" + distCpOption);
            if (distCpVal == null || distCpVal.isEmpty()) continue;
            params.add(distCpVal);
        }
        if (needToAddPreserveOption) {
            if (conf.getBoolean("dfs.xattr.supported.only.on.reserved.namespace", false)) {
                boolean shouldCopyXAttrs = srcPaths.get(0).toUri().getPath().startsWith("/.reserved/raw/") && Utils.checkFileSystemXAttrSupport((FileSystem)sourceFs, (Path)new Path("/.reserved/raw/")) && Utils.checkFileSystemXAttrSupport((FileSystem)dstFs, (Path)new Path("/.reserved/raw/"));
                params.add(shouldCopyXAttrs ? "-pbx" : "-pb");
            } else {
                params.add(Utils.checkFileSystemXAttrSupport((FileSystem)dstFs) && Utils.checkFileSystemXAttrSupport((FileSystem)sourceFs) ? "-pbx" : "-pb");
            }
        }
        if (!params.contains("-update")) {
            params.add("-update");
        }
        return params;
    }

    List<String> constructDistCpWithSnapshotParams(List<Path> srcPaths, Path dst, String sourceSnap, String destSnap, Configuration conf, String diff) throws IOException {
        List<String> params = this.constructDistCpDefaultParams(conf, dst.getFileSystem(conf), srcPaths.get(0).getFileSystem(conf), srcPaths);
        if (params.contains("-delete")) {
            params.remove("-delete");
        }
        params.add(diff);
        params.add(sourceSnap);
        params.add(destSnap);
        for (Path src : srcPaths) {
            params.add(src.toString());
        }
        params.add(dst.toString());
        return params;
    }

    public boolean runDistCpAs(final List<Path> srcPaths, final Path dst, final Configuration conf, UserGroupInformation proxyUser) throws IOException {
        try {
            return (Boolean)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return Hadoop23Shims.this.runDistCp(srcPaths, dst, conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public boolean runDistCp(List<Path> srcPaths, Path dst, Configuration conf) throws IOException {
        List<String> params = this.constructDistCpParams(srcPaths, dst, conf);
        DistCp distcp = null;
        try {
            distcp = new DistCp(conf, null);
            distcp.getConf().setBoolean("mapred.mapper.new-api", true);
            boolean bl = this.runDistCpInternal(distcp, params) == 0;
            return bl;
        }
        catch (Exception e) {
            throw new IOException("Cannot execute DistCp process: ", e);
        }
        finally {
            String jobId;
            if (distcp != null && (jobId = distcp.getConf().get("distcp.job.id")) != null) {
                conf.set("distcp.job.id", jobId);
            }
        }
    }

    public boolean runDistCpWithSnapshots(String oldSnapshot, String newSnapshot, List<Path> srcPaths, Path dst, boolean overwriteTarget, Configuration conf) throws IOException {
        List<String> params = this.constructDistCpWithSnapshotParams(srcPaths, dst, oldSnapshot, newSnapshot, conf, "-diff");
        try {
            DistCp distcp = new DistCp(conf, null);
            distcp.getConf().setBoolean("mapred.mapper.new-api", true);
            int returnCode = this.runDistCpInternal(distcp, params);
            if (returnCode == 0) {
                return true;
            }
            if (returnCode == -1) {
                LOG.warn("Copy failed with INVALID_ARGUMENT for source: {} to target: {} snapshot1: {} snapshot2: {} params: {}", new Object[]{srcPaths, dst, oldSnapshot, newSnapshot, params});
                return true;
            }
            if (returnCode == -999 && overwriteTarget && Hadoop23Shims.shouldRdiff(dst, conf, oldSnapshot, overwriteTarget)) {
                LOG.warn("Copy failed due to target modified. Attempting to restore back the target. source: {} target: {} snapshot: {}", new Object[]{srcPaths, dst, oldSnapshot});
                List<String> rParams = this.constructDistCpWithSnapshotParams(srcPaths, dst, ".", oldSnapshot, conf, "-rdiff");
                DistCp rDistcp = new DistCp(conf, null);
                returnCode = this.runDistCpInternal(rDistcp, rParams);
                if (returnCode == 0) {
                    LOG.info("Target restored to previous state.  source: {} target: {} snapshot: {}. Reattempting to copy.", new Object[]{srcPaths, dst, oldSnapshot});
                    dst.getFileSystem(conf).deleteSnapshot(dst, oldSnapshot);
                    dst.getFileSystem(conf).createSnapshot(dst, oldSnapshot);
                    returnCode = this.runDistCpInternal(distcp, params);
                    if (returnCode == 0) {
                        return true;
                    }
                    LOG.error("Copy failed with after target restore for source: {} to target: {} snapshot1: {} snapshot2: {} params: {}. Return code: {}", new Object[]{srcPaths, dst, oldSnapshot, newSnapshot, params, returnCode});
                    return false;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Cannot execute DistCp process: ", e);
        }
        return false;
    }

    protected int runDistCpInternal(DistCp distcp, List<String> params) {
        this.ensureMapReduceQueue(distcp.getConf());
        return distcp.run(params.toArray(new String[0]));
    }

    protected void ensureMapReduceQueue(Configuration conf) {
        String queueName = conf.get("tez.queue.name");
        boolean isTez = "tez".equalsIgnoreCase(conf.get("hive.execution.engine"));
        boolean shouldMapredJobsFollowTezQueue = conf.getBoolean("hive.mapred.job.follow.tez.queue", false);
        LOG.debug("Checking tez.queue.name {}, isTez: {}, shouldMapredJobsFollowTezQueue: {}", new Object[]{queueName, isTez, shouldMapredJobsFollowTezQueue});
        if (isTez && shouldMapredJobsFollowTezQueue && queueName != null && queueName.length() > 0) {
            LOG.info("Setting mapreduce.job.queuename (current: '{}') to become tez.queue.name: '{}'", (Object)conf.get("mapreduce.job.queuename"), (Object)queueName);
            conf.set("mapreduce.job.queuename", queueName);
        }
    }

    private static boolean shouldRdiff(Path p, Configuration conf, String snapshot, boolean overwriteTarget) throws Exception {
        boolean targetModified = false;
        try {
            DistributedFileSystem dfs = (DistributedFileSystem)p.getFileSystem(conf);
            SnapshotDiffReportListing snapshotDiff = dfs.getClient().getSnapshotDiffReportListing(p.toUri().getPath(), snapshot, "", DFSUtilClient.EMPTY_BYTES, -1);
            if (snapshotDiff.getCreateList() != null && !snapshotDiff.getCreateList().isEmpty()) {
                targetModified = true;
            }
            if (snapshotDiff.getModifyList() != null && !snapshotDiff.getModifyList().isEmpty()) {
                targetModified = true;
            }
            if (snapshotDiff.getDeleteList() != null && !snapshotDiff.getDeleteList().isEmpty()) {
                targetModified = true;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to compute snapshot diff for path: {} and snapshot: {}", (Object)p, (Object)snapshot);
        }
        if (targetModified && !overwriteTarget) {
            throw new Exception("The target modified during snapshot based data copy for path: " + String.valueOf(p) + " and snapshot: " + snapshot);
        }
        return targetModified;
    }

    public boolean runDistCpWithSnapshotsAs(final String oldSnapshot, final String newSnapshot, final List<Path> srcPaths, final Path dst, final boolean overwriteTarget, UserGroupInformation proxyUser, final Configuration conf) throws IOException {
        try {
            return (Boolean)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return Hadoop23Shims.this.runDistCpWithSnapshots(oldSnapshot, newSnapshot, srcPaths, dst, overwriteTarget, conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="All threads set the same value despite data race")
    public static boolean isHdfsEncryptionSupported() {
        if (hdfsEncryptionSupport == null) {
            Method m = null;
            try {
                m = HdfsAdmin.class.getMethod("getEncryptionZoneForPath", Path.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            hdfsEncryptionSupport = m != null;
        }
        return hdfsEncryptionSupport;
    }

    public HadoopShims.HdfsEncryptionShim createHdfsEncryptionShim(FileSystem fs, Configuration conf) throws IOException {
        URI uri;
        if (Hadoop23Shims.isHdfsEncryptionSupported() && "hdfs".equals((uri = fs.getUri()).getScheme()) && fs instanceof DistributedFileSystem) {
            return HdfsEncryptionShim.createInstance(uri, conf);
        }
        return new HadoopShims.NoopHdfsEncryptionShim();
    }

    public Path getPathWithoutSchemeAndAuthority(Path path) {
        return Path.getPathWithoutSchemeAndAuthority((Path)path);
    }

    public int readByteBuffer(FSDataInputStream file, ByteBuffer dest) throws IOException {
        int pos = dest.position();
        int result = file.read(dest);
        if (result > 0) {
            dest.position(pos + result);
        }
        return result;
    }

    public void addDelegationTokens(FileSystem fs, Credentials cred, String uname) throws IOException {
        fs.addDelegationTokens(uname, cred);
    }

    public long getFileId(FileSystem fs, String path) throws IOException {
        HdfsFileStatus fileInfo = this.ensureDfs(fs).getClient().getFileInfo(path);
        if (fileInfo == null) {
            throw new FileNotFoundException(path + " does not exist.");
        }
        return fileInfo.getFileId();
    }

    public UserGroupInformation cloneUgi(UserGroupInformation baseUgi) throws IOException {
        if (getSubjectMethod == null) {
            throw new IOException("The UGI method was not found: " + ugiCloneError);
        }
        try {
            Subject origSubject = (Subject)getSubjectMethod.invoke((Object)baseUgi, new Object[0]);
            Subject subject = new Subject(false, origSubject.getPrincipals(), Hadoop23Shims.cloneCredentials(origSubject.getPublicCredentials()), Hadoop23Shims.cloneCredentials(origSubject.getPrivateCredentials()));
            return ugiCtor.newInstance(subject);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    private static Set<Object> cloneCredentials(Set<Object> old) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : old) {
            set.add(o instanceof Credentials ? new Credentials((Credentials)o) : o);
        }
        return set;
    }

    private static synchronized boolean isHdfsErasureCodingSupported() {
        if (hdfsErasureCodingSupport == null) {
            Method m = null;
            try {
                m = HdfsAdmin.class.getMethod("getErasureCodingPolicies", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            hdfsErasureCodingSupport = m != null;
        }
        return hdfsErasureCodingSupport;
    }

    public HadoopShims.HdfsErasureCodingShim createHdfsErasureCodingShim(FileSystem fs, Configuration conf) throws IOException {
        URI uri;
        if (Hadoop23Shims.isHdfsErasureCodingSupported() && "hdfs".equals((uri = fs.getUri()).getScheme())) {
            return new HdfsErasureCodingShim(uri, conf);
        }
        return new HadoopShims.NoopHdfsErasureCodingShim();
    }

    static {
        Constructor ctor;
        Method m = null;
        try {
            m = FileSystem.class.getMethod("access", Path.class, FsAction.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        accessMethod = m;
        try {
            m = Configuration.class.getMethod("getPassword", String.class);
        }
        catch (NoSuchMethodException err) {
            m = null;
        }
        getPasswordMethod = m;
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        Method method = null;
        String error = null;
        try {
            method = clazz.getDeclaredMethod("getSubject", new Class[0]);
            method.setAccessible(true);
            ctor = clazz.getDeclaredConstructor(Subject.class);
            ctor.setAccessible(true);
        }
        catch (Throwable t) {
            error = t.getMessage();
            method = null;
            ctor = null;
            LOG.error("Cannot create UGI reflection methods", t);
        }
        getSubjectMethod = method;
        ugiCtor = ctor;
        ugiCloneError = error;
    }

    public static class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim() {
            this.mr = null;
            this.conf = null;
        }

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = new Configuration(conf);
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            jConf.setInt("mapreduce.map.memory.mb", 512);
            jConf.setInt("mapreduce.reduce.memory.mb", 512);
            jConf.setInt("yarn.app.mapreduce.am.resource.mb", 128);
            jConf.setInt("yarn.minicluster.yarn.nodemanager.resource.memory-mb", 512);
            jConf.setInt("yarn.scheduler.minimum-allocation-mb", 128);
            jConf.setInt("yarn.scheduler.maximum-allocation-mb", 512);
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((CharSequence)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
            conf.setInt("mapreduce.map.memory.mb", 512);
            conf.setInt("mapreduce.reduce.memory.mb", 512);
            conf.setInt("yarn.app.mapreduce.am.resource.mb", 128);
        }
    }

    public static class MiniTezLocalShim
    extends MiniMrShim {
        private final Configuration conf;
        private final boolean isLlap;

        public MiniTezLocalShim(Configuration conf, boolean usingLlap) {
            this.conf = new Configuration(conf);
            this.isLlap = usingLlap;
            this.setupConfiguration(conf);
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("No JobTracker port for local mode");
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            conf.setBoolean("tez.local.mode", true);
            conf.setBoolean("tez.local.mode.without.network", true);
            conf.setBoolean("tez.runtime.optimize.local.fetch", true);
            conf.setBoolean("tez.ignore.lib.uris", true);
            if (!this.isLlap) {
                conf.setBoolean("hive.llap.io.enabled", false);
            } else {
                conf.set("hive.llap.execution.mode", "only");
            }
        }

        @Override
        public void shutdown() throws IOException {
        }
    }

    public static class MiniTezShim
    extends MiniMrShim {
        private final MiniTezCluster mr;
        private final Configuration conf;
        private final boolean isLlap;

        public MiniTezShim(Configuration conf, int numberOfTaskTrackers, String nameNode, boolean usingLlap) throws IOException {
            this.mr = new MiniTezCluster("hive", numberOfTaskTrackers);
            conf.setInt("yarn.minicluster.yarn.nodemanager.resource.memory-mb", 4096);
            conf.setInt("yarn.scheduler.minimum-allocation-mb", 128);
            conf.setInt("yarn.scheduler.maximum-allocation-mb", 4096);
            conf.set("fs.defaultFS", nameNode);
            conf.set("tez.am.log.level", "DEBUG");
            conf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            this.mr.init(conf);
            this.mr.start();
            this.conf = this.mr.getConfig();
            this.isLlap = usingLlap;
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((CharSequence)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.stop();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Configuration config = this.mr.getConfig();
            for (Map.Entry pair : config) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
            if (this.isLlap) {
                conf.set("hive.llap.execution.mode", "all");
            }
        }
    }

    public static class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="intended")
        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem(0);
        }

        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    private static final class HCatHadoopShims23
    implements HadoopShims.HCatHadoopShims {
        private HCatHadoopShims23() {
        }

        public TaskID createTaskID() {
            return new TaskID("", 0, TaskType.MAP, 0);
        }

        public TaskAttemptID createTaskAttemptID() {
            return new TaskAttemptID("", 0, TaskType.MAP, 0, 0);
        }

        public TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
            return new TaskAttemptContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), taskId);
        }

        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, org.apache.hadoop.mapred.TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContextImpl.class.getDeclaredConstructor(JobConf.class, org.apache.hadoop.mapred.TaskAttemptID.class, Reporter.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(new JobConf((Configuration)conf), taskId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new JobContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), jobId);
        }

        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            return new org.apache.hadoop.mapred.JobContextImpl(new JobConf((Configuration)conf), jobId, progressable);
        }

        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            String addr = conf.get("yarn.resourcemanager.address", "localhost:8032");
            return NetUtils.createSocketAddr((String)addr);
        }

        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapreduce.job.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapreduce.job.cache.files";
                }
                case CACHE_SYMLINK: {
                    return "mapreduce.job.cache.symlink.create";
                }
                case CLASSPATH_ARCHIVES: {
                    return "mapreduce.job.classpath.archives";
                }
                case CLASSPATH_FILES: {
                    return "mapreduce.job.classpath.files";
                }
            }
            return "";
        }

        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.resolvePath(path).toUri().getScheme());
        }
    }

    private static final class HdfsFileStatusWithIdImpl
    implements HadoopShims.HdfsFileStatusWithId {
        private final LocatedFileStatus lfs;
        private final long fileId;

        public HdfsFileStatusWithIdImpl(LocatedFileStatus lfs, long fileId) {
            this.lfs = lfs;
            this.fileId = fileId;
        }

        public FileStatus getFileStatus() {
            return this.lfs;
        }

        public Long getFileId() {
            if (this.fileId == 0L) {
                return null;
            }
            return this.fileId;
        }
    }

    static class ProxyFileSystem23
    extends ProxyFileSystem {
        public ProxyFileSystem23(FileSystem fs, URI uri) {
            super(fs, uri);
        }

        public FutureDataInputStreamBuilder openFile(Path path) throws IOException, UnsupportedOperationException {
            return super.openFile(ProxyFileSystem23.super.swizzleParamPath(path));
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
            final RemoteIterator remoteIterator = ProxyFileSystem23.super.listLocatedStatus(ProxyFileSystem23.super.swizzleParamPath(f));
            return new RemoteIterator<LocatedFileStatus>(){
                private final RemoteIterator<LocatedFileStatus> stats;
                {
                    this.stats = remoteIterator;
                }

                public boolean hasNext() throws IOException {
                    return this.stats.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    LocatedFileStatus result = (LocatedFileStatus)this.stats.next();
                    return new LocatedFileStatus(ProxyFileSystem23.super.swizzleFileStatus((FileStatus)result, false), result.getBlockLocations());
                }
            };
        }

        public void access(Path path, FsAction action) throws AccessControlException, FileNotFoundException, IOException {
            Path underlyingFsPath = this.swizzleParamPath(path);
            FileStatus underlyingFsStatus = this.fs.getFileStatus(underlyingFsPath);
            try {
                if (accessMethod != null) {
                    accessMethod.invoke((Object)this.fs, underlyingFsPath, action);
                } else {
                    DefaultFileAccess.checkFileAccess((FileSystem)this.fs, (FileStatus)underlyingFsStatus, (FsAction)action);
                }
            }
            catch (AccessControlException err) {
                throw err;
            }
            catch (FileNotFoundException err) {
                throw err;
            }
            catch (IOException err) {
                throw err;
            }
            catch (Exception err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }
    }

    public static class KerberosNameShim
    implements HadoopShims.KerberosNameShim {
        private final KerberosName kerberosName;

        public KerberosNameShim(String name) {
            this.kerberosName = new KerberosName(name);
        }

        public String getDefaultRealm() {
            KerberosNameShim kerberosNameShim = this;
            return kerberosNameShim.kerberosName.getDefaultRealm();
        }

        public String getServiceName() {
            return this.kerberosName.getServiceName();
        }

        public String getHostName() {
            return this.kerberosName.getHostName();
        }

        public String getRealm() {
            return this.kerberosName.getRealm();
        }

        public String getShortName() throws IOException {
            return this.kerberosName.getShortName();
        }
    }

    public static class StoragePolicyShim
    implements HadoopShims.StoragePolicyShim {
        private final DistributedFileSystem dfs;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="intended")
        public StoragePolicyShim(DistributedFileSystem fs) {
            this.dfs = fs;
        }

        public void setStoragePolicy(Path path, HadoopShims.StoragePolicyValue policy) throws IOException {
            switch (policy) {
                case MEMORY: {
                    this.dfs.setStoragePolicy(path, "LAZY_PERSIST");
                    break;
                }
                case SSD: {
                    this.dfs.setStoragePolicy(path, "ALL_SSD");
                    break;
                }
                case DEFAULT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown storage policy " + String.valueOf(policy));
                }
            }
        }
    }

    public static class HdfsEncryptionShim
    implements HadoopShims.HdfsEncryptionShim {
        private static final String HDFS_SECURITY_DEFAULT_CIPHER = "AES/CTR/NoPadding";
        private HdfsAdmin hdfsAdmin = null;
        private KeyProvider keyProvider = null;
        private final Configuration conf;

        public static HdfsEncryptionShim createInstance(URI uri, Configuration conf) throws IOException {
            HdfsAdmin hadmin = new HdfsAdmin(uri, conf);
            KeyProvider keyP = hadmin.getKeyProvider();
            HdfsEncryptionShim hdfsEncryptionShim = new HdfsEncryptionShim(conf);
            hdfsEncryptionShim.hdfsAdmin = hadmin;
            hdfsEncryptionShim.keyProvider = keyP;
            return hdfsEncryptionShim;
        }

        private HdfsEncryptionShim(Configuration conf) {
            this.conf = conf;
        }

        public boolean isPathEncrypted(Path path) throws IOException {
            Path fullPath = path.isAbsolute() ? path : path.getFileSystem(this.conf).makeQualified(path);
            if (!this.isFileInHdfs(path.getFileSystem(this.conf), path)) {
                return false;
            }
            return this.getEncryptionZoneForPath(fullPath) != null;
        }

        private boolean isMountedFs(FileSystem fs) {
            return fs.getChildFileSystems() != null;
        }

        private boolean isFileInHdfs(FileSystem fs, Path path) throws IOException {
            String hdfsScheme = "hdfs";
            boolean isHdfs = hdfsScheme.equalsIgnoreCase(path.toUri().getScheme());
            if (isHdfs && this.isMountedFs(fs)) {
                isHdfs = hdfsScheme.equals(fs.resolvePath(path).toUri().getScheme());
            }
            return isHdfs;
        }

        public EncryptionZone getEncryptionZoneForPath(Path path) throws IOException {
            if (path.getFileSystem(this.conf).exists(path)) {
                return this.hdfsAdmin.getEncryptionZoneForPath(path);
            }
            if (!path.getParent().equals((Object)path)) {
                return this.getEncryptionZoneForPath(path.getParent());
            }
            return null;
        }

        public boolean arePathsOnSameEncryptionZone(Path path1, Path path2) throws IOException {
            return this.equivalentEncryptionZones(this.getEncryptionZoneForPath(path1), this.getEncryptionZoneForPath(path2));
        }

        private boolean equivalentEncryptionZones(EncryptionZone zone1, EncryptionZone zone2) {
            if (zone1 == null && zone2 == null) {
                return true;
            }
            if (zone1 == null || zone2 == null) {
                return false;
            }
            return zone1.equals((Object)zone2);
        }

        public boolean arePathsOnSameEncryptionZone(Path path1, Path path2, HadoopShims.HdfsEncryptionShim encryptionShim2) throws IOException {
            if (!(encryptionShim2 instanceof HdfsEncryptionShim)) {
                HadoopShimsSecure.LOG.warn("EncryptionShim for path2 (" + String.valueOf(path2) + ") is of unexpected type: " + String.valueOf(encryptionShim2.getClass()) + ". Assuming path2 is on the same EncryptionZone as path1(" + String.valueOf(path1) + ").");
                return true;
            }
            return this.equivalentEncryptionZones(this.hdfsAdmin.getEncryptionZoneForPath(path1), ((HdfsEncryptionShim)encryptionShim2).hdfsAdmin.getEncryptionZoneForPath(path2));
        }

        public int comparePathKeyStrength(Path path1, Path path2, HadoopShims.HdfsEncryptionShim encryptionShim2) throws IOException {
            EncryptionZone zone1 = this.getEncryptionZoneForPath(path1);
            EncryptionZone zone2 = ((HdfsEncryptionShim)encryptionShim2).hdfsAdmin.getEncryptionZoneForPath(path2);
            if (zone1 == null && zone2 == null) {
                return 0;
            }
            if (zone1 == null) {
                return -1;
            }
            if (zone2 == null) {
                return 1;
            }
            return this.compareKeyStrength(zone1, zone2);
        }

        public void createEncryptionZone(Path path, String keyName) throws IOException {
            this.hdfsAdmin.createEncryptionZone(path, keyName);
        }

        public void createKey(String keyName, int bitLength) throws IOException, NoSuchAlgorithmException {
            this.checkKeyProvider();
            if (this.keyProvider.getMetadata(keyName) != null) {
                throw new IOException("key '" + keyName + "' already exists");
            }
            KeyProvider.Options options = new KeyProvider.Options(this.conf);
            options.setCipher(HDFS_SECURITY_DEFAULT_CIPHER);
            options.setBitLength(bitLength);
            this.keyProvider.createKey(keyName, options);
            this.keyProvider.flush();
        }

        public void deleteKey(String keyName) throws IOException {
            this.checkKeyProvider();
            if (this.keyProvider.getMetadata(keyName) == null) {
                throw new IOException("key '" + keyName + "' does not exist.");
            }
            this.keyProvider.deleteKey(keyName);
            this.keyProvider.flush();
        }

        public List<String> getKeys() throws IOException {
            this.checkKeyProvider();
            return this.keyProvider.getKeys();
        }

        private void checkKeyProvider() throws IOException {
            if (this.keyProvider == null) {
                throw new IOException("HDFS security key provider is not configured on your server.");
            }
        }

        private int compareKeyStrength(EncryptionZone zone1, EncryptionZone zone2) throws IOException {
            assert (zone1 != null && zone2 != null) : "Neither EncryptionZone under comparison can be null.";
            CipherSuite suite1 = zone1.getSuite();
            CipherSuite suite2 = zone2.getSuite();
            if (suite1 == null && suite2 == null) {
                return 0;
            }
            if (suite1 == null) {
                return -1;
            }
            if (suite2 == null) {
                return 1;
            }
            return Integer.compare(suite1.getAlgorithmBlockSize(), suite2.getAlgorithmBlockSize());
        }
    }

    public static class HdfsErasureCodingShim
    implements HadoopShims.HdfsErasureCodingShim {
        private HdfsAdmin hdfsAdmin = null;
        private final Configuration conf;

        HdfsErasureCodingShim(URI uri, Configuration conf) throws IOException {
            this.conf = conf;
            this.hdfsAdmin = new HdfsAdmin(uri, conf);
        }

        public List<HadoopShims.HdfsFileErasureCodingPolicy> getAllErasureCodingPolicies() throws IOException {
            ErasureCodingPolicyInfo[] erasureCodingPolicies = this.hdfsAdmin.getErasureCodingPolicies();
            ArrayList<HadoopShims.HdfsFileErasureCodingPolicy> policies = new ArrayList<HadoopShims.HdfsFileErasureCodingPolicy>(erasureCodingPolicies.length);
            for (ErasureCodingPolicyInfo erasureCodingPolicy : erasureCodingPolicies) {
                policies.add(new HdfsFileErasureCodingPolicyImpl(erasureCodingPolicy.getPolicy().getName(), erasureCodingPolicy.getState().toString()));
            }
            return policies;
        }

        public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
            this.hdfsAdmin.enableErasureCodingPolicy(ecPolicyName);
        }

        public void setErasureCodingPolicy(Path path, String ecPolicyName) throws IOException {
            this.hdfsAdmin.setErasureCodingPolicy(path, ecPolicyName);
        }

        public HadoopShims.HdfsFileErasureCodingPolicy getErasureCodingPolicy(Path path) throws IOException {
            ErasureCodingPolicy erasureCodingPolicy = this.hdfsAdmin.getErasureCodingPolicy(path);
            if (erasureCodingPolicy == null) {
                return null;
            }
            return new HdfsFileErasureCodingPolicyImpl(erasureCodingPolicy.getName());
        }

        public void unsetErasureCodingPolicy(Path path) throws IOException {
            this.hdfsAdmin.unsetErasureCodingPolicy(path);
        }

        public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
            this.hdfsAdmin.removeErasureCodingPolicy(ecPolicyName);
        }

        public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
            this.hdfsAdmin.disableErasureCodingPolicy(ecPolicyName);
        }

        public boolean isMapReduceStatAvailable() {
            Field field = null;
            try {
                field = FileSystemCounter.class.getField("BYTES_READ_EC");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return field != null;
        }
    }

    private static class HdfsFileErasureCodingPolicyImpl
    implements HadoopShims.HdfsFileErasureCodingPolicy {
        private final String name;
        private final String status;

        HdfsFileErasureCodingPolicyImpl(String name, String status) {
            this.name = name;
            this.status = status;
        }

        HdfsFileErasureCodingPolicyImpl(String name) {
            this(name, null);
        }

        public String getName() {
            return this.name;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

