/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureForSnapshotType
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureForSnapshotType.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testSnapshotTypeForEnabledTable() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String snapshotName = "snapshot_" + this.name.getMethodName();
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"info")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        this.admin.createTable(tableDescriptorBuilder.build());
        Assert.assertTrue((boolean)this.admin.tableExists(tableName));
        Assert.assertTrue((boolean)this.admin.isTableEnabled(tableName));
        this.admin.snapshot(snapshotName, tableName);
        Optional<SnapshotDescription> optional = this.admin.listSnapshots().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
        Assert.assertTrue((boolean)optional.isPresent());
        SnapshotDescription snapshotDescription = optional.get();
        Assert.assertEquals((Object)SnapshotType.FLUSH, (Object)snapshotDescription.getType());
    }

    @Test
    public void testSnapshotTypeForDisabledTable() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String snapshotName = "snapshot_" + this.name.getMethodName();
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"info")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        this.admin.createTable(tableDescriptorBuilder.build());
        Assert.assertTrue((boolean)this.admin.tableExists(tableName));
        Assert.assertTrue((boolean)this.admin.isTableEnabled(tableName));
        this.admin.disableTable(tableName);
        Assert.assertTrue((boolean)this.admin.isTableDisabled(tableName));
        this.admin.snapshot(snapshotName, tableName);
        Optional<SnapshotDescription> optional = this.admin.listSnapshots().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
        Assert.assertTrue((boolean)optional.isPresent());
        SnapshotDescription snapshotDescription = optional.get();
        Assert.assertEquals((Object)SnapshotType.DISABLED, (Object)snapshotDescription.getType());
    }
}

