/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.HasEnhancedByteBufferAccess;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.io.ByteBufferPool;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFSDataInputStreamWrapper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSDataInputStreamWrapper.class);

    @Test
    public void testUnbuffer() throws Exception {
        ParentClass pc = new ParentClass();
        ParentClass noChecksumPc = new ParentClass();
        FSDataInputStreamWrapper fsdisw1 = new FSDataInputStreamWrapper(new FSDataInputStream((InputStream)((Object)pc)), new FSDataInputStream((InputStream)((Object)noChecksumPc)));
        fsdisw1.unbuffer();
        Assert.assertTrue((boolean)pc.getIsCallUnbuffer());
        Assert.assertFalse((boolean)noChecksumPc.getIsCallUnbuffer());
        fsdisw1.setShouldUseHBaseChecksum();
        fsdisw1.unbuffer();
        Assert.assertTrue((boolean)noChecksumPc.getIsCallUnbuffer());
        fsdisw1.close();
    }

    private class ParentClass
    extends FSInputStream
    implements ByteBufferReadable,
    CanSetDropBehind,
    CanSetReadahead,
    HasEnhancedByteBufferAccess,
    CanUnbuffer,
    StreamCapabilities {
        public boolean isCallUnbuffer = false;

        private ParentClass() {
        }

        public boolean getIsCallUnbuffer() {
            return this.isCallUnbuffer;
        }

        public void unbuffer() {
            this.isCallUnbuffer = true;
        }

        public int read() throws IOException {
            return 0;
        }

        public ByteBuffer read(ByteBufferPool paramByteBufferPool, int paramInt, EnumSet<ReadOption> paramEnumSet) throws IOException, UnsupportedOperationException {
            return null;
        }

        public void releaseBuffer(ByteBuffer paramByteBuffer) {
        }

        public void setReadahead(Long paramLong) throws IOException, UnsupportedOperationException {
        }

        public void setDropBehind(Boolean paramBoolean) throws IOException, UnsupportedOperationException {
        }

        public int read(ByteBuffer paramByteBuffer) throws IOException {
            return 0;
        }

        public void seek(long paramLong) throws IOException {
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public boolean seekToNewSource(long paramLong) throws IOException {
            return false;
        }

        public boolean hasCapability(String s) {
            return s.equals("in:unbuffer");
        }
    }
}

