/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.asyncfs.monitor.ExcludeDatanodeManager;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALTailingReader;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LeaseNotRecoveredException;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.DisabledWALProvider;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.RegionGroupingProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hadoop.hbase.wal.WALTailingReader;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class WALFactory {
    public static final String WAL_STREAM_READER_CLASS_IMPL = "hbase.regionserver.wal.stream.reader.impl";
    private static final Logger LOG = LoggerFactory.getLogger(WALFactory.class);
    public static final String WAL_PROVIDER = "hbase.wal.provider";
    static final String DEFAULT_WAL_PROVIDER = Providers.defaultProvider.name();
    public static final String META_WAL_PROVIDER = "hbase.wal.meta_provider";
    public static final String WAL_ENABLED = "hbase.regionserver.hlog.enabled";
    final String factoryId;
    final Abortable abortable;
    private final WALProvider provider;
    private final AtomicReference<WALProvider> metaProvider = new AtomicReference();
    private final Class<? extends WALStreamReader> walStreamReaderClass;
    private final int timeoutMillis;
    private final Configuration conf;
    private final ExcludeDatanodeManager excludeDatanodeManager;
    private static final AtomicReference<WALFactory> singleton = new AtomicReference();
    private static final String SINGLETON_ID = WALFactory.class.getName();

    private WALFactory(Configuration conf) {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.walStreamReaderClass = conf.getClass(WAL_STREAM_READER_CLASS_IMPL, ProtobufWALStreamReader.class, WALStreamReader.class);
        Preconditions.checkArgument(AbstractFSWALProvider.Initializer.class.isAssignableFrom(this.walStreamReaderClass), "The wal stream reader class %s is not a sub class of %s", (Object)this.walStreamReaderClass.getName(), (Object)AbstractFSWALProvider.Initializer.class.getName());
        this.conf = conf;
        this.provider = null;
        this.factoryId = SINGLETON_ID;
        this.abortable = null;
        this.excludeDatanodeManager = new ExcludeDatanodeManager(conf);
    }

    Providers getDefaultProvider() {
        return Providers.defaultProvider;
    }

    public Class<? extends WALProvider> getProviderClass(String key, String defaultValue) {
        try {
            Providers provider = Providers.valueOf(this.conf.get(key, defaultValue));
            if (provider == this.getDefaultProvider() && provider.clazz == AsyncFSWALProvider.class && !AsyncFSWALProvider.load()) {
                LOG.warn("Failed to load AsyncFSWALProvider, falling back to FSHLogProvider");
                return FSHLogProvider.class;
            }
            return provider.clazz;
        }
        catch (IllegalArgumentException exception) {
            return this.conf.getClass(key, Providers.defaultProvider.clazz, WALProvider.class);
        }
    }

    WALProvider createProvider(Class<? extends WALProvider> clazz, String providerId) throws IOException {
        LOG.info("Instantiating WALProvider of type " + clazz);
        try {
            WALProvider result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.init(this, this.conf, providerId, this.abortable);
            return result;
        }
        catch (Exception e) {
            LOG.error("couldn't set up WALProvider, the configured class is " + clazz);
            LOG.debug("Exception details for failure to load WALProvider.", (Throwable)e);
            throw new IOException("couldn't set up WALProvider", e);
        }
    }

    WALProvider getProvider(String key, String defaultValue, String providerId) throws IOException {
        Class<? extends WALProvider> clazz = this.getProviderClass(key, defaultValue);
        WALProvider provider = this.createProvider(clazz, providerId);
        provider.addWALActionsListener(new MetricsWAL());
        return provider;
    }

    public WALFactory(Configuration conf, String factoryId) throws IOException {
        this(conf, factoryId, null);
    }

    public WALFactory(Configuration conf, String factoryId, Abortable abortable) throws IOException {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.walStreamReaderClass = conf.getClass(WAL_STREAM_READER_CLASS_IMPL, ProtobufWALStreamReader.class, WALStreamReader.class);
        Preconditions.checkArgument(AbstractFSWALProvider.Initializer.class.isAssignableFrom(this.walStreamReaderClass), "The wal stream reader class %s is not a sub class of %s", (Object)this.walStreamReaderClass.getName(), (Object)AbstractFSWALProvider.Initializer.class.getName());
        this.conf = conf;
        this.factoryId = factoryId;
        this.excludeDatanodeManager = new ExcludeDatanodeManager(conf);
        this.abortable = abortable;
        if (conf.getBoolean(WAL_ENABLED, true)) {
            this.provider = this.getProvider(WAL_PROVIDER, DEFAULT_WAL_PROVIDER, null);
        } else {
            LOG.warn("Running with WAL disabled.");
            this.provider = new DisabledWALProvider();
            this.provider.init(this, conf, factoryId, null);
        }
    }

    public void close() throws IOException {
        WALProvider metaProvider = this.metaProvider.get();
        if (null != metaProvider) {
            metaProvider.close();
        }
        if (null != this.provider) {
            this.provider.close();
        }
    }

    public void shutdown() throws IOException {
        IOException exception = null;
        WALProvider metaProvider = this.metaProvider.get();
        if (null != metaProvider) {
            try {
                metaProvider.shutdown();
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        this.provider.shutdown();
        if (null != exception) {
            throw exception;
        }
    }

    public List<WAL> getWALs() {
        return this.provider.getWALs();
    }

    public WALProvider getMetaProvider() throws IOException {
        WALProvider provider;
        while ((provider = this.metaProvider.get()) == null) {
            Class<? extends WALProvider> clz = null;
            if (this.conf.get(META_WAL_PROVIDER) == null) {
                try {
                    clz = this.conf.getClass(WAL_PROVIDER, Providers.defaultProvider.clazz, WALProvider.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (clz == null) {
                clz = this.getProviderClass(META_WAL_PROVIDER, this.conf.get(WAL_PROVIDER, DEFAULT_WAL_PROVIDER));
            }
            if (this.metaProvider.compareAndSet(null, provider = this.createProvider(clz, ".meta"))) {
                return provider;
            }
            provider.close();
        }
        return provider;
    }

    public WAL getWAL(RegionInfo region) throws IOException {
        if (region != null && region.isMetaRegion() && region.getReplicaId() == 0) {
            return this.getMetaProvider().getWAL(region);
        }
        return this.provider.getWAL(region);
    }

    public WALStreamReader createStreamReader(FileSystem fs, Path path) throws IOException {
        return this.createStreamReader(fs, path, null);
    }

    public WALStreamReader createStreamReader(FileSystem fs, Path path, CancelableProgressable reporter) throws IOException {
        return this.createStreamReader(fs, path, reporter, -1L);
    }

    public WALStreamReader createStreamReader(FileSystem fs, Path path, CancelableProgressable reporter, long startPosition) throws IOException {
        try {
            long startWaiting = EnvironmentEdgeManager.currentTime();
            long openTimeout = (long)this.timeoutMillis + startWaiting;
            int nbAttempt = 0;
            WALStreamReader reader = null;
            while (true) {
                try {
                    reader = this.walStreamReaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ((AbstractFSWALProvider.Initializer)((Object)reader)).init(fs, path, this.conf, startPosition);
                    return reader;
                }
                catch (Exception e) {
                    String msg;
                    if (reader != null) {
                        reader.close();
                    }
                    if (e instanceof IOException && (msg = e.getMessage()) != null && (msg.contains("Cannot obtain block length") || msg.contains("Could not obtain the last block") || msg.matches("Blocklist for [^ ]* has changed.*"))) {
                        if (++nbAttempt == 1) {
                            LOG.warn("Lease should have recovered. This is not expected. Will retry", (Throwable)e);
                        }
                        if (reporter != null && !reporter.progress()) {
                            throw new InterruptedIOException("Operation is cancelled");
                        }
                        if (nbAttempt <= 2 || openTimeout >= EnvironmentEdgeManager.currentTime()) {
                            try {
                                Thread.sleep(nbAttempt < 3 ? 500L : 1000L);
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException iioe = new InterruptedIOException();
                                iioe.initCause(ie);
                                throw iioe;
                            }
                            continue;
                        }
                        LOG.error("Can't open after " + nbAttempt + " attempts and " + (EnvironmentEdgeManager.currentTime() - startWaiting) + "ms  for " + path);
                        throw new LeaseNotRecoveredException(e);
                    }
                    throw e;
                }
                break;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new IOException("Cannot get log reader", e);
        }
    }

    public WALProvider.Writer createWALWriter(FileSystem fs, Path path) throws IOException {
        return FSHLogProvider.createWriter(this.conf, fs, path, false);
    }

    public WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path) throws IOException {
        return FSHLogProvider.createWriter(this.conf, fs, path, true);
    }

    public static WALFactory getInstance(Configuration configuration) {
        WALFactory factory = singleton.get();
        if (null == factory) {
            WALFactory temp = new WALFactory(configuration);
            if (singleton.compareAndSet(null, temp)) {
                factory = temp;
            } else {
                try {
                    temp.close();
                }
                catch (IOException exception) {
                    LOG.debug("failed to close temporary singleton. ignoring.", (Throwable)exception);
                }
                factory = singleton.get();
            }
        }
        return factory;
    }

    public static WALTailingReader createTailingReader(FileSystem fs, Path path, Configuration conf, long startPosition) throws IOException {
        ProtobufWALTailingReader reader = new ProtobufWALTailingReader();
        reader.init(fs, path, conf, startPosition);
        return reader;
    }

    public static WALStreamReader createStreamReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        return WALFactory.createStreamReader(fs, path, conf, -1L);
    }

    public static WALStreamReader createStreamReader(FileSystem fs, Path path, Configuration conf, long startPosition) throws IOException {
        return WALFactory.getInstance(conf).createStreamReader(fs, path, null, startPosition);
    }

    static WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return FSHLogProvider.createWriter(configuration, fs, path, true);
    }

    public static WALProvider.Writer createWALWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return FSHLogProvider.createWriter(configuration, fs, path, false);
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public WALProvider getWALProvider() {
        return this.provider;
    }

    public WALProvider getMetaWALProvider() {
        return this.metaProvider.get();
    }

    public ExcludeDatanodeManager getExcludeDatanodeManager() {
        return this.excludeDatanodeManager;
    }

    static enum Providers {
        defaultProvider(AsyncFSWALProvider.class),
        filesystem(FSHLogProvider.class),
        multiwal(RegionGroupingProvider.class),
        asyncfs(AsyncFSWALProvider.class);

        final Class<? extends WALProvider> clazz;

        private Providers(Class<? extends WALProvider> clazz) {
            this.clazz = clazz;
        }
    }
}

