/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.statistics;

import java.time.Duration;
import java.util.Objects;

public class LatencyHistogramConfiguration {
    public static final double DEFAULT_PHI = 0.63;
    public static final int DEFAULT_BUCKET_COUNT = 20;
    public static final Duration DEFAULT_WINDOW = Duration.ofMinutes(1L);
    public static final LatencyHistogramConfiguration DEFAULT = new LatencyHistogramConfiguration(0.63, 20, DEFAULT_WINDOW);
    private final double phi;
    private final int bucketCount;
    private final Duration window;

    public LatencyHistogramConfiguration(double phi, int bucketCount, Duration window) {
        this.phi = phi;
        this.bucketCount = bucketCount;
        this.window = Objects.requireNonNull(window);
    }

    public double getPhi() {
        return this.phi;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public Duration getWindow() {
        return this.window;
    }

    public String toString() {
        return "LatencyHistogramConfiguration{phi=" + this.phi + ", bucketCount=" + this.bucketCount + ", window=" + this.window + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatencyHistogramConfiguration that = (LatencyHistogramConfiguration)o;
        if (that.phi != this.phi) {
            return false;
        }
        if (this.bucketCount != that.bucketCount) {
            return false;
        }
        return this.window.equals(that.window);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.phi);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.bucketCount;
        result = 31 * result + this.window.hashCode();
        return result;
    }
}

