/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership.  The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package org.apache.hadoop.yarn.server.federation.store.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience.Private;
import org.apache.hadoop.classification.InterfaceStability.Unstable;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos.GetSubClusterPolicyConfigurationResponseProto;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos.GetSubClusterPolicyConfigurationResponseProtoOrBuilder;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos.SubClusterPolicyConfigurationProto;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;

import com.google.protobuf.TextFormat;

/**
 * Protocol buffer based implementation of
 * {@link GetSubClusterPolicyConfigurationResponse}.
 */
@Private
@Unstable
public class GetSubClusterPolicyConfigurationResponsePBImpl
    extends GetSubClusterPolicyConfigurationResponse {

  private GetSubClusterPolicyConfigurationResponseProto proto =
      GetSubClusterPolicyConfigurationResponseProto.getDefaultInstance();
  private GetSubClusterPolicyConfigurationResponseProto.Builder builder = null;
  private boolean viaProto = false;

  private SubClusterPolicyConfiguration subClusterPolicy = null;

  public GetSubClusterPolicyConfigurationResponsePBImpl() {
    builder = GetSubClusterPolicyConfigurationResponseProto.newBuilder();
  }

  public GetSubClusterPolicyConfigurationResponsePBImpl(
      GetSubClusterPolicyConfigurationResponseProto proto) {
    this.proto = proto;
    viaProto = true;
  }

  public GetSubClusterPolicyConfigurationResponseProto getProto() {
    mergeLocalToProto();
    proto = viaProto ? proto : builder.build();
    viaProto = true;
    return proto;
  }

  private void mergeLocalToProto() {
    if (viaProto) {
      maybeInitBuilder();
    }
    mergeLocalToBuilder();
    proto = builder.build();
    viaProto = true;
  }

  private void maybeInitBuilder() {
    if (viaProto || builder == null) {
      builder = GetSubClusterPolicyConfigurationResponseProto.newBuilder(proto);
    }
    viaProto = false;
  }

  private void mergeLocalToBuilder() {
    if (this.subClusterPolicy != null
        && !((SubClusterPolicyConfigurationPBImpl) this.subClusterPolicy)
            .getProto().equals(builder.getPolicyConfiguration())) {
      builder
          .setPolicyConfiguration(convertToProtoFormat(this.subClusterPolicy));
    }
  }

  @Override
  public int hashCode() {
    return getProto().hashCode();
  }

  @Override
  public boolean equals(Object other) {
    if (other == null) {
      return false;
    }
    if (other.getClass().isAssignableFrom(this.getClass())) {
      return this.getProto().equals(this.getClass().cast(other).getProto());
    }
    return false;
  }

  @Override
  public String toString() {
    return TextFormat.shortDebugString(getProto());
  }

  @Override
  public SubClusterPolicyConfiguration getPolicyConfiguration() {
    GetSubClusterPolicyConfigurationResponseProtoOrBuilder p =
        viaProto ? proto : builder;
    if (this.subClusterPolicy != null) {
      return this.subClusterPolicy;
    }
    if (!p.hasPolicyConfiguration()) {
      return null;
    }
    this.subClusterPolicy = convertFromProtoFormat(p.getPolicyConfiguration());
    return this.subClusterPolicy;
  }

  @Override
  public void setPolicyConfiguration(
      SubClusterPolicyConfiguration policyConfiguration) {
    maybeInitBuilder();
    if (policyConfiguration == null) {
      builder.clearPolicyConfiguration();
    }
    this.subClusterPolicy = policyConfiguration;
  }

  private SubClusterPolicyConfiguration convertFromProtoFormat(
      SubClusterPolicyConfigurationProto policy) {
    return new SubClusterPolicyConfigurationPBImpl(policy);
  }

  private SubClusterPolicyConfigurationProto convertToProtoFormat(
      SubClusterPolicyConfiguration policy) {
    return ((SubClusterPolicyConfigurationPBImpl) policy).getProto();
  }

}
