/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.spring.boot.config;

import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.SinkRunner;
import org.apache.flume.SourceRunner;
import org.apache.flume.node.MaterializedConfiguration;
import org.apache.flume.node.SimpleMaterializedConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringConfiguration {
    @Autowired
    public Map<String, Channel> channels;
    @Autowired
    public Map<String, SinkRunner> sinkRunners;
    @Autowired
    public Map<String, SourceRunner> sourceRunners;

    @Bean
    public MaterializedConfiguration configuration() {
        SimpleMaterializedConfiguration config = new SimpleMaterializedConfiguration();
        for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
            config.addChannel(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Channel> entry : this.sinkRunners.entrySet()) {
            config.addSinkRunner(entry.getKey(), (SinkRunner)entry.getValue());
        }
        for (Map.Entry<String, Channel> entry : this.sourceRunners.entrySet()) {
            config.addSourceRunner(entry.getKey(), (SourceRunner)entry.getValue());
        }
        return config;
    }
}

