/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.PatternProcessFunctionBuilder;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternStreamBuilder;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class PatternStream<T> {
    private final PatternStreamBuilder<T> builder;

    private PatternStream(PatternStreamBuilder<T> builder) {
        this.builder = (PatternStreamBuilder)Preconditions.checkNotNull(builder);
    }

    PatternStream(DataStream<T> inputStream, Pattern<T, ?> pattern) {
        this(PatternStreamBuilder.forStreamAndPattern(inputStream, pattern));
    }

    PatternStream<T> withComparator(EventComparator<T> comparator) {
        return new PatternStream<T>(this.builder.withComparator(comparator));
    }

    public PatternStream<T> sideOutputLateData(OutputTag<T> lateDataOutputTag) {
        return new PatternStream<T>(this.builder.withLateDataOutputTag(lateDataOutputTag));
    }

    public PatternStream<T> inProcessingTime() {
        return new PatternStream<T>(this.builder.inProcessingTime());
    }

    public PatternStream<T> inEventTime() {
        return new PatternStream<T>(this.builder.inEventTime());
    }

    public <R> SingleOutputStreamOperator<R> process(PatternProcessFunction<T, R> patternProcessFunction) {
        TypeInformation returnType = TypeExtractor.getUnaryOperatorReturnType(patternProcessFunction, PatternProcessFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, this.builder.getInputType(), null, (boolean)false);
        return this.process(patternProcessFunction, returnType);
    }

    public <R> SingleOutputStreamOperator<R> process(PatternProcessFunction<T, R> patternProcessFunction, TypeInformation<R> outTypeInfo) {
        return this.builder.build(outTypeInfo, this.builder.clean(patternProcessFunction));
    }

    public <R> SingleOutputStreamOperator<R> select(PatternSelectFunction<T, R> patternSelectFunction) {
        TypeInformation returnType = TypeExtractor.getUnaryOperatorReturnType(patternSelectFunction, PatternSelectFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, this.builder.getInputType(), null, (boolean)false);
        return this.select(patternSelectFunction, returnType);
    }

    public <R> SingleOutputStreamOperator<R> select(PatternSelectFunction<T, R> patternSelectFunction, TypeInformation<R> outTypeInfo) {
        PatternProcessFunction<T, R> processFunction = PatternProcessFunctionBuilder.fromSelect(this.builder.clean(patternSelectFunction)).build();
        return this.process(processFunction, outTypeInfo);
    }

    public <L, R> SingleOutputStreamOperator<R> select(OutputTag<L> timedOutPartialMatchesTag, PatternTimeoutFunction<T, L> patternTimeoutFunction, PatternSelectFunction<T, R> patternSelectFunction) {
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternSelectFunction, PatternSelectFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, this.builder.getInputType(), null, (boolean)false);
        return this.select(timedOutPartialMatchesTag, patternTimeoutFunction, rightTypeInfo, patternSelectFunction);
    }

    public <L, R> SingleOutputStreamOperator<R> select(OutputTag<L> timedOutPartialMatchesTag, PatternTimeoutFunction<T, L> patternTimeoutFunction, TypeInformation<R> outTypeInfo, PatternSelectFunction<T, R> patternSelectFunction) {
        PatternProcessFunction<T, R> processFunction = PatternProcessFunctionBuilder.fromSelect(this.builder.clean(patternSelectFunction)).withTimeoutHandler(timedOutPartialMatchesTag, this.builder.clean(patternTimeoutFunction)).build();
        return this.process(processFunction, outTypeInfo);
    }

    public <R> SingleOutputStreamOperator<R> flatSelect(PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        TypeInformation outTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatSelectFunction, PatternFlatSelectFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, this.builder.getInputType(), null, (boolean)false);
        return this.flatSelect(patternFlatSelectFunction, outTypeInfo);
    }

    public <R> SingleOutputStreamOperator<R> flatSelect(PatternFlatSelectFunction<T, R> patternFlatSelectFunction, TypeInformation<R> outTypeInfo) {
        PatternProcessFunction<T, R> processFunction = PatternProcessFunctionBuilder.fromFlatSelect(this.builder.clean(patternFlatSelectFunction)).build();
        return this.process(processFunction, outTypeInfo);
    }

    public <L, R> SingleOutputStreamOperator<R> flatSelect(OutputTag<L> timedOutPartialMatchesTag, PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction, PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatSelectFunction, PatternFlatSelectFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, this.builder.getInputType(), null, (boolean)false);
        return this.flatSelect(timedOutPartialMatchesTag, patternFlatTimeoutFunction, rightTypeInfo, patternFlatSelectFunction);
    }

    public <L, R> SingleOutputStreamOperator<R> flatSelect(OutputTag<L> timedOutPartialMatchesTag, PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction, TypeInformation<R> outTypeInfo, PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        PatternProcessFunction<T, R> processFunction = PatternProcessFunctionBuilder.fromFlatSelect(this.builder.clean(patternFlatSelectFunction)).withTimeoutHandler(timedOutPartialMatchesTag, this.builder.clean(patternFlatTimeoutFunction)).build();
        return this.process(processFunction, outTypeInfo);
    }
}

