/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class CatalogTableStatistics {
    public static final CatalogTableStatistics UNKNOWN = new CatalogTableStatistics(-1L, -1, -1L, -1L);
    private final long rowCount;
    private final int fileCount;
    private final long totalSize;
    private final long rawDataSize;
    private final Map<String, String> properties;

    public CatalogTableStatistics(long rowCount, int fileCount, long totalSize, long rawDataSize) {
        this(rowCount, fileCount, totalSize, rawDataSize, new HashMap<String, String>());
    }

    public CatalogTableStatistics(long rowCount, int fileCount, long totalSize, long rawDataSize, Map<String, String> properties) {
        this.rowCount = rowCount;
        this.fileCount = fileCount;
        this.totalSize = totalSize;
        this.rawDataSize = rawDataSize;
        this.properties = properties;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getRawDataSize() {
        return this.rawDataSize;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public CatalogTableStatistics copy() {
        return new CatalogTableStatistics(this.rowCount, this.fileCount, this.totalSize, this.rawDataSize, new HashMap<String, String>(this.properties));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogTableStatistics that = (CatalogTableStatistics)o;
        return this.rowCount == that.rowCount && this.fileCount == that.fileCount && this.totalSize == that.totalSize && this.rawDataSize == that.rawDataSize && this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.fileCount, this.totalSize, this.rawDataSize, this.properties);
    }

    public String toString() {
        return "CatalogTableStatistics{rowCount=" + this.rowCount + ", fileCount=" + this.fileCount + ", totalSize=" + this.totalSize + ", rawDataSize=" + this.rawDataSize + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

