/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.python;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Internal
public class PythonTableFunction
extends TableFunction<Row>
implements PythonFunction {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final byte[] serializedTableFunction;
    private final PythonFunctionKind pythonFunctionKind;
    private final boolean deterministic;
    private final PythonEnv pythonEnv;
    private final boolean takesRowAsInput;
    private DataType[] inputTypes;
    private String[] inputTypesString;
    private DataType resultType;
    private String resultTypeString;

    public PythonTableFunction(String name, byte[] serializedScalarFunction, DataType[] inputTypes, DataType resultType, PythonFunctionKind pythonFunctionKind, boolean deterministic, boolean takesRowAsInput, PythonEnv pythonEnv) {
        this(name, serializedScalarFunction, pythonFunctionKind, deterministic, takesRowAsInput, pythonEnv);
        this.inputTypes = inputTypes;
        this.resultType = resultType;
    }

    public PythonTableFunction(String name, byte[] serializedScalarFunction, String[] inputTypesString, String resultTypeString, PythonFunctionKind pythonFunctionKind, boolean deterministic, boolean takesRowAsInput, PythonEnv pythonEnv) {
        this(name, serializedScalarFunction, pythonFunctionKind, deterministic, takesRowAsInput, pythonEnv);
        this.inputTypesString = inputTypesString;
        this.resultTypeString = resultTypeString;
    }

    public PythonTableFunction(String name, byte[] serializedScalarFunction, PythonFunctionKind pythonFunctionKind, boolean deterministic, boolean takesRowAsInput, PythonEnv pythonEnv) {
        this.name = name;
        this.serializedTableFunction = serializedScalarFunction;
        this.pythonFunctionKind = pythonFunctionKind;
        this.deterministic = deterministic;
        this.pythonEnv = pythonEnv;
        this.takesRowAsInput = takesRowAsInput;
    }

    public void eval(Object ... args) {
        throw new UnsupportedOperationException("This method is a placeholder and should not be called.");
    }

    @Override
    public byte[] getSerializedPythonFunction() {
        return this.serializedTableFunction;
    }

    @Override
    public PythonEnv getPythonEnv() {
        return this.pythonEnv;
    }

    @Override
    public PythonFunctionKind getPythonFunctionKind() {
        return this.pythonFunctionKind;
    }

    @Override
    public boolean takesRowAsInput() {
        return this.takesRowAsInput;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public TypeInformation[] getParameterTypes(Class[] signature) {
        if (this.inputTypes != null) {
            return TypeConversions.fromDataTypeToLegacyInfo(this.inputTypes);
        }
        return super.getParameterTypes(signature);
    }

    @Override
    public TypeInformation<Row> getResultType() {
        if (this.resultType == null && this.resultTypeString != null) {
            throw new RuntimeException("String format result type is not supported in old type system. The `register_function` is deprecated, please Use `create_temporary_system_function` instead.");
        }
        return TypeConversions.fromDataTypeToLegacyInfo(this.resultType);
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        TypeInference.Builder builder = TypeInference.newBuilder();
        if (this.inputTypesString != null) {
            this.inputTypes = (DataType[])Arrays.stream(this.inputTypesString).map(typeFactory::createDataType).toArray();
        }
        if (this.inputTypes != null) {
            List<DataType> argumentDataTypes = Stream.of(this.inputTypes).collect(Collectors.toList());
            builder.typedArguments(argumentDataTypes);
        }
        if (this.resultType == null) {
            this.resultType = typeFactory.createDataType(this.resultTypeString);
        }
        return builder.outputTypeStrategy(TypeStrategies.explicit(this.resultType)).build();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

