/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.xml;

import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    protected static final Logger log = LoggerFactory.getLogger(XMLUtil.class);
    private static DocumentBuilder documentBuilder = null;

    private XMLUtil() {
    }

    public static synchronized Document createDocument() {
        return documentBuilder.newDocument();
    }

    public static DocumentBuilder getDocumentBuilder() {
        return documentBuilder;
    }

    public static synchronized Element createDocument(String rootElemName) {
        Document doc = XMLUtil.createDocument();
        Element root = doc.createElement(rootElemName);
        doc.appendChild(root);
        return root;
    }

    public static synchronized Element createDocumentNS(String prefix, String rootElemName, Map<String, String> nsMap) {
        Document doc = XMLUtil.createDocument();
        Element root = null;
        if (prefix != null && prefix.length() > 0) {
            String uri = nsMap.get(prefix);
            if (uri == null) {
                log.error("Namespace URI for namespace " + prefix + " not found!");
                return null;
            }
            root = doc.createElementNS(uri, prefix + ":" + rootElemName);
        } else {
            root = doc.createElement(rootElemName);
        }
        doc.appendChild(root);
        XMLUtil.addNamespaceURIs(doc, nsMap);
        return root;
    }

    public static boolean addNamespaceURIs(Document doc, Map<String, String> nsMap) {
        Element root = doc.getDocumentElement();
        if (root == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : nsMap.entrySet()) {
            root.setAttribute("xmlns:" + entry.getKey(), entry.getValue());
        }
        return true;
    }

    public static String getNamespaceURI(Document doc, String prefix) {
        Element e = doc.getDocumentElement();
        return e.getAttributeNS("", prefix);
    }

    public static Element getFirstChild(Node parent) {
        if (parent == null) {
            return null;
        }
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element findFirstChild(Node parent, String tagName) {
        if (parent == null) {
            return null;
        }
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element elem;
            if (node.getNodeType() != 1 || !tagName.equalsIgnoreCase((elem = (Element)node).getTagName())) continue;
            return elem;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element child, boolean sameName) {
        if (child == null) {
            return null;
        }
        String name = child.getTagName();
        for (Node node = child.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            if (!sameName || !name.equalsIgnoreCase(elem.getTagName())) continue;
            return elem;
        }
        return null;
    }

    public static Element findFirstChildWithAttrib(Node parent, String tagName, String attrName, Object value) {
        String attrValue;
        Element elem = XMLUtil.findFirstChild(parent, tagName);
        if (attrName == null) {
            return null;
        }
        while (elem != null && !((attrValue = elem.getAttribute(attrName)) == null || attrValue.length() < 1 ? value == null : attrValue.equals(value.toString()))) {
            elem = XMLUtil.getNextSiblingElement(elem, true);
        }
        return elem;
    }

    public static Element findFirstChildDeep(Element parent, String tagName) {
        if (parent == null) {
            return null;
        }
        NodeList nl = parent.getElementsByTagName(tagName);
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static Element findFirstChildDeep(Document doc, String tagName) {
        if (doc == null) {
            return null;
        }
        return XMLUtil.findFirstChildDeep(doc.getDocumentElement(), tagName);
    }

    public static String getElementText(Node elem) {
        Node node;
        String value = null;
        Node node2 = node = elem != null ? elem.getFirstChild() : null;
        while (node != null) {
            if (node.getNodeType() == 3) {
                value = value == null ? node.getNodeValue() : value + node.getNodeValue();
            }
            node = node.getNextSibling();
        }
        return value;
    }

    public static boolean setElementText(Node elem, Object text) {
        Node node;
        if (elem == null) {
            return false;
        }
        for (node = elem.getFirstChild(); node != null && node.getNodeType() != 3; node = node.getNextSibling()) {
        }
        if (node != null) {
            if (text != null) {
                node.setNodeValue(text.toString());
            } else {
                elem.removeChild(node);
            }
        } else if (text != null) {
            elem.appendChild(elem.getOwnerDocument().createTextNode(text.toString()));
        }
        return true;
    }

    public static Element addElement(Node parent, String name, String value) {
        if (parent == null) {
            return null;
        }
        if (name.indexOf(32) >= 0) {
            name = name.replace(' ', '_');
        }
        Element child = parent.getOwnerDocument().createElement(name);
        if (value != null) {
            XMLUtil.setElementText(child, value);
        }
        parent.appendChild(child);
        return child;
    }

    public static Element addElement(Element parent, String name) {
        return XMLUtil.addElement(parent, name, null);
    }

    public static Element addElementNS(Node parent, String prefix, String name, String value) {
        if (parent == null) {
            return null;
        }
        if (prefix == null || prefix.length() == 0) {
            return XMLUtil.addElement(parent, name, value);
        }
        Document doc = parent.getOwnerDocument();
        String uri = XMLUtil.getNamespaceURI(doc, prefix);
        if (uri == null) {
            log.error("Namespace URI for namespace " + prefix + " not found!");
            return null;
        }
        Element child = doc.createElementNS(uri, prefix + ":" + name);
        if (value != null) {
            XMLUtil.setElementText(child, value);
        }
        parent.appendChild(child);
        return child;
    }

    public static Element addElementNS(Element parent, String prefix, String name) {
        return XMLUtil.addElementNS(parent, prefix, name, null);
    }

    public static Element insertElement(Node parent, String name, String value, Element pos) {
        if (parent == null) {
            return null;
        }
        Element child = parent.getOwnerDocument().createElement(name);
        if (value != null) {
            XMLUtil.setElementText(child, value);
        }
        parent.insertBefore(child, pos);
        return child;
    }

    public static Element insertElement(Node parent, String name, Element pos) {
        return XMLUtil.insertElement(parent, name, null, pos);
    }

    public static Element insertElementNS(Node parent, String prefix, String name, String value, Element pos) {
        if (parent == null) {
            return null;
        }
        if (prefix == null || prefix.length() == 0) {
            return XMLUtil.insertElement(parent, name, value, pos);
        }
        Document doc = parent.getOwnerDocument();
        String uri = XMLUtil.getNamespaceURI(doc, prefix);
        if (uri == null) {
            log.error("Namespace URI for namespace " + prefix + " not found!");
            return null;
        }
        Element child = doc.createElementNS(uri, prefix + ":" + name);
        if (value != null) {
            XMLUtil.setElementText(child, value);
        }
        parent.insertBefore(child, pos);
        return child;
    }

    public static Element insertElementNS(Node parent, String prefix, String name, Element pos) {
        return XMLUtil.insertElementNS(parent, prefix, name, null, pos);
    }

    public static String getChildText(Node parent, String childName) {
        Element elem = XMLUtil.findFirstChild(parent, childName);
        if (elem == null) {
            return null;
        }
        return XMLUtil.getElementText(elem);
    }

    public static boolean changeTagName(Element elem, String newName) {
        if (elem == null) {
            return false;
        }
        Document doc = elem.getOwnerDocument();
        Element newElem = doc.createElement(newName);
        NamedNodeMap attrs = elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr2 = (Attr)doc.importNode(attrs.item(i), true);
            newElem.getAttributes().setNamedItem(attr2);
        }
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            newElem.appendChild(node.cloneNode(true));
        }
        Node parent = elem.getParentNode();
        parent.replaceChild(newElem, elem);
        return true;
    }

    static {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        try {
            documentBuilder = dFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("XMLUtil::createDocument-->", (Throwable)e);
            e.printStackTrace();
        }
    }
}

