/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.Unwrappable;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;
import org.apache.empire.db.expr.column.DBPreparable;
import org.apache.empire.dbms.DBSqlPhrase;

public class DBCoalesceExpr
extends DBAbstractFuncExpr
implements Unwrappable<DBColumnExpr> {
    private final Object nullValue;

    public DBCoalesceExpr(DBColumnExpr expr, Object nullValue) {
        super(expr, false, expr.getDataType());
        this.nullValue = nullValue;
    }

    @Override
    public boolean isWrapper() {
        return true;
    }

    @Override
    public DBColumnExpr unwrap() {
        return this.expr;
    }

    @Override
    protected String getFunctionName() {
        return "";
    }

    @Override
    public String getName() {
        return this.expr.getName();
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.expr.getEnumType();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBCoalesceExpr) {
            DBColumnExpr otherExpr = ((DBCoalesceExpr)other).expr;
            return this.expr.equals(otherExpr);
        }
        return false;
    }

    @Override
    public void prepareParams(DBCommand cmd, DBExpr parent) {
        super.prepareParams(cmd, parent);
        if (this.nullValue instanceof DBPreparable) {
            ((DBPreparable)this.nullValue).prepareParams(cmd, this);
        }
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        super.addReferencedColumns(list);
        if (this.nullValue instanceof DBExpr) {
            ((DBExpr)this.nullValue).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        String template = this.getDbms().getSQLPhrase(DBSqlPhrase.SQL_FUNC_COALESCE);
        super.addSQL(sql, template, new Object[]{this.nullValue}, context);
    }
}

