/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.EntityDomain;
import org.apache.empire.data.bean.BeanClass;

public abstract class BeanDomain
implements EntityDomain {
    private final String name;
    private final List<BeanClass> classes = new ArrayList<BeanClass>();

    protected BeanDomain(String name) {
        this.name = name;
    }

    protected void addClass(BeanClass beanClass) {
        this.classes.add(beanClass);
        beanClass.domain = this;
    }

    public String getName() {
        return this.name;
    }

    public List<BeanClass> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    @Override
    public BeanClass getEntity(String name) {
        for (BeanClass bc : this.classes) {
            if (!StringUtils.compareEqual(name, bc.getEntityName())) continue;
            return bc;
        }
        return null;
    }
}

