/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.data.input.kinesis;

import com.amazonaws.services.kinesis.model.Record;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.indexing.kinesis.KinesisRecordSupplier;

/**
 * A {@link ByteEntity} generated by {@link KinesisRecordSupplier} and fed to any {@link InputFormat} used by kinesis
 * indexing tasks.
 * <p>
 * It can be used as a regular ByteEntity, in which case the kinesis record value is returned, but the {@link #getRecord}
 * method also allows Kinesis-aware {@link InputFormat} implementations to read the full kinesis record, including
 * timestamp, encrytion key, patition key, and sequence number
 * <p>
 * NOTE: Any records with null values will be returned as records with just only kinesis properties and no data payload
 */
public class KinesisRecordEntity extends ByteEntity
{
  private final Record record;

  public KinesisRecordEntity(Record record)
  {
    super(record.getData());
    this.record = record;
  }

  public Record getRecord()
  {
    return record;
  }
}
