/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical.stages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.msq.exec.StageProcessor;
import org.apache.druid.msq.logical.LogicalInputSpec;
import org.apache.druid.msq.logical.StageMaker;
import org.apache.druid.msq.logical.stages.AbstractFrameProcessorStage;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.logical.stages.ProjectStage;
import org.apache.druid.msq.logical.stages.SortStage;
import org.apache.druid.msq.querykit.groupby.GroupByPostShuffleStageProcessor;
import org.apache.druid.msq.querykit.groupby.GroupByPreShuffleStageProcessor;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.planner.querygen.DruidQueryGenerator;
import org.apache.druid.sql.calcite.rel.Grouping;

public class GroupByStages {
    private static final DataSource DUMMY_INPUT_DATASOURCE = new TableDataSource("__input__");

    public static LogicalStage buildStages(ProjectStage projectStage, Grouping grouping) {
        GroupByQuery gby = GroupByStages.makeGbyQuery(projectStage, grouping);
        PreShuffleStage aggStage = new PreShuffleStage(projectStage, gby.withPostAggregatorSpecs(Collections.emptyList()));
        SortStage sortStage = new SortStage(aggStage, GroupByStages.getKeyColumns(grouping.getDimensions()));
        PostShuffleStage finalAggStage = new PostShuffleStage(sortStage, gby, grouping.getOutputRowSignature());
        return finalAggStage;
    }

    private static GroupByQuery makeGbyQuery(ProjectStage projectStage, Grouping grouping) {
        GroupByQuery.Builder builder = GroupByQuery.builder();
        builder.setDimensions(grouping.getDimensionSpecs());
        builder.setQuerySegmentSpec(QuerySegmentSpec.ETERNITY);
        builder.setGranularity(Granularities.ALL);
        builder.setAggregatorSpecs(grouping.getAggregatorFactories());
        builder.setDimFilter(projectStage.getDimFilter());
        builder.setVirtualColumns(projectStage.getVirtualColumns());
        builder.setPostAggregatorSpecs(grouping.getPostAggregators());
        builder.setDataSource(DUMMY_INPUT_DATASOURCE);
        return builder.build();
    }

    private static List<KeyColumn> getKeyColumns(List<DimensionExpression> dimensions) {
        ArrayList<KeyColumn> columns = new ArrayList<KeyColumn>();
        for (DimensionExpression dimension : dimensions) {
            columns.add(new KeyColumn(dimension.getOutputName(), KeyOrder.ASCENDING));
        }
        return columns;
    }

    public static class PreShuffleStage
    extends ProjectStage {
        private GroupByQuery groupByQuery;

        public PreShuffleStage(ProjectStage projectStage, GroupByQuery gby) {
            super(projectStage, gby.getResultRowSignature(RowSignature.Finalization.NO));
            this.groupByQuery = gby;
        }

        @Override
        public LogicalStage extendWith(DruidQueryGenerator.DruidNodeStack stack) {
            return null;
        }

        @Override
        public StageProcessor<?, ?> buildStageProcessor(StageMaker stageMaker) {
            return new GroupByPreShuffleStageProcessor(this.groupByQuery);
        }
    }

    static class PostShuffleStage
    extends AbstractFrameProcessorStage {
        private GroupByQuery groupByQuery;

        public PostShuffleStage(LogicalStage inputStage, GroupByQuery groupByQuery, RowSignature outputSignature) {
            super(outputSignature, LogicalInputSpec.of(inputStage));
            this.groupByQuery = groupByQuery;
        }

        @Override
        public LogicalStage extendWith(DruidQueryGenerator.DruidNodeStack stack) {
            return null;
        }

        @Override
        public StageProcessor<?, ?> buildStageProcessor(StageMaker stageMaker) {
            return new GroupByPostShuffleStageProcessor(this.groupByQuery);
        }
    }
}

