/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchingRuleId
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchingRuleId.class);

    public StoreMatchingRuleId() {
        super("Store matching rule Value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)container.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05001_EMPTY_MATCHING_RULE, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        extensibleMatchFilter.setMatchingRule(Strings.utf8ToString(tlv.getValue().getData()));
    }
}

